/* **************************************************************** *
 * Copyright PragmaDev
 * **************************************************************** *
 * This an example client program to send information to the
 * PragmaDev MSC tracer. It actually creates two threads,
 * communicating with each other via mutex semaphores simulating
 * messages.
 * You may use it safely with MSC tracer's GUI
 * **************************************************************** */

#include <stdio.h>
#include <pthread.h>
#include <string.h>
#include <stdlib.h>

#include "TracerSocketConnection.h"


#define NB_PINGPONG 10

/* Mutexes for messages mPing and mPong */
pthread_mutex_t mPing;
pthread_mutex_t mPong;
  

/* Function for thread pPing */
/* ------------------------- */

void *pPing(void *arg)
  {
  int i;  /* Loop variable to count number of sent messages */
  
  /* Send first message mPing by unlocking corresponding mutex */
  pthread_mutex_unlock(&mPing);
  /* Send message sent command to MscTracer */
  sendToTracer("messageSent| 0x01| 0| mPing|\n");

  /* Event loop */
  for( i = 0; i < NB_PINGPONG; i++ )
    {
    /* Wait for message mPong by trying to lock corresponding mutex */
    pthread_mutex_lock(&mPong);  
    /* Lock succeeded => message received; send trace command to MscTracer */
    sendToTracer("messageReceived| 0x01| 1| mPong|\n");
    /* Send message sent command to MscTracer */
    sendToTracer("messageSent| 0x01| 0| mPing|\n");
    /* Send message mPing by unlocking corresponding mutex */
    pthread_mutex_unlock(&mPing);
    }
  }


/* Function for thread pPong */
/* ------------------------- */

void *pPong(void *arg)
  {
  int i;    /* Loop variable to count number of sent messages */
  
  /* Event loop */
  for ( i = 0; i < NB_PINGPONG; i++ )
    {
    /* Wait for message mPing by trying to lock corresponding mutex */
    pthread_mutex_lock(&mPing);  
    /* Lock succeeded => message received; send trace command to MscTracer */
    sendToTracer("messageReceived| 0x02| 0| mPing|\n");
    /* Send message sent command to MscTracer */
    sendToTracer("messageSent| 0x02| 1| mPong|\n");
    /* Send message mPong by unlocking corresponding mutex */
    pthread_mutex_unlock(&mPong);
    }
  }


/* Main program */
/* ============ */

int main(int argc, char ** argv)
  {
  pthread_t           pPing_th, pPong_th;   /* Descriptors for threads pPing and pPong */
  int                 cr;                   /* Return code for operations */
  char                ipAddress[16];        /* IP address for server */
  unsigned short      portNumber;           /* Post number for socket to connect to */
  
  /* Create and lock mutexes for messages */
  pthread_mutex_init(&mPong, NULL);
  pthread_mutex_lock(&mPong); 

  pthread_mutex_init(&mPing, NULL);
  pthread_mutex_lock(&mPing); 

  /* Get port number and IP address from command line */
  if ( argc < 2 || argc > 3)
	{
	printf("Usage: %s [<IP address>] <port number>\n", argv[0]);
    exit(0);
	}
  else if ( argc == 3 )
	{
    strcpy(ipAddress, argv[1]);
	portNumber = atoi(argv[2]);
	}
  else
	{
	portNumber = atoi(argv[1]);
    strcpy(ipAddress, "127.0.0.1");  /* Address for localhost */
	}

  /* Connect to MSC tracer */
  if ( startTracing(ipAddress, portNumber) < 0 )
    {
    fprintf(stderr, "No connection to server!\n");
    exit(1);
    }
  printf("Connected...\n");

  /* Thread creations and corresponding commands to tracer */
  sendToTracer("taskCreated| -npPing| 0x01|\n");
  if ( pthread_create(&pPing_th, NULL, &pPing, NULL) )
    {
    fprintf(stderr, "Error in creation of thread pPing\n");
    exit(1);
    }

  sendToTracer("taskCreated| -npPong| 0x02|\n");
  if ( pthread_create(&pPong_th, NULL, &pPong, NULL) )
    {
    fprintf(stderr, "Error in creation of thread pPong\n");
    exit(1);
    }

  /* Wait for end of threads */
  pthread_join(pPing_th, NULL);
  pthread_join(pPong_th, NULL); 

  /* Close connection to tracer */
  endTracing();
  
  exit(0);
  }
