#!/bin/sh

# ============================================
# INSTALLATION SCRIPT FOR PRAGMADEV MSC TRACER
# ============================================
# Copyright (c) PragmaDev 2003
#
# History:
# ------------------------------------------------------------
# Version | Comment
# ------------------------------------------------------------
# 1.0     | Creation
# ------------------------------------------------------------

## Function reading a line from the terminal
getAnswer()
{
  ## Read from terminal
  read answer
  ## Quit if needed
  if [ "$answer" = "q" ]
  then
    exit 0
  fi
  ## Output answer
  echo $answer
}

## Welcome screen
cat <<.
=======================
MSC TRACER INSTALLATION
=======================
This script will install PragmaDev MSC Tracer.

Press return to continue or 'q' to quit.
.
getAnswer > /dev/null

## Architecture may be passed as an argument
arch=$1

## If it wasn't, try to figure it out
if [ "$arch" = "" ]
then
  case `uname -s` in

    Linux)
      arch='linux'
      ;;

    SunOS)
      arch='solaris'
      ;;
  esac
fi

## If architecture still not found or invalid, can't proceed
if [ "$arch" != "linux" -a "$arch" != "solaris" ]
then
  echo '!!! ERROR !!!'
  echo 'Unable to determine architecture.'
  echo 'You may try to re-run this installation script passing the architecture'
  echo 'as an argument. Valid architectures are "linux" and "solaris".'
  exit 1
fi

## Directory for install script is the mount point of the CD-ROM
rootDir=`dirname $0`

## Display license agreement
more $rootDir/doc/LICENSE.txt
echo ""
echo "To accept this license agreement, press return, or 'q' to quit the installation."
getAnswer > /dev/null

## Ask for installation directory
installDir=""
while [ "$installDir" = "" ]
do
  echo ""
  echo "Please enter the installation directory for MSC Tracer"
  echo "(default: /opt/pragmadev/msctracer; 'q' to quit)"
  installDir=`getAnswer`
  if [ "$installDir" = "" ]
  then
    installDir='/opt/pragmadev/msctracer'
  fi

  ## If installation directory already exists
  if [ -r "$installDir" ]
  then
    ## If it's not a directory, error...
    if [ ! -d "$installDir" ]
    then
      echo '!!! ERROR !!!'
      echo "File $installDir exists, but is not a directory. Please choose another"
      echo "location."
      echo ""
      echo "Press return to continue or 'q' to quit"
      getAnswer > /dev/null
      installDir=""
    else
      ## If directory is not writable, error
      if [ ! -w "$installDir" ]
      then
        echo '!!! ERROR !!!'
        echo "Directory $installDir exists, but is not writable. Please choose another"
        echo "location, or quit the installation and re-log as a user with sufficient"
        echo "rights to write in this directory"
        echo ""
        echo "Press return to continue or 'q' to quit"
        getAnswer > /dev/null
        installDir=""
      fi
    fi
  ## If installation directory does not exist, ask if we should create it
  else
    echo "Directory $installDir does not exist. Do you want to create it ([y]/n/q)?"
    answer=`getAnswer`
    if [ "$answer" != "n" ]
    then
      mkdir -p $installDir
      ## If creation failed
      if [ $? -ne 0 ]
      then
        echo '!!! ERROR !!!'
        echo "Could not create installation directory $installDir"
        echo "Make sure you have the appropriate rights or choose another directory"
        echo ""
        echo "Press return to continue or 'q' to quit"
        getAnswer > /dev/null
        installDir=""
      fi
    else
      installDir=""
    fi
  fi
done

## Confirmation screen
cat <<.

PragmaDev MSC Tracer will now be installed with the following
parameters:

 - Architecture: $arch
 
 - Installation directory: $installDir

PLEASE CHECK THE INFORMATIONS ABOVE. If you press return now, the MSC tracer
will be installed. If any of the informations above is not correct, press 'q'
and re-run the installation script from the beginning.

.
getAnswer > /dev/null

## Install binaries
echo '--- Installing MSC tracer binaries'
cd $rootDir
if [ ! -r $installDir/bin ]
then
  mkdir $installDir/bin
fi
cp -r bin/$arch/* $installDir/bin/

## Install documentation
echo '--- Installing MSC tracer documentation'
tar cf - doc | (cd $installDir ; tar xf -)

## Install common files
echo '--- Installing MSC tracer common files'
tar cf - share | (cd $installDir ; tar xf -)

## Install examples
echo '--- Installing MSC tracer example files'
tar cf - examples | (cd $installDir ; tar xf -)

## Done; display post-installation readme file
cat - $rootDir/doc/INSTALL-unix.txt <<. | more
--- Installation complete.

.
echo 'Press return'
read dummy

## Over
cat <<.

Installation completed successfully!

WARNING: to be able to run the MSC Tracer, each account must have defined the
environment variable MSCT_HOME to $installDir, and included the path to the
tracer binaries in its PATH and LD_LIBRARY_PATH environment variables

To do this:
 - on sh compatible shells (sh, ksh, bash), include in your .profile the lines:

   MSCT_HOME=$installDir
   PATH=\$MSCT_HOME/bin:"\$PATH"
   LD_LIBRARY_PATH=\$MSCT_HOME/bin:"\$LD_LIBRARY_PATH"
   export MSCT_HOME PATH LD_LIBRARY_PATH

 - on csh compatible shells (csh, tcsh), include in your .cshrc the line:

   setenv MSCT_HOME $installDir
   setenv PATH \$MSCT_HOME/bin:"\$PATH"
   setenv LD_LIBRARY_PATH \$MSCT_HOME/bin:"\$LD_LIBRARY_PATH"

Welcome to PragmaDev MSC Tracer!
.
exit 0
