/*
 * Decompiled with CFR 0.152.
 */
package obp2.runtime.core;

import java.util.function.Predicate;
import obp2.runtime.core.IAtomicPropositionsEvaluator;
import obp2.runtime.core.IAtomicPropositionsProvider;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.IMarshaller;
import obp2.runtime.core.ITransitionRelation;
import obp2.runtime.core.ITreeProjector;
import obp2.runtime.core.defaults.DefaultTreeProjector;
import obp2.runtime.core.empty.NoAtomicPropositionEvaluator;
import obp2.runtime.core.empty.NoAtomicPropositionsProvider;
import obp2.runtime.core.empty.NoMarshaller;
import obp2.runtime.core.empty.NoTransitionRelation;

public class LanguageModule<C, A, O>
implements ILanguageModule<C, A, O>,
AutoCloseable {
    public ITransitionRelation<C, A, O> transitionRelation;
    public IAtomicPropositionsEvaluator<C, A, O> atomicPropositionsEvaluator;
    public IAtomicPropositionsProvider<C, A, O> atomicPropositionsProvider;
    public ITreeProjector<C, A, O> treeProjector;
    public IMarshaller<C, A, O> marshaller;
    public Predicate<C> isAcceptingPredicate = c -> true;

    public LanguageModule(ITransitionRelation<C, A, O> transitionRelation, IAtomicPropositionsEvaluator<C, A, O> atomEvaluator, IAtomicPropositionsProvider<C, A, O> atomProvider, ITreeProjector<C, A, O> treeProjector, IMarshaller<C, A, O> marshaller, Predicate<C> isAcceptingPredicate) {
        this.transitionRelation = transitionRelation == null ? NoTransitionRelation.instance() : transitionRelation;
        this.atomicPropositionsEvaluator = atomEvaluator == null ? NoAtomicPropositionEvaluator.instance() : atomEvaluator;
        this.atomicPropositionsProvider = atomProvider == null ? NoAtomicPropositionsProvider.instance() : atomProvider;
        this.treeProjector = treeProjector == null ? new DefaultTreeProjector() : treeProjector;
        this.marshaller = marshaller == null ? NoMarshaller.instance() : marshaller;
        this.transitionRelation.setModule(this);
        this.atomicPropositionsEvaluator.setModule(this);
        this.atomicPropositionsProvider.setModule(this);
        this.treeProjector.setModule(this);
        this.marshaller.setModule(this);
        this.isAcceptingPredicate = isAcceptingPredicate;
    }

    public LanguageModule() {
        this(null, null, null, null, null, c -> true);
    }

    public LanguageModule(ITransitionRelation<C, A, O> transitionRelation) {
        this(transitionRelation, null, null, null, null, c -> true);
    }

    public LanguageModule(ITransitionRelation<C, A, O> transitionRelation, ITreeProjector<C, A, O> treeProjector) {
        this(transitionRelation, null, null, treeProjector, null, c -> true);
    }

    public LanguageModule(ITransitionRelation<C, A, O> transitionRelation, Predicate<C> isAcceptingPredicate) {
        this(transitionRelation, isAcceptingPredicate, null);
    }

    public LanguageModule(ITransitionRelation<C, A, O> transitionRelation, Predicate<C> isAcceptingPredicate, IMarshaller<C, A, O> marshaller) {
        this(transitionRelation, null, null, null, marshaller, isAcceptingPredicate);
    }

    public LanguageModule(ITransitionRelation<C, A, O> transitionRelation, IAtomicPropositionsEvaluator<C, A, O> atomicPropositionsEvaluator, ITreeProjector<C, A, O> treeProjector) {
        this(transitionRelation, atomicPropositionsEvaluator, null, treeProjector, null, c -> true);
    }

    public LanguageModule(ITransitionRelation<C, A, O> transitionRelation, IAtomicPropositionsEvaluator<C, A, O> atomicPropositionsEvaluator, ITreeProjector<C, A, O> treeProjector, IMarshaller<C, A, O> marshaller) {
        this(transitionRelation, atomicPropositionsEvaluator, null, treeProjector, marshaller, c -> true);
    }

    @Override
    public ITransitionRelation<C, A, O> getTransitionRelation() {
        return this.transitionRelation;
    }

    @Override
    public IAtomicPropositionsEvaluator<C, A, O> getAtomicPropositionEvaluator() {
        return this.atomicPropositionsEvaluator;
    }

    @Override
    public IAtomicPropositionsProvider<C, A, O> getAtomicPropositionsProvider() {
        return this.atomicPropositionsProvider;
    }

    @Override
    public ITreeProjector<C, A, O> getTreeProjector() {
        return this.treeProjector;
    }

    @Override
    public IMarshaller<C, A, O> getMarshaller() {
        return this.marshaller;
    }

    @Override
    public Predicate<C> isAcceptingPredicate() {
        return this.isAcceptingPredicate;
    }

    @Override
    public void close() throws Exception {
    }
}

