/*
 * Decompiled with CFR 0.152.
 */
package obp2.ui2.execution_units;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.stage.FileChooser;
import obp2.algorithms.buchi.nested_dfs.BA_GaiserSchwoon_Iterative;
import obp2.algorithms.reachability.BFSExplorer;
import obp2.algorithms.reachability.DFSExplorer;
import obp2.algorithms.verifiers.deadlock.DeadlockVerifier;
import obp2.core.execution.ControllerProviderFunction;
import obp2.core.execution.Execution;
import obp2.core.fx.IAppContext;
import obp2.core.fx.verification.ErrorsView;
import obp2.core.registry.LanguageModuleRegistry;
import obp2.language.buchikripke.runtime.KripkeBuchiPlugin;
import obp2.ui2.execution_units.ExecutionListCell2;
import org.kordamp.ikonli.javafx.FontIcon;

public class ExecutionListView
extends SplitPane {
    ObjectProperty<Path> modelPathProperty;
    ObjectProperty<Path> propertiesPathProperty;
    ObservableList<Execution> executionUnits = FXCollections.observableArrayList();
    protected final ObservableList<Throwable> errors = FXCollections.observableArrayList();

    public ExecutionListView(ObjectProperty<Path> modelPath, ObjectProperty<Path> propertiesPath, BooleanProperty modelChanged, BooleanProperty propertiesChanged, IAppContext appContext) {
        this.modelPathProperty = modelPath;
        this.propertiesPathProperty = propertiesPath;
        ListView executionUnitListView = new ListView();
        executionUnitListView.setCellFactory(list -> new ExecutionListCell2(appContext, this::errorHandler));
        Button runAll = new Button(null, (Node)new FontIcon("gmi-fast-forward"));
        runAll.setOnAction(ae -> executionUnitListView.getItems().forEach(e -> Platform.runLater(() -> {
            if (e.status == Execution.Status.CREATED) {
                e.initialize();
            }
            if (e.status != Execution.Status.INITIALIZED) {
                e.reset();
                e.initialize();
            }
            e.run();
            executionUnitListView.refresh();
        })));
        Button exportCSV = new Button(null, (Node)new FontIcon("gmi-file-download"));
        exportCSV.setOnAction(ae -> this.saveCSV((ObservableList<Execution>)executionUnitListView.getItems()));
        FlowPane menuFlowPane = new FlowPane();
        menuFlowPane.getChildren().addAll((Object[])new Node[]{runAll, exportCSV});
        BorderPane topPane = new BorderPane();
        topPane.setTop((Node)menuFlowPane);
        topPane.setCenter((Node)executionUnitListView);
        this.getItems().add((Object)topPane);
        ErrorsView errorsView = new ErrorsView(appContext, this.errors);
        this.setOrientation(Orientation.VERTICAL);
        this.setDividerPosition(0, 0.7);
        this.getItems().add((Object)errorsView);
        executionUnitListView.setItems(this.executionUnits);
        executionUnitListView.itemsProperty().bind((ObservableValue)Bindings.createObjectBinding(this::createExecutionsCallback, (Observable[])new Observable[]{modelPath, propertiesPath, modelChanged, propertiesChanged}));
    }

    void errorHandler(Execution execution) {
        Throwable exception = execution.getException();
        this.addError(exception);
    }

    ObservableList<Execution> createExecutionsCallback() {
        this.errors.clear();
        for (Execution execution : this.executionUnits) {
            execution.stop();
        }
        Path modelPath = (Path)this.modelPathProperty.get();
        if (modelPath == null) {
            return FXCollections.emptyObservableList();
        }
        ObservableList executions = FXCollections.observableArrayList();
        try {
            HashMap<String, ControllerProviderFunction> theAvailableExecutions = new HashMap<String, ControllerProviderFunction>(){
                {
                    this.put("BFS Explorer", BFSExplorer::new);
                    this.put("DFS Explorer", DFSExplorer::new);
                    this.put("Deadlock Verifier", DeadlockVerifier::bfs);
                }
            };
            if (Objects.requireNonNull(LanguageModuleRegistry.getInstance().getModuleByExtension(modelPath)).isOmegaRegular()) {
                theAvailableExecutions.put("Acceptance cycle detection", BA_GaiserSchwoon_Iterative::new);
            }
            Supplier modelSupplier = LanguageModuleRegistry.getLanguageModuleSupplier((Path)modelPath);
            for (Map.Entry executionModule : theAvailableExecutions.entrySet()) {
                Execution execution = new Execution((String)executionModule.getKey(), modelSupplier, (ControllerProviderFunction)executionModule.getValue());
                executions.add((Object)execution);
            }
            Path propertiesPath = (Path)this.propertiesPathProperty.get();
            if (propertiesPath == null) {
                return executions;
            }
            Map moduleMap = KripkeBuchiPlugin.getLanguageModuleSupplierMap((Path)modelPath, (Path)propertiesPath);
            for (Map.Entry entry : moduleMap.entrySet()) {
                Execution execution = new Execution((String)entry.getKey(), (Supplier)entry.getValue(), BA_GaiserSchwoon_Iterative::new);
                executions.add((Object)execution);
            }
        }
        catch (Throwable e) {
            this.addError(e);
            return FXCollections.emptyObservableList();
        }
        return executions;
    }

    void saveCSV(ObservableList<Execution> executions) {
        if (executions == null || executions.isEmpty()) {
            return;
        }
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV File", new String[]{"*.csv"}));
        File file = chooser.showSaveDialog(this.getScene().getWindow());
        if (file == null) {
            return;
        }
        try {
            Files.write(file.toPath(), this.toCSV(executions).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    String toCSV(ObservableList<Execution> executions) {
        ArrayList<String[]> table = new ArrayList<String[]>();
        String[] header = new String[]{"name", "configurations", "transitions", "loading", "elapsed", "status", "verification", "result"};
        table.add(header);
        for (Execution execution : executions) {
            table.add(this.executionCSV(execution));
        }
        return table.stream().map(line -> String.join((CharSequence)"; ", line) + "\n").reduce(String::concat).get();
    }

    String[] executionCSV(Execution execution) {
        return new String[]{execution.getName(), String.valueOf(execution.configurationCount()), String.valueOf(execution.stepCount()), String.valueOf(execution.getLoadingTime()), String.valueOf(execution.getElapsedTime()), String.valueOf(execution.status()), String.valueOf(execution.verificationStatus()), String.valueOf(execution.resultStatus())};
    }

    public void addError(Throwable e) {
        Throwable root = e;
        while (root.getCause() != null && (root = root.getCause()) != null) {
        }
        for (Throwable error : this.errors) {
            if (root == null) {
                throw new AssertionError();
            }
            if (error.getClass() != root.getClass() || !Objects.equals(error.getMessage(), root.getMessage())) continue;
            return;
        }
        this.errors.add((Object)root);
    }
}

