/*
 * Decompiled with CFR 0.152.
 */
package announce4j;

import announce4j.ISubscription;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SubscriptionRegistry {
    public final boolean isOrdered;
    private Collection<ISubscription<?>> subscriptions;

    public SubscriptionRegistry() {
        this.isOrdered = false;
        this.reset();
    }

    public SubscriptionRegistry(boolean isOrdered) {
        this.isOrdered = isOrdered;
        this.reset();
    }

    public synchronized ISubscription<?> add(ISubscription<?> subscription) {
        this.subscriptions.add(subscription);
        return subscription;
    }

    synchronized ISubscription<?> remove(ISubscription<?> subscription) {
        this.subscriptions.remove(subscription);
        return subscription;
    }

    public synchronized Collection<ISubscription<?>> remove(Object subscriber) {
        this.subscriptions = this.subscriptions.stream().filter(subscription -> subscription.getSubscriber() != subscriber).collect(Collectors.toList());
        return this.subscriptions;
    }

    synchronized ISubscription<?> replace(ISubscription<?> oldOne, ISubscription<?> newOne) {
        this.subscriptions.remove(oldOne);
        this.subscriptions.add(newOne);
        return newOne;
    }

    void reset() {
        this.subscriptions = this.isOrdered ? new LinkedList() : Collections.newSetFromMap(new IdentityHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> SubscriptionRegistry deliver(T announce) {
        if (this.subscriptions.isEmpty()) {
            return this;
        }
        SubscriptionRegistry subscriptionRegistry = this;
        synchronized (subscriptionRegistry) {
            Stream<ISubscription<?>> interestedSubscriptions = this.interestedSubscribers(announce);
            this.deliver(announce, interestedSubscriptions);
        }
        return this;
    }

    private <T> Stream<ISubscription<?>> interestedSubscribers(T announce) {
        return this.subscriptions.stream().filter(subscription -> subscription.isHandlingAnnouncement(announce));
    }

    private <T> void deliver(T announce, Stream<ISubscription<?>> interestedSubscriptions) {
        interestedSubscriptions.forEachOrdered(subscription -> subscription.handle(announce));
    }

    public int size() {
        return this.subscriptions.size();
    }
}

