/*
 * Decompiled with CFR 0.152.
 */
package properties.LTL.builder;

import properties.LTL.LTLModel.Eventually;
import properties.LTL.LTLModel.Globally;
import properties.LTL.LTLModel.LTLModelFactory;
import properties.LTL.LTLModel.Next;
import properties.LTL.LTLModel.StrongRelease;
import properties.LTL.LTLModel.StrongUntil;
import properties.LTL.LTLModel.WeakRelease;
import properties.LTL.LTLModel.WeakUntil;
import properties.PropositionalLogic.PropositionalLogicModel.Atom;
import properties.PropositionalLogic.PropositionalLogicModel.Expression;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionDeclaration;
import properties.PropositionalLogic.PropositionalLogicModel.False;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalConjunction;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalDisjunction;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalEquivalence;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalImplication;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalNegation;
import properties.PropositionalLogic.PropositionalLogicModel.PropositionalLogicModelFactory;
import properties.PropositionalLogic.PropositionalLogicModel.True;

public class LTLBuilder {
    public static final LTLBuilder instance = new LTLBuilder();
    LTLModelFactory ltlFactory = LTLModelFactory.eINSTANCE;
    PropositionalLogicModelFactory propFactory = PropositionalLogicModelFactory.eINSTANCE;

    public Atom atom(String code, String language) {
        Atom at = this.propFactory.createAtom();
        at.setCode(code);
        at.setLanguage(language);
        return at;
    }

    public Atom atom(String code) {
        return this.atom(code, null);
    }

    public True ltlTrue() {
        return this.propFactory.createTrue();
    }

    public False ltlFalse() {
        return this.propFactory.createFalse();
    }

    public LogicalConjunction conjunction(Expression lhs, Expression rhs) {
        LogicalConjunction exp = this.propFactory.createLogicalConjunction();
        exp.setLhs(lhs);
        exp.setRhs(rhs);
        return exp;
    }

    public LogicalConjunction and(Expression lhs, Expression rhs) {
        return this.conjunction(lhs, rhs);
    }

    public LogicalDisjunction disjunction(Expression lhs, Expression rhs) {
        LogicalDisjunction exp = this.propFactory.createLogicalDisjunction();
        exp.setLhs(lhs);
        exp.setRhs(rhs);
        return exp;
    }

    public LogicalDisjunction or(Expression lhs, Expression rhs) {
        return this.disjunction(lhs, rhs);
    }

    public LogicalEquivalence equivalence(Expression lhs, Expression rhs) {
        LogicalEquivalence exp = this.propFactory.createLogicalEquivalence();
        exp.setLhs(lhs);
        exp.setRhs(rhs);
        return exp;
    }

    public LogicalImplication implication(Expression lhs, Expression rhs) {
        LogicalImplication exp = this.propFactory.createLogicalImplication();
        exp.setLhs(lhs);
        exp.setRhs(rhs);
        return exp;
    }

    public StrongRelease strongRelease(Expression lhs, Expression rhs) {
        StrongRelease exp = this.ltlFactory.createStrongRelease();
        exp.setLhs(lhs);
        exp.setRhs(rhs);
        return exp;
    }

    public WeakRelease weakRelease(Expression lhs, Expression rhs) {
        WeakRelease exp = this.ltlFactory.createWeakRelease();
        exp.setLhs(lhs);
        exp.setRhs(rhs);
        return exp;
    }

    public StrongUntil strongUntil(Expression lhs, Expression rhs) {
        StrongUntil exp = this.ltlFactory.createStrongUntil();
        exp.setLhs(lhs);
        exp.setRhs(rhs);
        return exp;
    }

    public WeakUntil weakUntil(Expression lhs, Expression rhs) {
        WeakUntil exp = this.ltlFactory.createWeakUntil();
        exp.setLhs(lhs);
        exp.setRhs(rhs);
        return exp;
    }

    public LogicalNegation negation(Expression value) {
        LogicalNegation exp = this.propFactory.createLogicalNegation();
        exp.setOperand(value);
        return exp;
    }

    public LogicalNegation not(Expression value) {
        return this.negation(value);
    }

    public Eventually eventually(Expression value) {
        Eventually exp = this.ltlFactory.createEventually();
        exp.setOperand(value);
        return exp;
    }

    public Globally globally(Expression value) {
        Globally exp = this.ltlFactory.createGlobally();
        exp.setOperand(value);
        return exp;
    }

    public Next next(Expression value) {
        Next exp = this.ltlFactory.createNext();
        exp.setOperand(value);
        return exp;
    }

    public ExpressionDeclaration formula(String name, Expression value) {
        ExpressionDeclaration formula = this.propFactory.createExpressionDeclaration();
        formula.setName(name);
        formula.setExpression(value);
        return formula;
    }
}

