/*
 * Decompiled with CFR 0.152.
 */
package obp2.hash;

import java.security.NoSuchAlgorithmException;
import java.util.Random;
import obp2.hash.ExternalHash;

public class FastHash
extends ExternalHash {
    public static native long hash64(byte[] var0, long var1);

    public static native int hash32(byte[] var0, int var1);

    private static long testFastHash64(int nb_bytes, int runs) {
        byte[] bytes = new byte[nb_bytes];
        Random rnd = new Random();
        long hash = 0L;
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < runs; i += 2) {
            rnd.nextBytes(bytes);
            hash = FastHash.hash64(bytes, rnd.nextLong());
        }
        long endTime = System.currentTimeMillis();
        System.out.println("FastHash_hash64 (" + nb_bytes + ", " + runs + ") took " + (endTime - startTime) + " milliseconds");
        return hash;
    }

    private static long testFastHash32(int nb_bytes, int runs) {
        byte[] bytes = new byte[nb_bytes];
        Random rnd = new Random();
        long hash = 0L;
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < runs; i += 2) {
            rnd.nextBytes(bytes);
            hash = FastHash.hash32(bytes, rnd.nextInt());
        }
        long endTime = System.currentTimeMillis();
        System.out.println("FastHash_hash32 (" + nb_bytes + ", " + runs + ") took " + (endTime - startTime) + " milliseconds");
        return hash;
    }

    public static void main(String[] args) throws NoSuchAlgorithmException {
        int size = 50000;
        int runs = 10000;
        FastHash.testFastHash64(size, runs);
        FastHash.testFastHash32(size, runs);
        FastHash.testArraysHashCode(size, runs);
    }
}

