/*
 * Decompiled with CFR 0.152.
 */
package obp2.folding.runtime;

import announce4j.Announcer;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import obp2.core.IProductAutomaton;
import obp2.core.IStateSpaceManager;
import obp2.core.execution.IExecutionController;
import obp2.core.execution.IExecutionMonitor;
import obp2.events.OpenConfigurationEvent;
import obp2.folding.runtime.PreinitializedRuntime;
import obp2.folding.runtime.PruningRuntime;
import obp2.runtime.core.ITransitionRelation;

public class FoldingExecutionController<C, A, O>
implements IExecutionController<C, A> {
    protected final IExecutionMonitor.Simple monitor = new IExecutionMonitor.Simple();
    ITransitionRelation<C, A, O> baseRuntime;
    Function<ITransitionRelation<C, A, O>, IExecutionController<C, A>> controllerSupplier;
    IExecutionController<C, A> currentExecutionControler;
    Predicate<C> foldingPredicate;
    Set<C> foldingOutputs;

    public FoldingExecutionController(C configuration, ITransitionRelation<C, A, O> baseRuntime, Predicate<C> foldingPredicate, Function<ITransitionRelation<C, A, O>, IExecutionController<C, A>> controllerSupplier) {
        this.baseRuntime = baseRuntime;
        this.foldingPredicate = foldingPredicate;
        PreinitializedRuntime<C, A, O> initializedRuntime = new PreinitializedRuntime<C, A, O>(baseRuntime, Collections.singleton(configuration));
        PruningRuntime<C, A, O> prunningRuntime = new PruningRuntime<C, A, O>(initializedRuntime, foldingPredicate.negate());
        this.currentExecutionControler = controllerSupplier.apply(prunningRuntime);
        this.currentExecutionControler.getAnnouncer().when(OpenConfigurationEvent.class, this::addFoldingOutput);
        this.foldingOutputs = new HashSet<C>();
    }

    private void addFoldingOutput(Announcer ann, OpenConfigurationEvent<C> oce) {
        Object config = oce.getConfiguration();
        if (this.foldingPredicate.negate().test(config)) {
            this.foldingOutputs.add(config);
        }
    }

    public void execute() {
        this.currentExecutionControler.execute();
    }

    public Announcer getAnnouncer() {
        return this.currentExecutionControler.getAnnouncer();
    }

    public IStateSpaceManager<C, A, Object> getStateSpaceManager() {
        return this.currentExecutionControler.getStateSpaceManager();
    }

    public ITransitionRelation<C, A, Object> getRuntime() {
        return this.currentExecutionControler.getRuntime();
    }

    public IProductAutomaton<C, A> getProductAutomaton() {
        return null;
    }

    public IExecutionMonitor.Simple getMonitor() {
        return this.monitor;
    }

    public BigInteger configurationCount() {
        return BigInteger.valueOf(this.getStateSpaceManager().size());
    }

    public BigInteger stepCount() {
        return BigInteger.valueOf(this.getStateSpaceManager().transitionCount());
    }
}

