/*
 * Decompiled with CFR 0.152.
 */
package obp2.folding.runtime;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import obp2.core.IFiredTransition;
import obp2.core.defaults.FiredTransition;
import obp2.core.execution.IExecutionController;
import obp2.folding.runtime.FoldedTransition;
import obp2.folding.runtime.FoldingExecutionController;
import obp2.runtime.core.ITransitionRelation;
import obp2.runtime.core.defaults.DefaultLanguageService;

public class FoldingRuntime<C, A, O>
extends DefaultLanguageService<C, A, O>
implements ITransitionRelation<C, A, O> {
    public ITransitionRelation<C, A, O> baseRuntime;
    Predicate<C> foldingPredicate;
    Function<ITransitionRelation<C, A, O>, IExecutionController<C, A>> controllerSupplier;

    public FoldingRuntime(ITransitionRelation<C, A, O> baseRuntime, Predicate<C> foldingPredicate, Function<ITransitionRelation<C, A, O>, IExecutionController<C, A>> controllerSupplier) {
        this.baseRuntime = baseRuntime;
        this.foldingPredicate = foldingPredicate;
        this.controllerSupplier = controllerSupplier;
    }

    public Set<C> initialConfigurations() {
        return this.baseRuntime.initialConfigurations();
    }

    public Collection<A> fireableTransitionsFrom(C source) {
        return this.baseRuntime.fireableTransitionsFrom(source);
    }

    public IFiredTransition<C, A, O> fireOneTransition(C source, A transition) {
        IFiredTransition fired = this.baseRuntime.fireOneTransition(source, transition);
        if (fired == null) {
            return null;
        }
        HashSet<Object> targets = new HashSet<Object>();
        for (Object target : fired.getTargets()) {
            if (this.foldingPredicate.test(target)) {
                FoldingExecutionController controller = new FoldingExecutionController(target, this.baseRuntime, this.foldingPredicate, this.controllerSupplier);
                controller.execute();
                if (controller.getStateSpaceManager().size() > 50) {
                    System.out.println("Fold size : " + controller.getStateSpaceManager().size());
                }
                targets.addAll(controller.foldingOutputs);
                return new FoldedTransition<C, A>(source, controller.foldingOutputs, transition);
            }
            targets.add(target);
        }
        return new FiredTransition(source, targets, transition);
    }

    public boolean hasBlockingTransitions() {
        return this.baseRuntime.hasBlockingTransitions();
    }
}

