/*
 * Decompiled with CFR 0.152.
 */
package obp2.algorithms.verifiers.predicates;

import announce4j.Announcer;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import obp2.algorithms.verifiers.predicates.PredicateViolationEvent;
import obp2.algorithms.verifiers.predicates.PredicatesVerifiedEvent;
import obp2.algorithms.verifiers.predicates.PredicatesViolatedEvent;
import obp2.events.ExecutionEndedEvent;
import obp2.events.ExecutionStartedEvent;
import obp2.events.FiredEvent;

public class PredicateVerifier<C> {
    public Announcer announcer = new Announcer(true);
    public List<Predicate<C>> predicates = new LinkedList<Predicate<C>>();
    public Map<Predicate<C>, C> violations = new IdentityHashMap<Predicate<C>, C>();

    public PredicateVerifier(Announcer announcer) {
        announcer.when(ExecutionStartedEvent.class, this::onExecutionStartedEvent);
        announcer.when(ExecutionEndedEvent.class, this::onExecutionEndedEvent);
        announcer.when(FiredEvent.class, this::onFiredEvent);
    }

    protected void onExecutionStartedEvent(Announcer ann, ExecutionStartedEvent<C> event) {
        for (Object configuration : event.getInitialConfigurations()) {
            this.verify(configuration);
        }
    }

    protected void onExecutionEndedEvent(Announcer ann, ExecutionEndedEvent event) {
        if (this.violations.isEmpty()) {
            this.announcer.announce((Object)new PredicatesVerifiedEvent(this));
        } else {
            this.announcer.announce((Object)new PredicatesViolatedEvent(this));
        }
    }

    protected void onFiredEvent(Announcer ann, FiredEvent<C, ?, ?> event) {
        this.verifyAll(event.getFiredTransition().getTargets());
    }

    protected void verifyAll(Collection<C> configurations) {
        for (C configuration : configurations) {
            this.verify(configuration);
        }
    }

    protected void verify(C configuration) {
        for (int index = 0; index < this.predicates.size(); ++index) {
            if (this.verify(this.predicates.get(index), configuration)) continue;
            Predicate<C> violated = this.predicates.remove(index);
            this.violations.put(violated, configuration);
            this.announcer.announce(new PredicateViolationEvent<C>(this, violated, configuration));
        }
    }

    protected boolean verify(Predicate<C> predicate, C configuration) {
        return predicate.test(configuration);
    }
}

