/*
 * Decompiled with CFR 0.152.
 */
package obp2.core.execution;

import announce4j.Announcer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import obp2.algorithms.verifiers.deadlock.FinalStateDetected;
import obp2.core.IConfiguration;
import obp2.core.IGraphAccess;
import obp2.core.IStateSpaceManager;
import obp2.core.execution.ControllerProviderFunction;
import obp2.core.execution.IExecutionController;
import obp2.events.ExecutionEndedEvent;
import obp2.events.PropertyEvent;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.ITransitionRelation;
import obp2.runtime.core.ITreeProjector;
import obp2.simulation.trace_storage.TraceStore;
import obp2.statespace.SimpleStateSpaceManager;
import obp2.statespace.graph.FullTransitionStorage;
import obp2.statespace.graph.ParentTransitionStorage;
import plug.utils.graph.IGraph;
import plug.utils.graph.algorithms.DijkstraShortestPath;

public class Execution
implements AutoCloseable {
    public Status status = Status.CREATED;
    protected final String name;
    Supplier<ILanguageModule> moduleSupplier;
    ControllerProviderFunction description;
    ITransitionRelation transitionRelation;
    ITreeProjector runtimeView;
    IExecutionController controller;
    TransitionStorageType transitionStorageType;
    public TraceStore traceStore = new TraceStore();
    protected Thread thread;
    Throwable exception;
    PropertyEvent violation;
    protected long loadingTime = 0L;
    boolean firstAcceptAllOK = false;
    Set<Object> acceptAllSet = new HashSet<Object>();
    boolean checkAcceptAll = true;
    protected long startTime = 0L;
    protected long endTime = 0L;

    public Execution(String name, Supplier<ILanguageModule> moduleSupplier, ControllerProviderFunction description) {
        this(name, moduleSupplier, description, TransitionStorageType.PARENT);
    }

    public Execution(String name, Supplier<ILanguageModule> moduleSupplier, ControllerProviderFunction description, TransitionStorageType transitionStorageType) {
        this.name = name;
        this.moduleSupplier = moduleSupplier;
        this.description = description;
        this.transitionStorageType = transitionStorageType;
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.transitionRelation != null) {
            this.transitionRelation.getModule().close();
        }
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized Status status() {
        return this.status;
    }

    public synchronized PropertyEvent getViolation() {
        return this.violation;
    }

    public synchronized Throwable getException() {
        return this.exception;
    }

    public ITransitionRelation getTransitionRelation() {
        if (this.status != Status.INITIALIZED) {
            this.initialize();
        }
        return this.transitionRelation;
    }

    public synchronized ITreeProjector getRuntimeView() {
        if (this.status != Status.INITIALIZED) {
            this.initialize();
        }
        return this.runtimeView;
    }

    public synchronized void initialize() {
        if (this.status != Status.CREATED && this.status != Status.FAILED) {
            return;
        }
        try {
            long startLoading = System.currentTimeMillis();
            ILanguageModule languageModule = this.moduleSupplier.get();
            this.transitionRelation = languageModule.getTransitionRelation();
            this.runtimeView = languageModule.getTreeProjector();
            SimpleStateSpaceManager stateSpaceManager = new SimpleStateSpaceManager();
            switch (this.transitionStorageType) {
                case FULL: {
                    stateSpaceManager.fullTransitionStorage();
                    break;
                }
                case PARENT: {
                    stateSpaceManager.parentTransitionStorage();
                    break;
                }
                case COUNTING: {
                    stateSpaceManager.countingTransitionStorage();
                    break;
                }
                case NONE: {
                    break;
                }
            }
            this.controller = this.description.createController(this.transitionRelation, (IStateSpaceManager)stateSpaceManager);
            this.loadingTime = System.currentTimeMillis() - startLoading;
        }
        catch (Throwable e) {
            this.exception = e;
            this.status = Status.FAILED;
            return;
        }
        this.status = this.transitionRelation == null || this.controller == null ? Status.FAILED : Status.INITIALIZED;
    }

    public synchronized Thread run() {
        if (this.status != Status.INITIALIZED) {
            return null;
        }
        try {
            this.thread = new Thread(this::runnerThread);
            this.status = Status.RUNNING;
            this.thread.start();
        }
        catch (Throwable e) {
            this.exception = e;
            if (this.transitionRelation != null) {
                try {
                    this.transitionRelation.getModule().close();
                }
                catch (Exception ee) {
                    e.printStackTrace();
                }
            }
            this.status = Status.FAILED;
            return null;
        }
        return this.thread;
    }

    public synchronized void pause() {
        if (this.status != Status.RUNNING) {
            return;
        }
        this.controller.getMonitor().pause();
        this.status = Status.PAUSED;
    }

    public synchronized void resume() {
        if (this.status != Status.PAUSED) {
            return;
        }
        this.controller.getMonitor().resume();
        this.status = Status.RUNNING;
    }

    public synchronized void stop() {
        if (this.status != Status.PAUSED && this.status != Status.RUNNING) {
            return;
        }
        this.controller.getMonitor().hasToFinish();
        this.status = Status.STOPPED;
    }

    public synchronized void reset() {
        if (this.status != Status.STOPPED && this.status != Status.FAILED && this.status != Status.FINISHED) {
            return;
        }
        if (this.transitionRelation != null) {
            try {
                this.transitionRelation.getModule().close();
            }
            catch (Exception e) {
                this.exception = e;
                this.status = Status.FAILED;
                return;
            }
        }
        this.controller = null;
        this.traceStore = new TraceStore();
        this.endTime = 0L;
        this.startTime = 0L;
        this.exception = null;
        this.violation = null;
        this.thread = null;
        this.status = Status.CREATED;
    }

    public synchronized void hardReset() {
        try {
            this.controller.getMonitor().hasToFinish();
            if (this.transitionRelation != null) {
                this.transitionRelation.getModule().close();
            }
            this.controller = null;
            this.traceStore = new TraceStore();
            this.endTime = 0L;
            this.startTime = 0L;
            this.exception = null;
            this.violation = null;
            this.thread = null;
        }
        catch (Throwable e) {
            this.exception = e;
            this.status = Status.FAILED;
            return;
        }
        this.status = Status.CREATED;
    }

    boolean notInAcceptAll(Object c) {
        if (!this.checkAcceptAll) {
            return true;
        }
        if (c.getClass().getCanonicalName().equals("obp2.language.buchikripke.runtime.KripkeBuchiConfiguration")) {
            try {
                Class<?> kripkeBuchiPluginClass = Class.forName("obp2.language.buchikripke.runtime.KripkeBuchiPlugin");
                Method isInAcceptAllMethod = kripkeBuchiPluginClass.getMethod("isInAcceptAll", Object.class, Object.class, Set.class);
                boolean isInAcceptAll = (Boolean)isInAcceptAllMethod.invoke(null, c, this.transitionRelation.getModule(), this.acceptAllSet);
                if (this.acceptAllSet.isEmpty()) {
                    this.checkAcceptAll = false;
                    return true;
                }
                if (isInAcceptAll) {
                    if (this.firstAcceptAllOK) {
                        return false;
                    }
                    this.firstAcceptAllOK = true;
                    return true;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                this.checkAcceptAll = false;
                return true;
            }
        }
        return true;
    }

    void runnerThread() {
        Announcer announcer = this.controller.getAnnouncer();
        announcer.when(ExecutionEndedEvent.class, (a, event) -> {
            this.endTime = System.currentTimeMillis();
            this.status = Status.FINISHED;
            this.traceStore.noCounterExample();
        });
        announcer.when(PropertyEvent.class, (a, event) -> {
            if (!event.isVerified()) {
                this.controller.getMonitor().hasToFinish();
                this.violation = event;
                this.endTime = System.currentTimeMillis();
                this.status = Status.FINISHED;
                this.firstAcceptAllOK = false;
                this.traceStore.addSteps(Collections.emptyList(), event.getCounterExample().stream().filter(this::notInAcceptAll).collect(Collectors.toList()), (arg_0, arg_1) -> ((ITransitionRelation)this.transitionRelation).transitionFromSourceToTarget(arg_0, arg_1));
                this.traceStore.setHasCounterExample();
            }
        });
        announcer.when(FinalStateDetected.class, (a, event) -> {
            this.controller.getMonitor().hasToFinish();
            this.endTime = System.currentTimeMillis();
            SimpleStateSpaceManager stateSpaceManager = (SimpleStateSpaceManager)this.controller.getStateSpaceManager();
            List<IConfiguration> counterExample = null;
            if (stateSpaceManager.transitionStorage instanceof FullTransitionStorage) {
                counterExample = new DijkstraShortestPath().getShortestPath((IGraph)stateSpaceManager.getGraphView(), (Collection)stateSpaceManager.initialConfigurations(), (Object)event.getFinalState());
            } else if (stateSpaceManager.transitionStorage instanceof ParentTransitionStorage) {
                counterExample = new ArrayList<IConfiguration>();
                counterExample.add(event.getFinalState());
                IGraphAccess graph = stateSpaceManager.getGraphView();
                IConfiguration current = event.getFinalState();
                while (current != null && !stateSpaceManager.initialConfigurations().contains(current)) {
                    IConfiguration parent = (IConfiguration)graph.getParent((Object)current);
                    if (parent != null) {
                        counterExample.add(parent);
                    }
                    current = parent;
                }
                Collections.reverse(counterExample);
            }
            PropertyEvent deadlock = new PropertyEvent(this.controller, false, "deadlock", counterExample);
            this.controller.getAnnouncer().announce((Object)deadlock);
        });
        try {
            this.startTime = System.currentTimeMillis();
            this.controller.execute();
        }
        catch (Throwable e) {
            this.exception = e;
            this.status = Status.FAILED;
            return;
        }
    }

    public synchronized long getElapsedTime() {
        if (this.startTime == 0L) {
            return 0L;
        }
        if (this.endTime == 0L) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.endTime - this.startTime;
    }

    public synchronized long getLoadingTime() {
        return this.loadingTime;
    }

    public synchronized BigInteger configurationCount() {
        if (this.controller == null) {
            return BigInteger.ZERO;
        }
        return this.controller.configurationCount();
    }

    public synchronized BigInteger stepCount() {
        if (this.controller == null) {
            return BigInteger.ZERO;
        }
        return this.controller.stepCount();
    }

    public synchronized String getDetails() {
        BigInteger size;
        if (this.status == Status.CREATED) {
            return "initializing";
        }
        if (this.status == Status.INITIALIZED) {
            return "no results";
        }
        StringBuilder result = new StringBuilder();
        if (this.status == Status.FAILED || this.status == Status.STOPPED) {
            result.append("Incomplete ");
        }
        if (this.status == Status.FINISHED) {
            result.append("Finished ");
        }
        if (!(size = this.configurationCount()).equals(BigInteger.ZERO)) {
            result.append(size + " configurations ");
            BigInteger stepCount = this.stepCount();
            if (!stepCount.equals(0)) {
                result.append(stepCount + " transitions ");
            }
            result.append("in " + this.getElapsedTime() + " ms");
        }
        return result.toString();
    }

    public synchronized VerificationStatus verificationStatus() {
        if (this.status != Status.FINISHED) {
            return VerificationStatus.UNKNOWN;
        }
        if (this.violation == null) {
            return VerificationStatus.SATISFIED;
        }
        return VerificationStatus.VIOLATED;
    }

    public synchronized CompletenessStatus resultStatus() {
        if (this.status == Status.FINISHED) {
            return CompletenessStatus.COMPLETE;
        }
        return CompletenessStatus.INCOMPLETE;
    }

    public synchronized IGraphAccess getGraphView() {
        if (this.controller == null || this.controller.getStateSpaceManager() == null) {
            return null;
        }
        return this.controller.getStateSpaceManager().getGraphView();
    }

    public static enum CompletenessStatus {
        COMPLETE,
        INCOMPLETE;

    }

    public static enum VerificationStatus {
        SATISFIED,
        VIOLATED,
        UNKNOWN;

    }

    public static enum Status {
        CREATED,
        INITIALIZED,
        RUNNING,
        PAUSED,
        STOPPED,
        FINISHED,
        FAILED;

    }

    public static enum TransitionStorageType {
        NONE,
        COUNTING,
        PARENT,
        FULL;

    }
}

