#ifndef _RTDS_SEMAPHORE_TAKE_PROCEDURE_H_
#define _RTDS_SEMAPHORE_TAKE_PROCEDURE_H_

#include "RTDS_Proc.h"
#include "RTDS_InternalConstants.h"

/*
** PROCEDURE RTDS_SemaphoreTakeProcedure:
** --------------------------------------
** Internal procedure for semaphore take in completely scheduled system
*/

class RTDS_SemaphoreTakeProcedure : public RTDS_Proc
  {
  public:
    RTDS_SdlInstanceId  * semaphore_id;
    long                  time_out;
    int                   RTDS_return_value;
    

    // Entry point for all transitions:
    short RTDS_executeTransition(RTDS_MessageHeader * currentMessage);

    // Entry point for transitions for continuous signals:
    short RTDS_continuousSignals(int * lowestPriority);

    // Constructor:
    RTDS_SemaphoreTakeProcedure(RTDS_Scheduler * parentScheduler, RTDS_SdlInstanceId * _semaphore_id, long _time_out);
  };

#else

class RTDS_SemaphoreTakeProcedure;

#endif
