#ifndef _RTDS_TTCN_H_
#define _RTDS_TTCN_H_

#include <RTDS_BasicTypes.h>
#include <RTDS_Common.h>
#include <tci/tci.h>
#include "RTDS_String.h"


class RTDS_TTCN_Template
  {
  };


typedef enum
  {
  RTDS_MAP      = 0,
  RTDS_CONNECT  = 1,
  RTDS_SYS      = 2   // for system and timer
  } RTDS_TTCN_ConnectionType;
  
  
typedef struct RTDS_TTCN_PortIdList
  {
  TriPortId                     * portId;
  struct RTDS_TTCN_PortIdList   * next;
  } RTDS_TTCN_PortIdList;


typedef struct RTDS_TTCN_TimerInfo
  {
  long              timerID;
  int               timerNumber;
  unsigned long     timerUniqueID;
  TriTimerDuration  duration;
  TriTimerDuration  timeoutValue;
  TimerStatusType   timerStatus;
  } RTDS_TTCN_TimerInfo;


typedef struct RTDS_TTCN_TimerInfoList
  {
  RTDS_TTCN_TimerInfo               * timerInfo;
  struct RTDS_TTCN_TimerInfoList    * next;
  } RTDS_TTCN_TimerInfoList;


typedef struct RTDS_TTCN_PortMappingInfo
  {
  RTDS_RtosQueueId                    queueControlBlock;
  RTDS_MessageHeader                * currentMessage;
  RTDS_TTCN_ConnectionType            connectionType;
  PortStatusType                      portStatus;
  TriPortId                         * portId;
  RTDS_TTCN_PortIdList              * mappedPort;
  struct RTDS_TTCN_PortMappingInfo  * next;
  } RTDS_TTCN_PortMappingInfo;
  
  
typedef struct RTDS_TTCN_Template_Pool
  {
  RTDS_TTCN_Template        * templateID;
  RTDS_TTCN_Template_Pool   * next;
  } RTDS_TTCN_Template_Pool;
  

typedef struct RTDS_TTCN_GlobalComponentInfo
  {
  TriComponentId                        * componentID;
  TciTestComponentKindType                componentKindType;
  ComponentStatusType                     componentStatus;
  verdicttype                             componentVerdict;
  RTDS_GlobalProcessInfo                * RTDS_currentContext;
  RTDS_TTCN_PortMappingInfo             * portMappingInfo;
  RTDS_TTCN_Template_Pool               * templatePool;
  RTDS_TTCN_TimerInfoList               * timerInfoList;
  void                                  * cmpVariables;
  struct RTDS_TTCN_GlobalComponentInfo  * next;
  } RTDS_TTCN_GlobalComponentInfo;
  

typedef RTDS_TTCN_TimerInfo * RTDS_TIMER;

/* Global list for component info */
extern RTDS_TTCN_GlobalComponentInfo * RTDS_TTCN_globalComponentInfo;

/* Type for a port in the system interface */
typedef struct _RTDS_TTCN_SystemInterfacePort
  {
  char                                  * portName;
  RTDS_RtosQueueId                        portMessageQueue;
  struct _RTDS_TTCN_SystemInterfacePort * next;
  } RTDS_TTCN_SystemInterfacePort;

/* Global variable for all ports in system interface */
extern RTDS_TTCN_SystemInterfacePort * RTDS_TTCN_systemInterfacePorts;


#ifdef __cplusplus
extern "C" {
#endif

// Function prototypes

void RTDS_TTCN_Init(void);


/******************************************************************
 *        TEMPLATE FUNCTIONS
 * ----------------------------------------------------------------
 *    Functions for template operations
 *
 *******************************************************************/

RTDS_TTCN_Template * RTDS_TTCN_RegisterTemplatePool( RTDS_TTCN_GlobalComponentInfo * RTDS_TTCNcurrentComponentInfo , RTDS_TTCN_Template * RTDS_New_Template);


/******************************************************************
 *        STATUS FUNCTIONS
 * ----------------------------------------------------------------
 *    Functions call to check component status
 *
 *******************************************************************/

void RTDS_TTCN_SetStatus( RTDS_SdlInstanceId * Component2Set, ComponentStatusType status );
int RTDS_TTCN_CheckAlive( RTDS_SdlInstanceId * Component2test );
int RTDS_TTCN_CheckRunning( RTDS_SdlInstanceId * Component2test );
int RTDS_TTCN_CheckStopped( RTDS_SdlInstanceId * Component2test );
int RTDS_TTCN_CheckKilled( RTDS_SdlInstanceId * Component2test );


/******************************************************************
 *        TIMER FUNCTIONS
 * ----------------------------------------------------------------
 *    Functions call to check timer status
 *
 *******************************************************************/

int RTDS_TTCN_CheckAnyTimerRunning (RTDS_TTCN_GlobalComponentInfo * );
int RTDS_TTCN_CheckTimeout (RTDS_TIMER);
RTDS_TIMER RTDS_TTCN_TimerCreate (long, int, TriTimerDuration);


/******************************************************************
 *        MESSAGE FUNCTIONS
 * ----------------------------------------------------------------
 *    Functions for message operations
 *
 *******************************************************************/

void RTDS_TTCN_UpdateFirstMessage ( RTDS_TTCN_GlobalComponentInfo * RTDS_TTCNcurrentComponentInfo);
void RTDS_TTCN_UpdateTimerLists ( RTDS_TTCN_GlobalComponentInfo * RTDS_currentContext );
int RTDS_TTCN_MsgQueueCheck( char *, RTDS_MessageHeader *, RTDS_TTCN_GlobalComponentInfo *);


/******************************************************************
 *        TESTCASES FUNCTIONS
 * ----------------------------------------------------------------
 *    Functions for testcase execution and status
 *
 *******************************************************************/

void RTDS_TTCN_TestcaseTerminated(RTDS_GlobalProcessInfo * RTDS_currentContext, verdicttype verdict);
verdicttype RTDS_TTCN_GetVerdict(RTDS_SdlInstanceId * Component2Get);
verdicttype RTDS_TTCN_GetFinalVerdict();

#ifdef __cplusplus
}
#endif

#endif
