/* PragmaDev RTDS uITRON 4 integration */
/* ****************************************************************
 * RTDS UITRON FUNCTION DECLARATION
 * ---------------------------------------------------------------
 * - INTERNAL UITRON STRUCTURE
 *      Chained list of message structure : RTDS_Chained_Message
 *
 * - SYSTEM INITIALISATION
 *      RTDS_SystemInit
 *
 ****************************************************************** */
#ifndef _RTDS_OS_H_
#define _RTDS_OS_H_

/*
 * GLOBAL VARIABLES:
 * -------------------
 * Pointers to global list of information on processes and semaphores
 */
#ifdef __cplusplus
extern "C" {
#endif

/* UITRON includes */
#include "kernel_id.h"
#include "uiplus/inc/itron.h"

/* RTDS includes */
#include "RTDS_Error.h"

/* Include for RTDS types */
#include "RTDS_Common.h"

/* Global variable pointing to decoded parmaters */
extern char * RTDS_globalPrintableParameters;

/* Memory poll ID for memory allocation and desallocation */
extern ER_ID RTDS_mempoll_id;

/*
 * EXTERNAL VARIABLE:
 * ------------------
 * Variable declared as global to the all the program
 */
extern RTDS_GlobalProcessInfo * RTDS_globalProcessInfo;
extern RTDS_GlobalSemaphoreInfo * RTDS_globalSemaphoreInfo;

#ifdef RTDS_SIMULATOR
    extern RTDS_GlobalTraceInfo RTDS_globalTraceEntry;
    extern void * RTDS_globalMessageUniqueIdPool;
#endif

/*
 * FUNCTION PROTOTYPES:
 * -------------------
 * Function defined in RTDS_OS.c used below
 */

/* *****************************************************************
 * UITRON system initialization FUNCTIONS
 * ----------------------------------------------------------------
 * The purpose of this function is initialize system
 ***************************************************************** */
extern void RTDS_SystemInit( void );
extern void RTDS_Start( void );
extern void RTDS_Init( void );

/* *****************************************************************
 * SEMAPHORE FUNCTIONS
 ****************************************************************** */
extern RTDS_SemType * RTDS_SemCCreate( int opt, int initial_state );
extern RTDS_SemType * RTDS_SemBCreate( int opt, int initial_state );
extern int RTDS_SemFlush( RTDS_SemType * SemId_To_Flush );
extern void RTDS_SemDelete( RTDS_SemType * SemId_To_Delete );
extern int RTDS_SemGive( RTDS_SemType * SemId_To_Give );
extern int RTDS_SemTake(RTDS_SemType * SemId_To_Give, long time_to_Wait );
extern void RTDS_SemaphoreIdDelete( RTDS_SemaphoreId, RTDS_GlobalProcessInfo * currentContext );
extern RTDS_SemaphoreStatus RTDS_SemaphoreIdTake( RTDS_SemaphoreId, RTDS_SemaphoreTimeout, RTDS_GlobalProcessInfo * currentContext );
extern RTDS_SemaphoreId RTDS_GetSemaphoreId( int semaphoreNumber );
extern RTDS_SemaphoreId RTDS_Sem_Info_Insert( int semaphoreNumber, RTDS_SemaphoreId, RTDS_GlobalProcessInfo * currentContext );

/* *****************************************************************
 * SYSTEM TIME FUNCTIONS
 ****************************************************************** */
extern long RTDS_TickGet( void );
extern void RTDS_TickSet( long timeValue );

/* *****************************************************************
 * MEMORY ALLOCATION AND DESALLOCATION FUNCTIONS
 ****************************************************************** */
extern VP RTDS_Malloc( int size );
extern void RTDS_Free( ID poolId, VP p_blk );
extern void RTDS_TransitionCleanUp( RTDS_GlobalProcessInfo * RTDS_currentContext, int RTDS_sdlStatePrev );

/* *****************************************************************
 * TIMER FUNCTIONS
 ****************************************************************** */
extern void RTDS_StartTimer( RTDS_SdlInstanceId * instance, long, long, int, RTDS_TimerState **, RTDS_GlobalProcessInfo * currentContext );
extern void RTDS_StopTimer( long, RTDS_TimerState **, RTDS_GlobalProcessInfo * currentContext );
extern long RTDS_GetTimerUniqueId ( RTDS_TimerState * );
extern void RTDS_WatchDogFunction ( RTDS_TimerState * );
extern unsigned long RTDS_GetSystemTime( void );

/* *****************************************************************
 * TASK FUNCTIONS
 ****************************************************************** */
extern void RTDS_ProcessCreate( int processNumber, void *, int, short, RTDS_GlobalProcessInfo * currentContext );
extern RTDS_RtosTaskId RTDS_TaskCreate( int priority, void * functionAddress, void * newProcessInfo );
extern void RTDS_ProcessKill( RTDS_GlobalProcessInfo * RTDS_currentContext );
extern RTDS_SdlInstanceId * RTDS_GetProcessInstanceId( int processNumber );
extern int RTDS_CheckInstanceId( RTDS_SdlInstanceId * instance );
extern RTDS_RtosTaskId RTDS_ProcessForget( RTDS_GlobalProcessInfo *, short );
extern ID RTDS_GetCurrentThread( void );

/* *****************************************************************
 * MESSAGE FUNCTIONS
 ****************************************************************** */
extern void RTDS_MsgSend( long , long, unsigned char *, RTDS_SdlInstanceId *, RTDS_SdlInstanceId *, RTDS_GlobalProcessInfo * currentContext );
extern void RTDS_MsgReceive( RTDS_SdlInstanceId * instanceId, RTDS_MessageHeader ** message );
extern int RTDS_MsgQueueReceive( RTDS_RtosQueueId queueId, RTDS_MessageHeader ** message );
extern RTDS_RtosQueueId RTDS_MsgQueueCreate( void );

/* *****************************************************************
 * ERROR FUNCTIONS
 ****************************************************************** */
extern void RTDS_CheckOSError( int code );

/* *****************************************************************
 * SIMULATOR FUNCTIONS
 ****************************************************************** */
#if defined(RTDS_SIMULATOR)
    extern void RTDS_SimulatorMsgQueueSend( long messageNumber, long dataLength, unsigned char * pData, RTDS_SdlInstanceId * receiver, RTDS_SdlInstanceId * sender );
    extern unsigned long RTDS_GetMessageUniqueId( void );
    extern void RTDS_ReleaseMessageUniqueId( unsigned long );
    extern void RTDS_messageDataToString( char ** buffer, long messageNumber, long dataLength, void * dataPointer, int level );
    extern char * RTDS_stringToMessageData( long messageNumber, long * dataLength, void ** dataPointer, char * dataString );
    extern void RTDS_DummyTraceFunction( void );
#endif /* RTDS_SIMULATOR */

#ifdef __cplusplus
}
#endif

#endif /* _RTDS_OS_H_ */
