        /* *************************************************************** */
        /* $(RTDS_HOME)/share/ccg/vxworks/bricks/RTDS_Proc_middle.c begins */
        /* PragmaDev RTDS VxWorks integration                              */
        
        /* Check saved messages */
        if( RTDS_currentContext->readSaveQueue != NULL )
            {
            RTDS_currentContext->currentMessage = RTDS_currentContext->readSaveQueue;
            RTDS_currentContext->readSaveQueue = RTDS_currentContext->readSaveQueue->next;
            }
        /* If no saved messages left, get message from process's message queue */
        else
            {
            RTDS_currentContext->currentMessage = ( RTDS_MessageHeader * )RTDS_MALLOC( sizeof( RTDS_MessageHeader ) );
            RTDS_MSG_QUEUE_READ( RTDS_currentContext->currentMessage );
            RTDS_currentContext->currentMessage->next = NULL;
            }
        
        /* Discard cancelled timers */
        if( RTDS_currentContext->currentMessage->timerUniqueId != 0 )
            {
            RTDS_prevTimer = NULL;
            for( RTDS_timer = RTDS_currentContext->timerList; RTDS_timer != NULL; RTDS_timer = RTDS_timer->next )
                {
                /* If timer found and cancelled */
                if( RTDS_timer->timerUniqueId == RTDS_currentContext->currentMessage->timerUniqueId )
                    {
                    /* We already try to cancel it but it does not work */
                    if( RTDS_timer->state == RTDS_TIMER_CANCELLED )
                        {
                        /* So we discard current message */
                        RTDS_FREE( RTDS_currentContext->currentMessage );
                        RTDS_currentContext->currentMessage = NULL;
                        }
                    /* The watchdog already goes on so we can delete it */
                    if( RTDS_timer->state == RTDS_TIMER_FINISHED )
                        {
                        /* We delete the watchdog to release all memory it holds */
                        if( wdDelete( RTDS_timer->watchDogId ) == ERROR )
                            {
                            RTDS_SYSTEM_ERROR( RTDS_ERROR_WATCHDOG_DELETE );
                            }
                        }
                    /* Remove it from list of timers */
                    if( RTDS_prevTimer == NULL )
                        {
                        RTDS_currentContext->timerList = RTDS_currentContext->timerList->next;
                        }
                    else
                        {
                        RTDS_prevTimer->next = RTDS_timer->next;
                        }
                    RTDS_FREE( RTDS_timer );
                    break;
                    }
                RTDS_prevTimer = RTDS_timer;
                }
            }
        
        /* Let's process the message ! */
        if( RTDS_currentContext->currentMessage != NULL )
            {
            #ifdef RTDS_SIMULATOR
                RTDS_messageDataToString
                    (
                    &RTDS_globalPrintableParameters,
                    RTDS_currentContext->currentMessage->messageNumber,
                    RTDS_currentContext->currentMessage->dataLength,
                    ( void * )( RTDS_currentContext->currentMessage->pData ),
                    RTDS_PARAM_CODEC_MAX_DEPTH
                    );
                RTDS_SIMULATOR_TRACE( RTDS_messageReceived, RTDS_currentContext->currentMessage, SELF, RTDS_currentContext );
                RTDS_FREE( RTDS_globalPrintableParameters );
                RTDS_globalPrintableParameters = NULL;
            #endif
            RTDS_senderId = RTDS_currentContext->currentMessage->sender;
            RTDS_sdlStatePrev = RTDS_currentContext->sdlState;
        /* $(RTDS_HOME)/share/ccg/vxworks/bricks/RTDS_Proc_middle.c ends */
        /* ************************************************************* */

