/* PragmaDev RTDS win32 integration */
#ifndef _RTDS_OS_H_
#define _RTDS_OS_H_

#ifdef __cplusplus
extern "C" {
#endif

/* WINDOWS includes */
#include <winsock2.h>
#include <windows.h>
#include <process.h>
#include <winbase.h>
#include <stdlib.h>

/* RTDS includes */
#include "RTDS_Error.h"

/* Include for RTDS types */
#include "RTDS_Common.h"

#ifdef RTDS_MEMORY_COUNTER
  extern void *RTDS_Malloc(int size);
  extern void RTDS_Free(void *ptr);
#endif


/*
 * FUNCTION PROTOTYPES:
 * -------------------
 * Function defined in RTDS_OS.c used below
 */
#if defined( RTDS_SIMULATOR ) || defined( RTDS_MSC_TRACER )
    long RTDS_IsSemaphoreAvailable( RTDS_SemaphoreId );
#endif

#if defined( RTDS_SIMULATOR ) && defined( RTDS_SOCKET_PORT )
    /* For using the command interpreter */
    extern void RTDS_ForceTimer( RTDS_SdlInstanceId * sdlInstanceId, int timerNumber );
    extern void RTDS_SetSystemTime( long timeValue );
    extern void RTDS_SimulatorMsgQueueSend( long , long, unsigned char *, RTDS_SdlInstanceId * , RTDS_SdlInstanceId *, RTDS_GlobalProcessInfo *RTDS_currentContext );
#endif /* RTDS_SIMULATOR and RTDS_SOCKET_PORT */

#if defined( RTDS_FORMAT_TRACE ) || defined( RTDS_SIMULATOR )
    /* For using the dynamic trace: RTDS_SYSTEM_ERROR */
    extern RTDS_GlobalProcessInfo * RTDS_GetProcessInfoFromSdlInstanceId( RTDS_SdlInstanceId * sdlInstanceId );
    extern RTDS_GlobalProcessInfo * RTDS_GetProcessInfoFromProcessNum( int sdlProcessNumber );
    extern RTDS_GlobalProcessInfo * RTDS_GetProcessInfoFromRtosTaskId( RTDS_RtosTaskId rtosTaskId );
    extern RTDS_RtosTaskId          RTDS_GetCurrentRtosTaskId( void );
#endif /* RTDS_SIMULATOR */

extern long                 RTDS_GetTimerUniqueId   ( RTDS_TimerState * );
extern void                 RTDS_WatchDogFunction   ( RTDS_TimerState * );
extern void                 RTDS_StartTimer         ( RTDS_SdlInstanceId * , long , long , int , RTDS_TimerState **, RTDS_GlobalProcessInfo * RTDS_currentContext );
extern void                 RTDS_StopTimer          ( long , RTDS_TimerState **, RTDS_GlobalProcessInfo *RTDS_currentContext );
extern RTDS_QCB           * RTDS_MsgQueueCreate     ( void );
extern int                 RTDS_MsgQueueDelete         ( RTDS_QCB *queueId );
extern void                 RTDS_MsgSend            ( long , long, unsigned char *, RTDS_SdlInstanceId * , RTDS_SdlInstanceId *, RTDS_GlobalProcessInfo * RTDS_currentContext );
extern void                 RTDS_TTCNMsgSend        (long , long, unsigned char *, RTDS_RtosQueueId, RTDS_SdlInstanceId* , RTDS_SdlInstanceId*, RTDS_GlobalProcessInfo *RTDS_currentContext );
extern void                 RTDS_TTCNMsgReceive     (RTDS_RtosQueueId, RTDS_SdlInstanceId *, RTDS_MessageHeader *, int, int);
extern void                 RTDS_MsgReceive         ( RTDS_SdlInstanceId *, RTDS_MessageHeader * );
extern int                  RTDS_MsgQueueReceive    ( RTDS_QCB *, RTDS_MessageHeader * );
extern int                  RTDS_MsgQueueSend       ( RTDS_QCB *, RTDS_MessageHeader * );
extern RTDS_SdlInstanceId * RTDS_GetProcessQueueId  ( int sdlProcessNumber );
extern RTDS_RtosTaskId      RTDS_TaskCreate         ( int priority, void *( * functionAddress )( void * ), void * newProcessInfo );
extern void                 RTDS_ProcessCreate      ( int sdlProcessNumber, void * , int , RTDS_SdlInstanceId **, RTDS_SdlInstanceId * , short, RTDS_GlobalProcessInfo * RTDS_currentContext);
extern void                 RTDS_ProcessKill        ( RTDS_GlobalProcessInfo * RTDS_currentContext );
extern RTDS_RtosTaskId      RTDS_ProcessForget      ( RTDS_GlobalProcessInfo * RTDS_currentContext, short deleteQueue );
extern void                 RTDS_SemaphoreListRemove( RTDS_SemaphoreId, RTDS_GlobalProcessInfo * RTDS_currentContext );
extern RTDS_SemaphoreStatus RTDS_SemaphoreIdTake    ( RTDS_SemaphoreId , RTDS_SemaphoreTimeout, RTDS_GlobalProcessInfo * RTDS_currentContext );
extern RTDS_SemaphoreId     RTDS_GetSemaphoreId     ( int semaphoreNumber );
extern RTDS_SemaphoreId     RTDS_SemaphoreListInsert( int semaphoreNumber, RTDS_SemaphoreId, RTDS_GlobalProcessInfo * RTDS_currentContext);
extern int                  RTDS_CheckSdlInstance   ( RTDS_SdlInstanceId * sdlInstanceId );
extern void                 RTDS_TransitionCleanUp  ( RTDS_GlobalProcessInfo * RTDS_currentContext, int RTDS_sdlStatePrev );
extern void                 RTDS_TimerCleanUp       ( RTDS_GlobalProcessInfo * currentContext );
extern unsigned long        RTDS_GetSystemTime      ( void );

#if defined( RTDS_SIMULATOR ) || defined( RTDS_CMD_INTERPRETER ) || defined( RTDS_BACK_TRACE_MAX_EVENT_NUM ) || defined( RTDS_MSC_TRACER )
    extern void RTDS_messageDataToString( char ** buffer, long sigNum, long dataLength, void * pData, int level );
    extern char * RTDS_stringToMessageData( long messageNumber, long * dataLength, void ** dataPointer, char * dataString );
#endif

#if defined( RTDS_SIMULATOR ) || defined( RTDS_MSC_TRACER )
    extern void RTDS_SimulatorTrace( enum RTDS_EventType event, void * eventParameter1, long eventParameter2, RTDS_GlobalProcessInfo * currentContext, int waitAck);
#endif

#if RTDS_SIMULATOR
    extern unsigned long    RTDS_GetMessageUniqueId ( void );
    extern void             RTDS_ReleaseMessageUniqueId( unsigned long );
    extern void             RTDS_DummyTraceFunction ( void );
    extern void             RTDS_DummyRunUntilQueueEmptyFunction ( void );
#endif /* RTDS_SIMULATOR */

/*
 * EXTERNAL VARIABLE:
 * -------------------
 * Variable declared as global to the all the program
 */
extern RTDS_GlobalProcessInfo * RTDS_globalProcessInfo;
extern RTDS_GlobalSemaphoreInfo * RTDS_globalSemaphoreInfo;

#if defined( RTDS_SIMULATOR )
    extern void * RTDS_globalMessageUniqueIdPool;
#endif /* #if defined(RTDS_SIMULATOR) */

/*
 * STRUCT RTDS_GLOBAL.TRACE.INFO:
 * -------------------------------
 * Structure containing the event information read by the simulator
 */
#if defined( RTDS_SIMULATOR ) || defined( RTDS_MSC_TRACER ) || defined( RTDS_FORMAT_TRACE )
    extern RTDS_GlobalTraceInfo RTDS_globalTraceEntry;
    /* Global variable pointing to decoded parmaters */
    extern char * RTDS_globalPrintableParameters;
#endif /* RTDS_SIMULATOR or RTDS_MSC_TRACER or RTDS_FORMAT_TRACE */

#ifdef __cplusplus
}
#endif

#endif /* End of    _RTDS_OS_H_ */

