# Aquativo - Copyright (C) 2004 Pat Thoyts <patthoyts@users.sourceforge.net>
#
# Import the Aquativo Gtk theme (C) Andrew Wyatt, FEWT Software
# Original: http://www.fewt.com
# Link: http://art.gnome.org/themes/gtk2/432.php
#
# You will need to fetch the theme package and extract it under the 
# demos/themes directory and maybe modify the demos/themes/pkgIndex.tcl
# file.
#
# $Id: Aquativo.tcl,v 1.5 2007/12/19 13:02:25 sbron Exp $

package require Tk 8.4;                 # minimum version for Tile
package require tile 0.7.8;             # depends upon tile
package require tkpng

# Check if png images are supported. There is currently no proper way to
# obtain the supported image formats. So the only possibility is to simply
# try creating an image in the desired format and examine the error message.
catch {image create photo -format png -data x} ::ttk::theme::error
if {[string match {* not supported} $::ttk::theme::error]} {
    # Try to find a package that can handle png images
    eval [linsert [package unknown] end Img ""]
    foreach ::ttk::theme::pkg {Img tkpng pixane} {
        if {[package versions $::ttk::theme::pkg] ne ""} {break}
    }
    if {[catch {package require $::ttk::theme::pkg}]} {
        error "can't find library supporting png images"
    }
}

namespace eval ttk {
    namespace eval theme {
        namespace eval Aquativo {
            variable version 0.0.6
        }
    }
}

namespace eval ttk::theme::Aquativo {

    variable imgdir [file join [file dirname [info script]] Aquativo-1.5 gtk-2.0]
    variable I
    variable file "" img ""
    foreach file {
        horizontal_trough.png vertical_trough.png
        button_normal_in.png button_prelight_out.png
        button_insensitive_out.png button_normal_out.png
        check_in.png check_out.png
        option_in.png option_out.png
        menubar_option.png menubar_option_arrow.png 
        menubar_option_arrow_insensitive.png
        scrollbar_prelight_horizontal.png scrollbar_horizontal.png
        scrollbar_prelight_vertical.png scrollbar_vertical.png
        arrow_up_clicked.png arrow_up_insensitive.png arrow_up_normal.png
        arrow_down_clicked.png arrow_down_insensitive.png arrow_down_normal.png
        arrow_left_clicked.png arrow_left_insensitive.png arrow_left_normal.png
        arrow_right_clicked.png arrow_right_insensitive.png 
        arrow_right_normal.png
        notebook_bottom.png notebook_active_bottom.png
    } {
	set file [file join $imgdir $file]
	set img [file tail [file rootname $file]]
	set I($img) [image create photo -file $file -format png]
    }

    # Reduce the width of the notebook tab images
    foreach img {notebook_bottom notebook_active_bottom} {
	variable width [image width $I($img)]
	if {$width <= 30} continue
	$I($img) copy $I($img) -from [expr {$width - 15}] 0 -to 15 0 \
		-shrink -compositingrule set
    }

    ttk::style theme create Aquativo -parent alt -settings {

        # -----------------------------------------------------------------
        # Defaults
        # -----------------------------------------------------------------

        ttk::style configure "." -font TkDefaultFont -background #fafafa 
        ttk::style configure TButton -padding {1 1} -width -11 -anchor center

        # -----------------------------------------------------------------
        # Troughs
        # -----------------------------------------------------------------

        ttk::style element create trough image $I(horizontal_trough) \
            -border 3
        ttk::style element create Vertical.Scrollbar.trough \
            image $I(vertical_trough) -border 2
        ttk::style element create Vertical.Scale.trough \
            image $I(vertical_trough) -border 2
        ttk::style element create Vertical.Progress.trough \
            image $I(vertical_trough) -border 2

        # -----------------------------------------------------------------
        # Buttons, Checkbuttons and Radiobuttons
        # -----------------------------------------------------------------

        ttk::style layout TButton {
            Button.background
            Button.button -children {
                Button.focus -children {
                    Button.label
                }
            }
        }

        ttk::style element create button image [list $I(button_normal_out) \
                {pressed !disabled} $I(button_normal_in) \
                {active !disabled}  $I(button_prelight_out) \
                disabled            $I(button_insensitive_out) \
	    ] -border {4 13} -padding 4 -sticky news
        
        ttk::style element create Checkbutton.indicator \
	    image [list $I(check_out) {selected !disabled} $I(check_in)] \
            -border 2 -width 20 -sticky w

        ttk::style element create Radiobutton.indicator \
	    image [list $I(option_out) {selected !disabled} $I(option_in)] \
            -border 2 -width 20 -sticky w

        # -----------------------------------------------------------------
        # Menubuttons:
        # -----------------------------------------------------------------

        ttk::style element create Menubutton.button image $I(menubar_option) \
            -border {7 10 29 15} -padding {7 4 29 4} -sticky news
        
        ttk::style element create Menubutton.indicator \
	    image [list $I(menubar_option_arrow) \
		disabled $I(menubar_option_arrow_insensitive) \
	    ] -width 11 -sticky w -padding {0 0 18 0} \
        
        # -----------------------------------------------------------------
        # Scrollbar
        # -----------------------------------------------------------------

        ttk::style configure TScrollbar -width 16

        ttk::style element create Horizontal.Scrollbar.thumb \
            image [list $I(scrollbar_horizontal) \
		{active !disabled} $I(scrollbar_prelight_horizontal) \
	    ] -border 3 -width 16 -height 16 -sticky news \
        
        ttk::style element create Vertical.Scrollbar.thumb \
            image [list $I(scrollbar_vertical) \
		{active !disabled} $I(scrollbar_prelight_vertical) \
	    ] -border 3 -width 16 -height 15 -sticky news

        # -----------------------------------------------------------------
        # Scale
        # -----------------------------------------------------------------

        ttk::style element create Horizontal.Scale.slider \
            image [list $I(scrollbar_horizontal) \
		{active !disabled} $I(scrollbar_prelight_horizontal) \
	    ] -border 3 -width 30 -height 16 \

        ttk::style element create Vertical.Scale.slider \
            image [list $I(scrollbar_vertical) \
		{active !disabled} $I(scrollbar_prelight_vertical) \
	    ] -border 3 -width 16 -height 30

        # -----------------------------------------------------------------
        # Progress
        # -----------------------------------------------------------------

        # should use ::tile::Aquativo::_i_progressbar but this is too big.
        ttk::style element create bar \
            image $I(scrollbar_prelight_horizontal) \
            -border 3
        ttk::style element create Vertical.Progress.bar \
            image $I(scrollbar_prelight_vertical) \
            -border 3

        # ------------------------------------------------------------------
        # Arrows
        # ------------------------------------------------------------------

        ttk::style element create uparrow \
	    image [list $I(arrow_up_normal) \
	        {pressed !disabled} $I(arrow_up_clicked) \
                disabled            $I(arrow_up_insensitive)]
        ttk::style element create downarrow \
	    image [list $I(arrow_down_normal) \
                {pressed !disabled} $I(arrow_down_clicked) \
                disabled            $I(arrow_down_insensitive)]
        ttk::style element create leftarrow \
	    image [list $I(arrow_left_normal) \
                {pressed !disabled} $I(arrow_left_clicked) \
                disabled            $I(arrow_left_insensitive)]
        ttk::style element create rightarrow \
	    image [list $I(arrow_right_normal) \
                {pressed !disabled} $I(arrow_right_clicked) \
                disabled            $I(arrow_right_insensitive)]

        # -----------------------------------------------------------------
        # Notebook parts
        # -----------------------------------------------------------------
    
        ttk::style element create tab \
	    image [list $I(notebook_active_bottom) \
		{selected !disabled} $I(notebook_bottom) \
	    ] -sticky news -border {5 11 6 10} -padding {4 2}

	## Labelframes.
	#
	ttk::style configure TLabelframe -borderwidth 2 -relief groove

        # -----------------------------------------------------------------
        # Frames parts
        # -----------------------------------------------------------------
        
        # This make it REALLY SLOW
        #ttk::style element create Frame.background image $I(window_background)
        #ttk::style element create Labelframe.background image $I(window_backround)

    }    
}

# -------------------------------------------------------------------------

package provide ttk::theme::Aquativo $::ttk::theme::Aquativo::version

# -------------------------------------------------------------------------
