#include <stdlib.h>
#include <stdio.h>

#include "RTDS_Error.h"
#include "RTDS_MACRO.h"
#include "RTDS_OS.h"
#include "RTDS_InternalConstants.h"

#if defined( RTDS_FORMAT_TRACE )
#include "RTDS_FormatTrace.h"
#endif

#include "RTDS_messages.h"
#include "RTDS_gen.h"

#include "RTDS_ADDL_MACRO.h"

#include "RTDS_MutexSemaphoreProcess_decl.h"


/*
** FUNCTION RTDS_RTDS_MutexSemaphoreProcess_continuousSignals:
** -----------------------------------------------------------
** Executes a transition for a continuous signal in process or procedure
*/

static short RTDS_RTDS_MutexSemaphoreProcess_continuousSignals(RTDS_Proc * RTDS_instanceDescriptor, int * lowestPriority)
  {
  return 0;
  }


/*
** FUNCTION RTDS_RTDS_MutexSemaphoreProcess_executeTransition:
** -----------------------------------------------------------
** Entry point for all transitions in process or procedure
*/

static short RTDS_RTDS_MutexSemaphoreProcess_executeTransition(RTDS_Proc * RTDS_instanceDescriptor, RTDS_MessageHeader * currentMessage)
  {
  RTDS_MSG_DATA_DECL
  RTDS_GlobalProcessInfo  * RTDS_currentContext = RTDS_instanceDescriptor->RTDS_currentContext;
  RTDS_SdlInstanceId      * waiter_id;
  
  /* Remember previous state */
  RTDS_instanceDescriptor->RTDS_sdlStatePrev = RTDS_currentContext->sdlState;
  /* Remember message as current one */
  RTDS_currentContext->currentMessage = currentMessage;
  /* No initial transition; Switch for all messages */
  if ( currentMessage == NULL )
    return 0;
  RTDS_instanceDescriptor->RTDS_senderId = RTDS_currentContext->currentMessage->sender;
  switch(RTDS_currentContext->currentMessage->messageNumber)
    {
    case RTDS_message_RTDS_takeSemaphore:
      if (    ( RTDS_instanceDescriptor->myLocals.RTDS_MutexSemaphoreProcess.taker_instance_id == NULL )
          ||  ( RTDS_instanceDescriptor->myLocals.RTDS_MutexSemaphoreProcess.taker_instance_id == RTDS_instanceDescriptor->RTDS_senderId ) )
        {
        RTDS_instanceDescriptor->myLocals.RTDS_MutexSemaphoreProcess.taker_instance_id = RTDS_instanceDescriptor->RTDS_senderId;
        RTDS_instanceDescriptor->myLocals.RTDS_MutexSemaphoreProcess.take_count ++;
        RTDS_MSG_QUEUE_SEND_TO_ID(RTDS_message_RTDS_takeSucceeded, 0, NULL, RTDS_instanceDescriptor->RTDS_senderId);
        }
      else
        {
        RTDS_SemaphoreProcess_addWaitingInstance(&(RTDS_instanceDescriptor->myLocals.RTDS_MutexSemaphoreProcess.common_attributes), RTDS_instanceDescriptor->RTDS_senderId);
        }
      break;

    case RTDS_message_RTDS_giveSemaphore:
      if ( RTDS_instanceDescriptor->myLocals.RTDS_MutexSemaphoreProcess.taker_instance_id == RTDS_instanceDescriptor->RTDS_senderId )
        {
        RTDS_instanceDescriptor->myLocals.RTDS_MutexSemaphoreProcess.take_count --;
        if ( RTDS_instanceDescriptor->myLocals.RTDS_MutexSemaphoreProcess.take_count <= 0 )
          {
          RTDS_instanceDescriptor->myLocals.RTDS_MutexSemaphoreProcess.taker_instance_id = NULL;
          if ( RTDS_SemaphoreProcess_popFirstWaitingInstance(&(RTDS_instanceDescriptor->myLocals.RTDS_MutexSemaphoreProcess.common_attributes), &waiter_id) )
            {
            RTDS_MSG_QUEUE_SEND_TO_ID(RTDS_message_RTDS_takeSucceeded, 0, NULL, waiter_id);
            RTDS_instanceDescriptor->myLocals.RTDS_MutexSemaphoreProcess.taker_instance_id = waiter_id;
            RTDS_instanceDescriptor->myLocals.RTDS_MutexSemaphoreProcess.take_count = 1;
            }
          }
        }
      break;

    case RTDS_message_RTDS_cancelTake:
      if ( ! RTDS_SemaphoreProcess_removeWaitingInstance(&(RTDS_instanceDescriptor->myLocals.RTDS_MutexSemaphoreProcess.common_attributes), RTDS_instanceDescriptor->RTDS_senderId) )
        return 1; /* Should never happen... */
      break;
    }
  RTDS_FREE(currentMessage);
  RTDS_currentContext->currentMessage = NULL;
  return 0;
  }


/*
** INSTANCE CREATION/INITIALIZATION:
** ---------------------------------
*/

void RTDS_Proc_RTDS_MutexSemaphoreProcess_createInstance(
  RTDS_Proc * RTDS_instanceDescriptor,
  RTDS_Scheduler * parentScheduler,
  RTDS_GlobalProcessInfo * instanceContext,
  RTDS_GlobalProcessInfo * parentContext
)
  {
  RTDS_instanceDescriptor->RTDS_isProcedure = 0;
  RTDS_instanceDescriptor->RTDS_continuousSignals = (RTDS_continuousSignals_type)&RTDS_RTDS_MutexSemaphoreProcess_continuousSignals;
  RTDS_instanceDescriptor->RTDS_executeTransition = (RTDS_executeTransition_type)&RTDS_RTDS_MutexSemaphoreProcess_executeTransition;
  RTDS_Proc_createInstance(RTDS_instanceDescriptor, parentScheduler, instanceContext, parentContext);
  RTDS_instanceDescriptor->RTDS_currentContext->sdlProcessNumber = RTDS_internal_MutexSemaphoreProcess;
  RTDS_SemaphoreProcess_init(&(RTDS_instanceDescriptor->myLocals.RTDS_MutexSemaphoreProcess.common_attributes));
  RTDS_instanceDescriptor->myLocals.RTDS_MutexSemaphoreProcess.taker_instance_id = NULL;
  RTDS_instanceDescriptor->myLocals.RTDS_MutexSemaphoreProcess.take_count = 0;
  };
