#include <stdlib.h>
#include <stdio.h>

#include "RTDS_Error.h"
#include "RTDS_MACRO.h"
#include "RTDS_OS.h"
#include "RTDS_InternalConstants.h"

#if defined( RTDS_FORMAT_TRACE )
#include "RTDS_FormatTrace.h"
#endif

#include "RTDS_messages.h"
#include "RTDS_gen.h"

#include "RTDS_ADDL_MACRO.h"

#include "RTDS_SemaphoreTakeProcedure_decl.h"


/*
** FUNCTION RTDS_RTDS_SemaphoreTakeProcedure_continuousSignals:
** ------------------------------------------------------------
** Executes a transition for a continuous signal in process or procedure
*/

static short RTDS_RTDS_SemaphoreTakeProcedure_continuousSignals(RTDS_Proc * RTDS_instanceDescriptor, int * lowestPriority)
  {
  return 0;
  }


/*
** FUNCTION RTDS_RTDS_SemaphoreTakeProcedure_executeTransition:
** ------------------------------------------------------------
** Entry point for all transitions in process or procedure
*/

static short RTDS_RTDS_SemaphoreTakeProcedure_executeTransition(RTDS_Proc * RTDS_instanceDescriptor, RTDS_MessageHeader * currentMessage)
  {
  RTDS_MSG_DATA_DECL
  RTDS_GlobalProcessInfo * RTDS_currentContext = RTDS_instanceDescriptor->RTDS_currentContext;
  short has_returned = 0;
  
  /* Remember previous state */
  RTDS_instanceDescriptor->RTDS_sdlStatePrev = RTDS_currentContext->sdlState;
  RTDS_currentContext->currentMessage = currentMessage;
  /* No message means start transition */
  if ( currentMessage == NULL )
    {
    if ( RTDS_instanceDescriptor->myLocals.RTDS_SemaphoreTakeProcedure.time_out != RTDS_SEMAPHORE_TIME_OUT_FOREVER )
      {
      RTDS_Proc_setTimer(RTDS_instanceDescriptor, RTDS_message_RTDS_takeTimeOut, RTDS_instanceDescriptor->myLocals.RTDS_SemaphoreTakeProcedure.time_out);
      }
    RTDS_MSG_QUEUE_SEND_TO_ID(RTDS_message_RTDS_takeSemaphore, 0, NULL, RTDS_instanceDescriptor->myLocals.RTDS_SemaphoreTakeProcedure.semaphore_id);
    /* Set dummy state to force state change when the procedure returns; Needed for saved messages to be taken into account */
    RTDS_currentContext->sdlState = -1;
    }
  /* Switch for all other messages */
  else
    {
    if ( currentMessage->timerUniqueId != 0 )
      {
      RTDS_TIMER_CLEAN_UP(RTDS_currentContext);
      if ( RTDS_currentContext->currentMessage == NULL ) return 0;
      }
    RTDS_instanceDescriptor->RTDS_senderId = RTDS_currentContext->currentMessage->sender;
    switch(RTDS_currentContext->currentMessage->messageNumber)
      {
      case RTDS_message_RTDS_takeSucceeded:
        RTDS_Proc_resetTimer(RTDS_instanceDescriptor, RTDS_message_RTDS_takeTimeOut);
        RTDS_instanceDescriptor->myLocals.RTDS_SemaphoreTakeProcedure.RTDS_return_value = RTDS_OK;
        has_returned = 1;
        break;
        
      case RTDS_message_RTDS_takeTimeOut:
        RTDS_MSG_QUEUE_SEND_TO_ID(RTDS_message_RTDS_cancelTake, 0, NULL, RTDS_instanceDescriptor->myLocals.RTDS_SemaphoreTakeProcedure.semaphore_id);
        RTDS_instanceDescriptor->myLocals.RTDS_SemaphoreTakeProcedure.RTDS_return_value = RTDS_ERROR;
        has_returned = 1;
        break;
      
      default:
        RTDS_MSG_SAVE(RTDS_currentContext->currentMessage);
        return 0;
      }
    }
  RTDS_FREE(currentMessage);
  RTDS_currentContext->currentMessage = NULL;
  return has_returned;
  }


/*
** INSTANCE CREATION/INITIALIZATION:
** ---------------------------------
*/

void RTDS_Proc_RTDS_SemaphoreTakeProcedure_createInstance(RTDS_Proc * RTDS_instanceDescriptor, RTDS_Scheduler * parentScheduler, RTDS_SdlInstanceId * _semaphore_id, long _time_out)
  {
  RTDS_instanceDescriptor->RTDS_isProcedure = 1;
  RTDS_instanceDescriptor->RTDS_continuousSignals = (RTDS_continuousSignals_type)&RTDS_RTDS_SemaphoreTakeProcedure_continuousSignals;
  RTDS_instanceDescriptor->RTDS_executeTransition = (RTDS_executeTransition_type)&RTDS_RTDS_SemaphoreTakeProcedure_executeTransition;
  RTDS_Proc_createInstance(RTDS_instanceDescriptor, parentScheduler, NULL, NULL);
  RTDS_instanceDescriptor->myLocals.RTDS_SemaphoreTakeProcedure.semaphore_id = _semaphore_id;
  RTDS_instanceDescriptor->myLocals.RTDS_SemaphoreTakeProcedure.time_out = _time_out;
  }
