############################################################################
# 													PROGRAM MODULE
#
# $Workfile:	 makefile.mk	$
# Document no: @(#) 550/OSE137-makefile
# $Revision: 2704 $
# $Author: cvs $
# $Date: 2004-10-04 12:36:53 +0200 (Mon, 04 Oct 2004) $
#
# 	Copyright (C) 1999 by ENEA OSE Systems AB. All rights reserved.
#
############################################################################

usage .PHONY:
	$(ECHO)Available make targets are:		 $(ECHOEND)
	$(ECHO)  clean	- delete the directory $(OBJ) and all its files.$(ECHOEND)
	$(ECHO)  all		- build executable file.$(ECHOEND)
	$(ECHOEMPTY)



######################################################################
# SETS HOST TO EITHER UNIX OR WIN32
######################################################################

HOST = $(eq,$(OS),unix UNIX WIN32)

######################################################################
# READ THE COMMON AND THE USER CONFIGURATION FILES
######################################################################
# Inclusion of your common settings.
# In this file, you can enter constants to be used for all
# examples, e.g. COMPILER, COMPILERROOT etc.
# You specifies the file via an environment variable or a make macro
# on the command line called EXAMPLES_COMMON_MAKE_FILE. A make macro
# will override an environment variable, but you'll get a warning
# about redefinition of a macro.
# E.g.
# > export EXAMPLES_COMMON_MAKE_FILE=~/common_settings.mk
# or
# > dmake EXAMPLES_COMMON_MAKE_FILE=~/common_settings.mk all

# Import the configuration environment variables
.IMPORT .IGNORE: EXAMPLES_COMMON_MAKE_FILE USERCONF

# There is a template for this common make file in
# "<OSEROOT>/examples/common/make/common_settings.mk". But we
# can't address that file here, since userconf.mk, where the
# EXAMPLES_COMMON macro is defined, must be included after
# the common make file.

.IF $(!null,$(EXAMPLES_COMMON_MAKE_FILE) TRUE $(NULL))
	include $(EXAMPLES_COMMON_MAKE_FILE)
.END

# The USERCONF macro can be overrided on the command line or
# by using an environment variable.
# E.g.
# > dmake USERCONF=~/myconf.mk all
# or
# > export USERCONF=~/myconf.mk

USERCONF *= ${RTDS_HOME}$/share$/ccg$/ose$/make$/WinXrayArm$/userconf.mk

include $(USERCONF)

#############################################################################
# Configuration of example
#############################################################################

#.IF $(OBJ_SUBDIR) != $(NULL)
	OBJ = ..$/obj$/$(OBJ_SUBDIR)
#.ELSE
#  OBJ	= ..$/obj
#.END


$(OBJ):
	$(ECHO)Create: $@ $(ECHOEND)
	$(MKDIR) ..$/obj
.IF $(OBJ_SUBDIR) != $(NULL)
	$(MKDIR) $@
.END

CLEAN_OBJ .PHONY:
	$(RMDIR) $(OBJ)

CLEAN += CLEAN_OBJ


SRC = .$
INCLUDE += -I$(OBJ)
INCLUDE += -I.

EXAMPLES_COMMON *= C:\OSE\OSE4.5\examples\common
EXAMPLES_COMMON_CONF	*= $(EXAMPLES_COMMON)$/conf
EXAMPLES_COMMON_INCLUDE *= $(EXAMPLES_COMMON)$/include
EXAMPLES_COMMON_MAKE	*= $(EXAMPLES_COMMON)$/make
EXAMPLES_COMMON_SRC 	*= $(EXAMPLES_COMMON)$/src

INCLUDE += -I$(EXAMPLES_COMMON_INCLUDE)


.IF $(HOST) == UNIX
	include $(EXAMPLES_COMMON_MAKE)$/tools-unix.mk
.ELSE
	include $(EXAMPLES_COMMON_MAKE)$/tools-win32.mk
.END


#
# Let's find out something about the specific target
#


#####################################################
#
# Define statements
#
#####################################################

USE_OSEDEF_H *= yes



#####################################################
#
# Fetch information on CPU and BSP for the selected board
#
#####################################################

include $(EXAMPLES_COMMON_MAKE)$/select_cpu_and_bsp.mk


#####################################################
#
# Objects
#
#####################################################


.IF $(EXECUTABLE_FILE_TYPE) != load_module
	.IF $(INCLUDE_OSE_EFS) == yes
		OBJECTS += startefs.o # This file is located in
				# <OSEROOT>/<PLATFORM>/src, and is
				# an example on how to start EFS
	.ELIF $(INCLUDE_OSE_AFM) == yes
		OBJECTS 		+= startafm.o 	# This file is located in
																# <OSEROOT>/<PLATFORM>/src, and is
																# an example on how to start AFM
	.ELIF $(INCLUDE_OSE_SHELL) == yes
		 OBJECTS	+= startshell.o # This file is located in
				# <OSEROOT>/<PLATFORM>/src, and is
				# an example on how to start SHELL
	.END
	.IF $(INCLUDE_OSE_INET) == yes
		OBJECTS += startinet.o	# This file is located in
				# <OSEROOT>/<PLATFORM>/src, and is
				# an example on how to start INET
	.END
	.IF $(INCLUDE_OSE_PRH) == yes
		OBJECTS += start_prh.o	# This file is located in
				# <OSEROOT>/<PLATFORM>/src, and is
				# an example on how to start PRH
	.END
.END



# OBJECTS += RTDS_Start.o



# Error handler:
.IF  $(EXECUTABLE_FILE_TYPE) != load_module
	OBJECTS += err_hnd.o
.END

# Early Error Handler:
# To be used if MMS or MMH (via PRH)
.IF $(INCLUDE_OSE_MMS) == yes
	OBJECTS += early_error.o
.ELIF $(INCLUDE_OSE_MMS) == mmh
	OBJECTS += early_error.o
.ELIF $(INCLUDE_OSE_PRH) == yes
	OBJECTS += early_error.o
.END


#####################################################
#
# Libraries
#
#####################################################


#####################################################
#
# Contribution to architecture specific kernel
# configuration.
# powerpc : ospp.con
# mips		: krn.con
# arm 		: osarm.con
# m68000	: os68.con
#
#####################################################

.IF $(PLATFORM) == powerpc
	OSPP_CON_CONTRIBUTORS  !:= $(OBJ)$/osarch_con_from_example.con $(OSPP_CON_CONTRIBUTORS)
.ELIF $(PLATFORM) == m68000
	OS68_CON_CONTRIBUTORS  !:= $(OBJ)$/osarch_con_from_example.con $(OS68_CON_CONTRIBUTORS)
.ELIF $(PLATFORM) == mips
	KRN_CON_CONTRIBUTORS	 !:= $(OBJ)$/osarch_con_from_example.con $(KRN_CON_CONTRIBUTORS)
.ELIF $(PLATFORM) == arm4tle
	OSARM_CON_CONTRIBUTORS !:= $(OBJ)$/osarch_con_from_example.con $(OSARM_CON_CONTRIBUTORS)
.ELIF $(PLATFORM) == arm4tbe
	OSARM_CON_CONTRIBUTORS !:= $(OBJ)$/osarch_con_from_example.con $(OSARM_CON_CONTRIBUTORS)
.ELIF $(PLATFORM) == sarmle
	OSARM_CON_CONTRIBUTORS !:= $(OBJ)$/osarch_con_from_example.con $(OSARM_CON_CONTRIBUTORS)
.ELIF $(PLATFORM) == sarmbe
	OSARM_CON_CONTRIBUTORS !:= $(OBJ)$/osarch_con_from_example.con $(OSARM_CON_CONTRIBUTORS)
.END

$(OBJ)$/osarch_con_from_example.con .PRECIOUS: $(MAKEFILE:s\-f\\) $(USERCONF)
	$(ECHO) 	Create: $@$(ECHOEND)
	$(ECHOEMPTY)								>$@

#####################################################
#
# Contribution to osemain.con
#
#####################################################

OSEMAIN_CON_CONTRIBUTORS	!:= $(OBJ)$/osemain_con_from_example.con $(OSEMAIN_CON_CONTRIBUTORS)

$(OBJ)$/osemain_con_from_example.con .PRECIOUS:  $(MAKEFILE:s\-f\\) $(USERCONF)
	$(ECHOEMPTY)>$@
	$(ECHO)/* The entries below are added by makefile.mk */$(ECHOEND)>>$@
	$(ECHO)/* They represent the parameters for the application. */$(ECHOEND)>>$@

.IF $(EXECUTABLE_FILE_TYPE) != load_module
	.IF $(INCLUDE_OSE_EFS) == yes
	$(ECHO)PRI_PROC(start_efs, start_efs, 1023, 9, DEFAULT, 0, NULL)$(ECHOEND)>>$@
	.ELIF $(INCLUDE_OSE_AFM) == yes
	 $(ECHO)PRI_PROC(start_afm, start_afm, 256, 9, DEFAULT, 0, NULL)$(ECHOEND)>>$@
	.ELIF $(INCLUDE_OSE_SHELL) == yes
	$(ECHO)PRI_PROC(start_shell, start_shell, 1023, 9, DEFAULT, 0, NULL)$(ECHOEND)>>$@
	.END
	.IF $(INCLUDE_OSE_INET) == yes
	$(ECHO)PRI_PROC(init_inet,	init_inet, 256, 9, DEFAULT, 0, NULL)$(ECHOEND)>>$@
	.END
.END
#  $(ECHO)/* Required by PragmaDev RTDS code generator: */$(ECHOEND)>>$@
#  $(ECHO)PRI_PROC(RTDS_Start,	 RTDS_Start,		1024, 15, DEFAULT, 0, NULL)$(ECHOEND)>>$@
.IF $(INCLUDE_OSE_PRH) == yes
	$(ECHO)PRI_PROC(start_prh,	 start_prh, 		256,	10, DEFAULT, 0, NULL)$(ECHOEND)>>$@
# $(ECHO)START_OSE_HOOK2(start_prh_hook)												$(ECHOEND)>>$@
.END
.IF $(COMPILER) == ARM_ADS
	$(ECHO)START_OSE_HOOK1 (adsClibStartHook1)$(ECHOEND)>>$@
	$(ECHO)START_OSE_HOOK2 (adsClibStartHook2)$(ECHOEND)>>$@
.END # ARM_ADS








#####################################################
#
# Contribution to softose.con % Softkernel environments
#
#####################################################


.IF $(USE_OSEDEF_H) == yes
	include $(EXAMPLES_COMMON_MAKE)$/osedef.mk
.END


#############################################################################
#
# Inclusion of OSE products
#
#############################################################################

PLATFORM_MAKEFILES		*= $(OSEROOT)$/$(PLATFORM)$/makefiles

include .$/pragmadev.mk
include $(EXAMPLES_COMMON_MAKE)$/products.mk


# The COMPILERMAKE macro is assigned in commonsetup.mk
# This has to be done late since this makefile may check things like
# USE_MMS and such things that need to modify like CRT0
# EXECUTABLE_NAME = rtds
include $(EXAMPLES_COMMON_MAKE)$/compiler.mk

LCFDEFINES	+= -DIMAGE_START=$(IMAGE_START)
LCFDEFINES	+= -DIMAGE_MAX_LENGTH=$(IMAGE_MAX_LENGTH)


include $(EXAMPLES_COMMON_MAKE)$/compilation_rules.mk

include $(EXAMPLES_COMMON_MAKE)$/targets.mk


#############################################################################
# END OF MAKEFILE
#############################################################################
