/* PragmaDev RTDS posix integration */
#include <stdlib.h>

#include "RTDS_Error.h"
#include "RTDS_MACRO.h"
#include "RTDS_OS.h"
#include "RTDS_gen.h"

/*
 * SEMAPHORE PROTOTYPE:
 * -------------------
 */
RTDS_SYS_TIME_PROTO
RTDS_CRITICAL_SECTION_PROTO
RTDS_START_SYNCHRO_PROTO
RTDS_CRITICAL_TRACE_SECTION_PROTO

/*
 * FUNCTION FOR PROCESS RTDS_Env:
 * ------------------------------
 */

RTDS_TASK_ENTRY_POINT( RTDS_Env )
    {
    /* To synchronize processes at startup time */
    RTDS_START_SYNCHRO_WAIT;
    
    RTDS_SDL_STATE_SET( RTDS_state_RTDS_Idle );

    /* Event loop */
    for ( ; ; )
        {
        /* Get message from process's message queue */
        RTDS_currentContext->currentMessage = ( RTDS_MessageHeader * )RTDS_MALLOC( sizeof( RTDS_MessageHeader ) );
        RTDS_MSG_QUEUE_READ( RTDS_currentContext->currentMessage );
        RTDS_currentContext->currentMessage->next = NULL;
        
        #ifdef RTDS_SIMULATOR
            RTDS_SIMULATOR_TRACE( RTDS_messageReceived , RTDS_currentContext->currentMessage , SELF , RTDS_currentContext );
            /* Release the message unique id back to the pool */
            RTDS_ReleaseMessageUniqueId( RTDS_currentContext->currentMessage->messageUniqueId );
        #endif

        #ifdef RTDS_ENV_FREE_PARAMETER
            if ( RTDS_currentContext->currentMessage->pData != NULL )
                {
                free( RTDS_currentContext->currentMessage->pData );
                }
        #endif

        /* Free memory */
        RTDS_FREE( RTDS_currentContext->currentMessage );
        RTDS_currentContext->currentMessage = NULL;
        } /* End of for ( ; ; ) */
    /* Resources clean up */
    RTDS_PROCESS_KILL;
    }

