source_folder_name=`dirname $0`
install_script=`basename $0`
osascript - <<.
tell application "Finder"
  activate
  set close_dialog to false
  set license_accepted to false
  repeat until close_dialog
  	set close_dialog to true
	  set dialog_answer to (display dialog "To install RTDS, you must agree to the End User License Agreement (EULA)." buttons {"Cancel installation", "Open EULA", "I have read and I agree to the EULA"})
  	if button returned of dialog_answer is "Open EULA" then
	  	tell application "TextEdit"
	  		activate
	  		open POSIX file "$source_folder_name/doc/LICENSE.txt"
	  	end tell
	  	set close_dialog to false
	  else if button returned of dialog_answer is "I have read and I agree to the EULA" then
	  	set license_accepted to true
	  end if
	end repeat
	if license_accepted then
	  activate
		set installation_folder to (choose folder with prompt "Select RTDS Installation folder:" default location "/Applications")
		set answer to (display dialog "This will install RTDS from $source_folder_name to " & (POSIX path of installation_folder) & ". OK to continue?" buttons {"Cancel", "OK"} default button "OK")
		if button returned of answer is "OK" then
			set installation_folder to (duplicate POSIX file "$source_folder_name" to folder installation_folder)
			set executable_folder to (folder "macosx" of folder "bin" of installation_folder)
			move item "RTDS.app" of executable_folder to installation_folder
			delete folder "bin" of installation_folder
			delete file "$install_script" of installation_folder
			set name of installation_folder to "RTDS"
			display dialog "Installation completed. If the installation tool opened a Terminal window, you can now close it safely.\nWelcome to PragmaDev RTDS!"
		end if
	end if
end tell
.