on run argv
	## Open document given as script's first argument in application Preview
	tell application "Preview"
		open item 1 of argv
		activate
	end tell
	## Preview cannot list its own windows, since it's not scriptable => go at system level
	tell application "System Events"
		## Check windows of *process* Preview, waiting for the one we want to appear
		set window_opened to false
		tell process "Preview"
			## 100 times with a 0.1 second delay => we wait for the window for 10 seconds, which should be enough, even for huge documents
			repeat 100 times
				delay 0.1
				## WARNING: For some reason, we can't browse window titles directly here, or the conversion of the title to a string fails
				## We have to browse every window, then ask for its title as a string
				repeat with preview_window in every window
					## Identifier string is given in second script argument
					if (title of preview_window as string) contains item 2 of argv then
						set window_opened to true
						perform action "AXRaise" of preview_window
						exit repeat
					end if
				end repeat
				if window_opened then exit repeat
			end repeat
		end tell
		## If window was opened, just send Commnd+P to the Preview application
		if window_opened then
			keystroke "p" using command down
			## If we couldn't find the window, no big deal: let's suppose the user will print it him/herself
		end if
	end tell
end run
