#include "externalSource.h"

/* ************************************************************************ *
                              mySimpleFunction
 * ************************************************************************ *
 * This function is called by the OUTGOING_MACRO macro called when sending
 * out an mOutgoing message in non debug mode.
 * ************************************************************************ */
void mySimpleFunction(int messageName, int size, void *pParameters){
  FILE *myFile;
  myFile = fopen("log.txt","a");
  fprintf(myFile,"Message mOutgoing: %d\n", ((RTDS_mOutgoing_data*)pParameters)->param1);
  fclose(myFile);
}


/* ************************************************************************ *
                              myHandCodedTask
 * ************************************************************************ *
 * This function is started in a separate thread.
 * It sends the mIncoming message to pMyProcess every second.
 * ************************************************************************ */
void myHandCodedTask(void){
RTDS_GlobalProcessInfo *RTDS_currentContext=NULL;
int counter=0;
RTDS_mIncoming_data *pParameter;

RTDS_currentContext = (RTDS_GlobalProcessInfo *)RTDS_MALLOC(sizeof(RTDS_GlobalProcessInfo));

for (;;)
  {
  #ifdef __WINDOWS__
	  Sleep(1000);
  #else
	  sleep(1);
  #endif
  
  pParameter = (RTDS_mIncoming_data *)RTDS_MALLOC(sizeof(RTDS_mIncoming_data));
  pParameter->param1 = counter;
  counter++;
  
  RTDS_MSG_QUEUE_SEND_TO_NAME(RTDS_message_mIncoming, sizeof(RTDS_mIncoming_data), pParameter, "pMyProcess",  RTDS_process_pMyProcess)
  }
}


/* ************************************************************************ *
                              myExternalFunction
 * ************************************************************************ *
 * This function is called by the start transition of pMyProcess.
 * It creates a hand written OS thread written above.
 * This is to illustrate how to have a hand written task to communicate
 * with an SDL-RT task.
 * ************************************************************************ */
#ifdef __WINDOWS__
void myExternalFunction(void)
{
	DWORD dwThreadId, dwThrdParam = 1;
	HANDLE hThread;
	HANDLE threadParam;

  /* Starts myHandCodedTask function in a separate thread */
	hThread = CreateThread(	NULL, 														 /* default security attributes    */
		0,																				   /* use default stack size         */
		(LPTHREAD_START_ROUTINE) myHandCodedTask,  /* thread function                */
		NULL,															             /* argument to thread function    */
		0,																				   /* use default creation flags     */
		&dwThreadId); 														               /* returns the thread identifier  */

	/* Check the return value and set priority */
	if (hThread == NULL)
		{
		exit(-1);
		}

}
#else
void myExternalFunction(void)
{
	int res;
	pthread_t tid;

	res = pthread_create(&tid, NULL,(void *(*)(void *))myHandCodedTask , NULL);

	/* Check the return value and set priority */
	if (res)
		{
		exit(-1);
		}

}
#endif
