import sys
import tempfile
from Tkinter import *
from tkMessageBox import showerror
import tkFileDialog
import socket
import os
import copy

# Dico 
dico_message = {}
dico_process_channel = {}
dico_template = {}
dico_transitions = {}   # Mapping state number to state(s) ,list of actions of the transition(s) and index for shorter way to go to this state (string -> list of list[string,list of string,int])
dico_param_type = {}
signalRoute2Processes = {}    #Mapping signalRoute to the two process at it extremity
TTCN_signal_dico = {}

IF2TTCNBaseTypeMapping = {                                
  'charstring'                            : ['charstring'],
  'RTDS_charstring'                       : ['charstring'],
  'RTDS_character'                        : ['charstring'],
  'integer'                               : ['integer'],
  'pid'                                   : ['pid'],
  'boolean'                               : ['boolean'],
  'real'                                  : ['float']
  }

# List 
pending_message = []
templatesList = []
command_list = []

globalNewTypes = {}                     ## Mapping new type name with their type (record, array,...) and their parameters if any.
nameMapping = {
  'charstring'                            : 'charstring',
  'rtds_charstring'                       : 'RTDS_charstring',
  'rtds_character'                        : 'RTDS_character',
  'integer'                               : 'integer',
  'pid'                                   : 'pid'   ,
  'boolean'                               : 'boolean'  ,
  'real'                                  : 'real'
}                                       ## Mapping new name with their corresponding TTCN name.

## FUNCTION usage:
## ---------------

def usage():
  """
  Prints the command usage and exits.
  """
  print "Usage: %s [ -MA | -AU <error file> <aut file> <state file> <IF file> <port number> ]" % sys.argv[0]
  sys.exit(0)

  
def _getFinalTransitions(autFileName,errorStates):
  """
  Return for each final state in the errorStates list the last transition.
  
  @param autFileName: Name for the transitions file.
  @type autFileName: string
  
  @param errorStates: list of final state to reach.
  @type errorStates: list of strings
  
  @return: The list of final transition.
  @rtype: list of strings
  """
  ## Get contents of the transition file
  autFile = open(autFileName)
  transitionLines = autFile.readlines()
  autFile.close()
  ## Get all transitions leading to the given final state
  transitions = []
  ## Loop until we get to the start state
  while transitionLines:
    ## The lines have to be read in reverse order, since we start from the *final* state
    transitionLine = transitionLines.pop()
    if transitionLine.startswith('des'):
      break
    ## Get state name
    i = transitionLine.index(',')
    endStateStart = transitionLine.index('",', i)
    endStateEnd = transitionLine.index(')', endStateStart)
    transitionEndState = transitionLine[endStateStart + 2:endStateEnd].strip()
    ## If transition end state is the end state we're looking for
    if transitionEndState in errorStates:
      ## Remember transition line
      err_obs_name = transitionLine[transitionLine.rfind('<<')+3:transitionLine.find('}',transitionLine.rfind('<<'))]
      transitions.append(err_obs_name + ": "+transitionEndState)
      errorStates.remove(transitionEndState)
      ## Get start state for transition and set it as new end state to look for
  ## We got the transition from the final one to the initial one => reverse them
  transitions.reverse()
  return transitions
  
  
## FUNCTION _getTransitionsToState:
## --------------------------------

def _getTransitionsToState(autFileName, finalState):
  """
  Reads the transition lines in a .aut file going from the start system state to the given final state.
  
  @param autFileName: Name for the transitions file.
  @type autFileName: string
  
  @param finalState: Final state to reach.
  @type finalState: string
  
  @return: The list of lines in the transitions file for all found transitions.
  @rtype: list of strings
  """
  ## Get contents of the transition file
  autFile = open(autFileName)
  transitionLines = autFile.readlines()
  autFile.close()
  ## Get all transitions leading to the given final state
  transitions = []
  wantedEndState = int(finalState)
  ## Loop until we get to the start state
  while wantedEndState != 0:
    ## The lines have to be read in reverse order, since we start from the *final* state
    transitionLine = transitionLines.pop()
    ## Get state name
    i = transitionLine.index(',')
    endStateStart = transitionLine.index('",', i)
    endStateEnd = transitionLine.index(')', endStateStart)
    transitionEndState = transitionLine[endStateStart + 2:endStateEnd].strip()
    ## If transition end state is the end state we're looking for
    if int(transitionEndState) == wantedEndState:
      ## Remember transition line
      transitions.append(transitionLine)
      ## Get start state for transition and set it as new end state to look for
      startStateStart = transitionLine.index('(')
      startStateEnd = transitionLine.index(',')
      wantedEndState = int(transitionLine[startStateStart + 1:startStateEnd])
  ## We got the transition from the final one to the initial one => reverse them
  transitions.reverse()
  return transitions

## FUNCTION _getStateMappings:
## ---------------------------

def _getStateMappings(stateFileName):
  """
  Reads a state file as written by an executable generated by if2gen and builds:
    - The mapping system state name to couple (process name, instance number) to state for instance;
    - The mapping (process name, instance number) to PID for process.
  
  @param stateFileName: Name of the state file to read.
  @type stateFileName: string
  
  @rtype: couple (mapping int -> couple (string, int) -> string, mapping couple (string, int) -> int)
  """
  ## Read the state file
  stateMapping, instanceMapping = {}, {}
  stateFile = open(stateFileName)
  try:
    currentSystemState, currentInstance = None, None
    lastPid = 0
    line = stateFile.readline()
    while line != '':
      line = line.strip()
      ## If line is a number followed by a colon, it's a system state
      if line.endswith(':'):
        try:
          currentSystemState = int(line[:-1].strip())
          currentInstance = None
        except (TypeError, ValueError):
          pass
      ## If line starts with a name enclosed in curly brackets followed by a number, it's a process name
      elif line.startswith('{'):
        endBracket = line.find('}')
        if endBracket != -1:
          processName = line[1:endBracket].strip()
          if processName != 'time':
            try:
              instanceNumber = int(line[endBracket + 1:].strip()[0])
            except (ValueError, TypeError):
              pass
            else:
              currentInstance = (processName, instanceNumber)
              if not instanceMapping.has_key(currentInstance):
                lastPid += 1
                instanceMapping[currentInstance] = lastPid
          else:
            currentSystemState = None
            currentInstance = None
      ## If line starts with a @, it's a process state: record it if possible
      elif line.startswith('@') and currentSystemState is not None and currentInstance is not None:
        words = line.split()
        stateName = words[0][1:]
        if not stateMapping.has_key(currentSystemState):
          stateMapping[currentSystemState] = {}
        stateMapping[currentSystemState][currentInstance] = stateName
      ## Next line
      line = stateFile.readline()
  ## Over
  finally:
    stateFile.close()
  ## Return built mappings
  return stateMapping, instanceMapping

  
  
  
def _adaptParameters(signalName, parametersList, parametersType):
  """
  Adapt the list of parameters as a command for msc.
  
  @param signalName: name of the signal
  @type signalName: string
  
  @param parametersList: list of all parameters.
  @type parametersList: list of string.
  
  @param signalsMapping: Mapping each signal name with their parameters types.
  @type signalsMapping: string -> list of string
  
  @rtype: string of adapted parameters.
  """
  
  adaptedParam = []
  for i, parameterType in enumerate(parametersType):
    if parameterType == "RTDS_charstring":
      parameter = parametersList[i][1:-2].split(',')
      paramCharstring = ""
      for asciichar in parameter:
        paramCharstring += chr(int(asciichar))
      adaptedParam.append(paramCharstring)
    elif parameterType == 'integer':
      adaptedParam.append(parametersList[i])
    elif parameterType == 'boolean':
      if parametersList[i] == "t":
        adaptedParam.append("true")
      else:
        adaptedParam.append("false")
    ## If parameters is a complex one:
    elif parameterType in globalNewTypes:
      ## If newtype is a range, range are done of integer, juste return integer value.
      if globalNewTypes[parameterType][0] == "range":
        adaptedParam.append(parametersList[i])
      if globalNewTypes[parameterType][0] == "record":
        parametersValue = parametersList[i][1:-1]
        openBracket = 0
        listedparametersValue = []
        firstWord = 0
        for j, char in enumerate(parametersValue):
          if char == '{':
            openBracket += 1
          elif char == '}':
            openBracket -= 1
          elif char ==',' and openBracket == 0:
            lastWord = j
            parameterValue = parametersValue[firstWord:lastWord]
            parameterName = parameterValue[:parameterValue.find('=')]
            listedparametersValue.append(parametersValue[firstWord:lastWord])
            firstWord = j+1
        listedparametersValue.append(parametersValue[firstWord:])
        adaptedRecordParamList = []
        for i,parameterValue in enumerate(listedparametersValue):
          value = parameterValue[parameterValue.find("=")+1:]
          name = globalNewTypes[parameterType][1][i][0]
          type = globalNewTypes[parameterType][1][i][1]
          adaptedRecordParam = _adaptParameters(signalName, [value], [type])
          adaptedRecordParamList.append("%s = %s" %( name, adaptedRecordParam))
        adaptedParam.append("{%s}" %(", ".join(adaptedRecordParamList)))
    else:
      adaptedParam.append(parametersList[i])
  return ", ".join(adaptedParam)

## METHODS FOR INDIVIDUAL COMMANDS GENERATION:
## -------------------------------------------

def _generateMessageSendCommand(traceFile, senderInstance, actionDetail, pidMapping, signalNumbers, currentTime, signalsMapping):
  """
  Generates the command for a message send.
  
  @param traceFile: File to write the command to.
  @type traceFile: file-like object, opened for writing
  
  @param senderInstance: Couple (process name, instance number) for the sender instance.
  @type senderInstance: couple (string, int)
  
  @param actionDetail: Detail for the transition action in the transition line.
  @type actionDetail: string
  
  @param pidMapping: Mapping couple (process name, instance number) to instance PID.
  @type pidMapping: mapping couple (string, int) -> int
  
  @param signalNumbers: Mapping signal name to signal number.
  @type signalNumbers: mapping string -> int
  
  @param currentTime: Logical time for the events in the transition line.
  @type currentTime: int
  """

  ## The format for the action detail is <signal name>{<signal parameters>}{<receiver process name>}<receiver instance number>
  lastOpenBracket = actionDetail.rfind('{')
  lastCloseBracket = actionDetail.rfind('}')
  firstOpenBracket = actionDetail.find('{')
  senderId = pidMapping[(senderInstance[0], senderInstance[1])]
  signalName = actionDetail[:firstOpenBracket].strip()
  parametersList = []
  ## Add signal name to signalNumbers if not in yet.
  if not signalNumbers.has_key(signalName):
    signalNumbers[signalName] = len(signalNumbers) +1
  if lastOpenBracket == -1 or lastCloseBracket == -1 or lastOpenBracket > lastCloseBracket:
    return
  
  ## If action ends with }, receiver is the environment.
  if actionDetail.endswith('}'):
    receiverProcessName = "RTDS_Env"
    ## Extract list of parameters if any.
    parameters = actionDetail[firstOpenBracket + 1:lastCloseBracket]
    
  ## If there is a receiver other than environment.
  else:
    ## Get receiver name and instance number.
    receiverProcessName = actionDetail[lastOpenBracket + 1:lastCloseBracket]
    receiverInstanceNumber = int(actionDetail[lastCloseBracket + 1:].strip())
    ## Extract parameters.
    parameters = actionDetail[firstOpenBracket + 1 : lastOpenBracket - 1]
    
  ## Store all parameters in a list, except first one which is sender Id, not needed in MSC trace.
  for param in parameters.split(',p')[1:]:
    parametersList.append(param[param.find("=")+1:])
  adaptedParam = ""
  adaptedParam = _adaptParameters(signalName, parametersList, signalsMapping[signalName])
  ## Create a new message unique Id
  messageUniqueId = 0
  while messageUniqueId in pending_message:
    messageUniqueId = messageUniqueId + 1
  ## Then we add this message identifier to the list of pending messages
  pending_message.append(messageUniqueId)
  
  ## If receiver or not, write the send command.
  traceFile.write("ms| -t%s| " % currentTime)
  if adaptedParam != "":
    traceFile.write("-d%s| " % adaptedParam)
  traceFile.write("-n%s| -i%s| %s| %s| %s|\n" % (senderInstance[0], messageUniqueId,senderId, signalNumbers[signalName], signalName))
  
  ## If receiver is the env, make the reception command line.
  if receiverProcessName == "RTDS_Env":
    traceFile.write("mr| -t%s| "  %currentTime)
    if adaptedParam != "":
      traceFile.write("-d%s| " % adaptedParam)
    traceFile.write("-n%s| -i%s| %s| %s| %s|\n" %('RTDS_Env', messageUniqueId, pidMapping['RTDS_Env'],signalNumbers[signalName],signalName))
    pending_message.remove(messageUniqueId)
  ## Else, remember message Id to be reused during message reception.
  else:
    if signalRoute2Processes.has_key(receiverProcessName):
      for processName in signalRoute2Processes[receiverProcessName]:
        if processName != senderInstance[0]:
          receiverId = pidMapping[(processName, 0)]
    else:
      receiverId = pidMapping[(receiverProcessName, receiverInstanceNumber)]
    ## We see if we already have this kind of key
    ## if yes so we just have to append the unique identifier of this pending message
    if (dico_message.has_key((signalName, receiverId, senderId))):
      dico_message[(signalName, receiverId, senderId)].append(messageUniqueId)
    ## If not we create this element in the dictionnary
    else:
      dico_message[(signalName, receiverId, senderId)] = [messageUniqueId]
  
def _generateMessageReceiveCommand(traceFile, receiverInstance, actionDetail, pidMapping, signalNumbers, currentTime, signalsMapping):
  """
  Generates the command for a message receive.
  
  @param traceFile: File to write the command to.
  @type traceFile: file-like object, opened for writing
  
  @param receiverInstance: Couple (process name, instance number) for the receiver instance.
  @type receiverInstance: couple (string, int)
  
  @param actionDetail: Detail for the transition action in the transition line.
  @type actionDetail: string
  
  @param pidMapping: Mapping couple (process name, instance number) to instance PID.
  @type pidMapping: mapping couple (string, int) -> int
  
  @param signalNumbers: Mapping signal name to signal number.
  @type signalNumbers: mapping string -> int
  
  @param currentTime: Logical time for the events in the transition line.
  @type currentTime: int
  """
  
  lastOpenBracket = actionDetail.rfind('{')
  lastCloseBracket = actionDetail.rfind('}')
  firstOpenBracket = actionDetail.find('{')
  receiveId = pidMapping[(receiverInstance[0], receiverInstance[1])]
  signalName = actionDetail[:firstOpenBracket].strip()
  parametersList = []
  
  ## Get messsage parameters
  parameters = actionDetail[firstOpenBracket + 1 : lastOpenBracket - 1]
  for param in parameters.split(',p'):
    parametersList.append(param[param.find("=")+1:])
  
  adaptedParam = ""
  adaptedParam = _adaptParameters(signalName, parametersList[1:], signalsMapping[signalName])
  
  senderInstance = parametersList[0]

  ## Compute and record signal number if needed
  if not signalNumbers.has_key(signalName):
    signalNumbers[signalName] = 1 + len(signalNumbers)
  ## We have to check if this message is pending or not
  ## To do this we try to identify the unique pID of the sender
  ## then if we find one we just have to remove the unique ID of the message from the table of message ID
  ## if not this message has no sender then we write a different command in the trace file
  ## If sender is the env, need to add a send command from the env
  if senderInstance == "{nil}0":
    
    ## Create a new message unique Id
    messageUniqueId = 0
    while messageUniqueId in pending_message:
      messageUniqueId = messageUniqueId + 1
    ## Then we add this message identifier to the list of pending messages
    pending_message.append(messageUniqueId)
    
    traceFile.write("ms| -t%s| " % currentTime)
    if adaptedParam != "":
      traceFile.write("-d%s| " % adaptedParam)
    traceFile.write("-n%s| -i%s| %s| %s| %s|\n" % ('RTDS_Env', messageUniqueId, pidMapping['RTDS_Env'], signalNumbers[signalName], signalName))
  
  else:
    
    senderProcessName = senderInstance[1:senderInstance.find('}')]
    senderInstanceNumber = int(senderInstance[senderInstance.find('}') + 1:])
    
    
    senderId = pidMapping[(senderProcessName, senderInstanceNumber)]
    messageUniqueId = dico_message[(signalName, receiveId, senderId)].pop(0)
  
  traceFile.write("mr| -t%s| " % currentTime)
  if adaptedParam != "":
    traceFile.write("-d%s| " % adaptedParam)
  traceFile.write("-n%s| -i%s| %s| %s| %s|\n" % (receiverInstance[0], messageUniqueId,receiveId, signalNumbers[signalName], signalName))
  ## delete message unique ID from list cause message has been received
  pending_message.remove(messageUniqueId)
    

def _generateProcessCreateCommand(traceFile, creatorInstance, actionDetail, pidMapping, signalNumbers, currentTime, signalsMapping):
  """
  Generates the command for create a process.
  
  @param traceFile: File to write the command to.
  @type traceFile: file-like object, opened for writing
  
  @param creatorInstance: Couple (process name, instance number) for the creator instance.
  @type creatorInstance: couple (string, int)
  
  @param actionDetail: Detail for the transition action in the transition line.
  @type actionDetail: string
  
  @param pidMapping: Mapping couple (process name, instance number) to instance PID.
  @type pidMapping: mapping couple (string, int) -> int
  
  @param signalNumbers: Mapping signal name to signal number.
  @type signalNumbers: mapping string -> int
  
  @param currentTime: Logical time for the events in the transition line.
  @type currentTime: int
  """
  lastOpenBracket = actionDetail.rfind('{')
  lastCloseBracket = actionDetail.rfind('}')
  if lastOpenBracket == -1 or lastCloseBracket == -1 or lastOpenBracket > lastCloseBracket:
    return
  processName = actionDetail[lastOpenBracket + 1:lastCloseBracket]
  processNum = int(actionDetail[lastCloseBracket + 1:])
  ## Write command for process creation
  traceFile.write("pc| -t%s| -c%s| -n%s| %s|\n" % (currentTime, pidMapping[(creatorInstance[0], creatorInstance[1])], processName, pidMapping[(processName, processNum)]))
  
def _generateProcessKillCommand(traceFile, killedInstance, actionDetail, pidMapping, signalNumbers, currentTime, signalsMapping):
  """
  Generates the command for kill a process.
  
  @param traceFile: File to write the command to.
  @type traceFile: file-like object, opened for writing
  
  @param killedInstance: Couple (process name, instance number) for the killed instance.
  @type killedInstance: couple (string, int)
  
  @param actionDetail: Detail for the transition action in the transition line.
  @type actionDetail: string
  
  @param pidMapping: Mapping couple (process name, instance number) to instance PID.
  @type pidMapping: mapping couple (string, int) -> int
  
  @param signalNumbers: Mapping signal name to signal number.
  @type signalNumbers: mapping string -> int
  
  @param currentTime: Logical time for the events in the transition line.
  @type currentTime: int
  """
  ##Write command for process murderer
  traceFile.write("pd| -t%s| -n%s| %s|\n" % (currentTime, killedInstance[0], pidMapping[(killedInstance[0], killedInstance[1])]))

_actionCode2Method = {
  '!' : _generateMessageSendCommand,
  '?' : _generateMessageReceiveCommand,
  '#' : _generateProcessCreateCommand,
  'k' : _generateProcessKillCommand
}
  
## FUNCTION _generateCommand:
## --------------------------

def _generateCommand(traceFile, currentTime, transitionLine, stateMapping, pidMapping, signalNumbers, signalsMapping):
  """
  Generates the MSC Tracer command(s) corresponding to a line in a transition file.
  
  @param traceFile: File where the command should be written.
  @type: traceFile: file-like object, opened for writing
  
  @param currentTime: Logical time for the events in the transition line.
  @type currentTime: int
  
  @param transitionLine: Line describing the transition in the C{.aut} file.
  @type transitionLine: string
  
  @param stateMapping: Mapping system state to couple (process name, instance number) to instance state.
  @type stateMapping: mapping int -> couple (string, int) -> string
  
  @param signalsMapping: Mapping each signal name with their parameters types.
  @type signalsMapping: string -> list of string
  """
  ## Each line is a triplet (start state, action string, end state)
  transitionLine = transitionLine.strip()
  if not transitionLine.startswith('(') or not transitionLine.endswith(')'):
    return
  firstComma = transitionLine.find(',')
  lastComma = transitionLine.rfind(',')
  if firstComma == -1 or lastComma == -1:
    return
  try:
    startState = int(transitionLine[1:firstComma].strip())
    endState = int(transitionLine[lastComma + 1:-1].strip())
  except (ValueError, TypeError):
    return
  actionString = transitionLine[firstComma + 1:lastComma].strip()
  if not actionString.startswith('"') or not actionString.endswith('"'):
    return
  actionString = actionString[1:-1].strip()
  ## The action string contains a list of actions, each surrounded by << and >>
  actions = []
  actionStart = actionString.find('<<')
  while actionStart != -1:
    actionEnd = actionString.find('>>', actionStart)
    if actionEnd == -1:
      break
    actions.append(actionString[actionStart + 2:actionEnd].strip())
    actionStart = actionString.find('<<', actionEnd)
  ## Browse the actions
  for actionString in actions:
    ## Each action string is "{<process name>}<instance number> <action code character><action detail>"
    if not actionString.startswith('{'):
      continue
    processNameEnd = actionString.find('}')
    if processNameEnd == -1:
      continue
    processName = actionString[1:processNameEnd].strip()
    words = actionString[processNameEnd + 1:].split(None, 1)
    try:
      instanceNumber = int(words[0])
      actionCode = words[1][0]
      actionDetail = words[1][1:]
    except (ValueError, TypeError, IndexError):
      continue
    ## Use generation function corresponding to action code
    if _actionCode2Method.has_key(actionCode):
      _actionCode2Method[actionCode](traceFile, (processName, instanceNumber), actionDetail, pidMapping, signalNumbers, currentTime, signalsMapping)

## FUNCTION generateTrace:
## -----------------------

def generateTrace(autFileName, stateFileName, ifFileName, finalState, portNumber, newTypes, signalsMapping):
  """
  Generates the trace for the given final state as described in the given transition and state files and send
  it to RTDS through the given socket port.
  
  @param autFileName: Name for the transition file.
  @type autFileName: string
  
  @param stateFileName: Name for the state file.
  @type stateFileName: string
  
  @param stateFileName: Name for the if file.
  @type stateFileName: string
  
  @param finalState: Final state for the trace to generate.
  @type finalState: string
  
  @param portNumber: Port number for the communication socket with RTDS.
  @type portNumber: int
  
  @param signalsMapping: Mapping each signal name with their parameters types.
  @type signalsMapping: string -> list of string
  """
  global globalNewTypes

  globalNewTypes = newTypes
  ## Get transitions from start state to final one
  try:
    transitions = _getTransitionsToState(autFileName, finalState)
  except Exception, exc:
    showerror("Erreur", "Probleme lors de la lecture du fichier .aut:\n%s" % exc)
    return
  ## Built mappings from system state to process states and for instance PIDs
  try:
    stateMapping, pidMapping = _getStateMappings(stateFileName)
  except (OSError, IOError), exc:
    showerror('Erreur states', 'Probleme lors de la lecture du fichier .state:\n%s' % exc)
    return
  ## Actually generate the trace file
  try:
    traceFileName = tempfile.mktemp('.trace')
    traceFile = open(traceFileName, 'w') 
  except (OSError, IOError), exc:
    showerror("Erreur trace", "Impossible d'ouvrir le fichier de trace MSC %s:\n%s" % (traceFileName, exc))
    return
  try:
    currentTime = 10
    ## Write lifeline for Env
    pidMapping['RTDS_Env']='0'
    traceFile.write("pc| -t%s| -n%s| %s|\n" % (currentTime, 'RTDS_Env', pidMapping['RTDS_Env']))
    ## Write process creation commands for initial processes
    if stateMapping.has_key(0):
      for instance in stateMapping[0].keys():
        traceFile.write("pc| -t%s| -n%s| %s|\n" % (currentTime, instance[0], pidMapping[instance]))
        traceFile.write("ps| -t%s| -n%s| %s| %s|\n" %(currentTime+20,instance[0],pidMapping[instance],stateMapping[0][instance]))
    currentTime = 40
    ## Generate MSC tracer commands for all transition lines
    signalNumbers = {}
    for transitionLine in transitions:
      state_start = transitionLine[transitionLine.find('(')+1:transitionLine.find(',')]
      state_end = transitionLine[transitionLine.rfind(',')+1:transitionLine.find(')')]
      currentTime += 10
      _generateCommand(traceFile, currentTime, transitionLine.strip(), stateMapping, pidMapping, signalNumbers, signalsMapping)
      for instance in stateMapping[int(state_end)].keys():
        if stateMapping[int(state_start)].has_key(instance):
          if stateMapping[int(state_start)][instance] != stateMapping[int(state_end)][instance]:
            traceFile.write("ps| -t%s| -n%s| %s| %s|\n" %(currentTime,instance[0],pidMapping[instance],stateMapping[int(state_end)][instance]))
        else:
          traceFile.write("ps| -t%s| -n%s| %s| %s|\n" %(currentTime,instance[0],pidMapping[instance],stateMapping[int(state_end)][instance]))
  finally:
    traceFile.close()
    # Then we just have to send the command with file in parameter
    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        s.connect(('127.0.0.1', portNumber))
    except:
        showerror("Erreur socket", "Connexion error with socket number")
    else:
    
        s.send('openmsc %s\n' % traceFileName)
        
        """
        traceFile = open(traceFileName, 'r') 
        lines = traceFile.readlines()
        for command in lines:
          s.send(command)
        """
        
        s.close()
        
##TTCN part

def recordName(name):
  """
  record new name with RTDS prefix for further use
  """
  lowerName = name.lower()
  if lowerName in nameMapping:
    name = nameMapping[lowerName]
  else:
    nameMapping[lowerName] = "RTDS_%s" %name
    name = nameMapping[lowerName]
  return name


## FUNCTION getRecordforTTCN:
## --------------------------------

def getRecordforTTCN(traceFile,IFFileName,systemName):
  """
  Get all the records needed for TTCN.
  
  @param traceFile: TTCN File where we will written.
  @type: traceFile: file-like object, opened for writing
  
  @param IFFileName: Name for the IF file.
  @type IFFileName: string
  
  @param systemName: Name of the IF system.
  @type systemName: string
  """
  IFFile = open(IFFileName)
  dico_channel_message = {}
  All_signal_dico = {}
  nestIndex = 1
  try:
    line=IFFile.readline()
    traceFile.write('  '*nestIndex+'// New types declarations\n')
    while not line.startswith('signal'):
      if line.startswith('type'):
        if not ((line.split()[1] == 'RTDS_character') or (line.split()[1] == 'RTDS_charstring')):
          type = line.split()[3]
          name = line.split()[1]
          name = recordName(name)
          ##if newtype is a range, replace by an integer
          if (type.startswith('range')):
            IF2TTCNBaseTypeMapping[name]=['integer']
          
          ##if newtype is a struct, build a record to replace it
          if (type.startswith('record')):
            Record_param=['record '+name]
            line = IFFile.readline()
            while not line.startswith('endrecord'):
              paramType = recordName(line.split()[1][:-1])
              paramName = line.split()[0]
              if IF2TTCNBaseTypeMapping[paramType][0].startswith('record '):
                Record_param.append("%s %s" %(paramType, paramName))
              elif IF2TTCNBaseTypeMapping[paramType][0].startswith('array '):
                Record_param.append("%s %s" %(paramType, paramName))
              else:
                Record_param.append("%s %s" %(IF2TTCNBaseTypeMapping[paramType][0],paramName))
              line = IFFile.readline()
            traceFile.write('  '*nestIndex+'type record %s {\n    ' %name)
            traceFile.write(',\n    '.join(Record_param[1:])+'\n    };\n\n')
            IF2TTCNBaseTypeMapping[name]=Record_param
          
          ##if newtype is an array,replace by an array in TTCN
          if (type.startswith('array[')):
            typeofelement = line.split()[5][:-1]
            typeofelement = recordName(typeofelement)
            size = type[type.find('[')+1:type.rfind(']')]
            traceFile.write('  type %s %s[%s];\n\n' %(typeofelement,name,size))
            IF2TTCNBaseTypeMapping[name]=['array '+name,type,size]

      line = IFFile.readline()

    traceFile.write('  '*nestIndex+'// Records declaration\n')
    while not line.startswith('signalroute'):
      if line.startswith('signal'):
        NewType_params=[]
        if line.find(', ') != -1:
          for param in line[line.find(', ')+2:line.rfind(')')].split(', '):
            NewType_params.append(IF2TTCNBaseTypeMapping[recordName(param)][0])
        All_signal_dico[line[7:line.find('(')]]=NewType_params
      line = IFFile.readline()
    while not line.startswith('process'):
      if line.startswith('signalroute'):
        channel_name = (line[line.find('_C_')+3:line.find('_M_')])
        signalroute_name = line[12:line.find('(')]
        line = IFFile.readline()
        sender = line.split()[1]
        line = IFFile.readline()
        receiver = line.split()[1]
        if (sender == 'env' or receiver =='env'):
          line = IFFile.readline()
          signalName = line[5:-2]
          if signalName in All_signal_dico:
            TTCN_signal_dico[signalName]=[All_signal_dico[signalName],sender,receiver]
            if sender == 'env':
              process_name = (signalroute_name[signalroute_name.find('_P_')+3:])
              direction='out '
            if receiver == 'env':
              process_name = (signalroute_name[2:signalroute_name.find('_C_')])
              direction='in  '
              continue
            if not dico_process_channel.has_key(signalName):
              dico_process_channel[signalName] = channel_name
            if dico_channel_message.has_key(channel_name):
              dico_channel_message[channel_name] = dico_channel_message[channel_name] + ';\n    ' + direction+' '+signalName
            else :
              dico_channel_message[channel_name] = '    '+direction+' '+signalName
      if line.startswith('Messages name and corresponding channel received by the environment'):
        line = IFFile.readline()
        while not line.startswith('=========='):
          list = line.split()
          signalList = line.split()[3:]
          channel = line.split()[1]
          for signalName  in signalList:
            if not dico_process_channel.has_key(signalName):
              dico_process_channel[signalName] = channel
            if dico_channel_message.has_key(channel):
              dico_channel_message[channel] = "%s;\n    in %s" %( dico_channel_message[channel], signalName)
            else :
              dico_channel_message[channel] = '    in %s' %signalName
          
          line = IFFile.readline()
      line = IFFile.readline()
    for record in TTCN_signal_dico:
      params,sender,receiver = TTCN_signal_dico[record]
      traceFile.write('  '*nestIndex+'type record ' + record + ' {')
      ## Store parameters in a list
      parametersList = []
      nestIndex += 1
      for i,param in enumerate(params):
        if param.startswith('record ') or param.startswith('array '):
          parametersList.append('  '*nestIndex+'%s %s_param%s' %(param.split()[1],record,str(i+1)))
        else:
          parametersList.append('  '*nestIndex+'%s %s_param%s' %(param,record,str(i+1)))
      if parametersList != []:
        traceFile.write('\n')
        traceFile.write(',\n'.join (parametersList))
        traceFile.write('\n')
      traceFile.write('  '*nestIndex+'};\n\n')
      nestIndex -= 1
  finally:
    traceFile.write('  '*nestIndex+'// Ports and components declaration\n')
    for channelName in dico_channel_message:
      traceFile.write('  '*nestIndex+'type port cEnv_%s message {\n%s\n' %(channelName,dico_channel_message[channelName]))
      nestIndex += 1
      traceFile.write('  '*nestIndex+'}\n\n')
      nestIndex -= 1
    traceFile.write('  '*nestIndex+'type component '+systemName+' {\n')
    nestIndex += 1
    for channelName in dico_channel_message:
      traceFile.write('  '*nestIndex+'port cEnv_'+channelName+' '+channelName+';\n')
    traceFile.write('  '*nestIndex+'};\n\n')
    IFFile.close()

## FUNCTION getAllTransitionsforTTCN:
## --------------------------------  

def getAllTransitionsforTTCN(autFileName, traceFile):
  """
  Get all the transitions in param.aut and put them in the dictionary dico_transitions.

  @param autFileName: Name for the aut file.
  @type autFileName: string
  """
  
  dico_transitions['0']=[['',[''],0]]
  for i,line in enumerate(file(autFileName)):
    if line.startswith('des'):
      transitionNumber = line[line.find(',')+1:line.rfind(',')]
      stateNumber = line[line.rfind(',')+1:line.find(')')]
    else:
      startState=line[line.find('(')+1:line.find(',')]
      endState=line[line.rfind(',')+1:line.rfind(')')]
      transition=line[line.find('"<<')+3:line.rfind('>> "')]
      
      ## Find the shorter way in all previous transitions.
      shorter_way_value = 0
      for transition_info in dico_transitions[startState]:
        if shorter_way_value > transition_info[2]+1 or shorter_way_value ==0:
          shorter_way_value = transition_info[2]+1
      
      ##get all actions in a the transition line
      if transition.find('>> <<') != -1:
        list_of_actions=transition.split('>> <<')
      else:
        list_of_actions=[transition]
      
      adpated_LoA = adaptTransitions(list_of_actions,traceFile)
      if adpated_LoA == []:
        shorter_way_value -=  1
      ##update dico_transitions
      if dico_transitions.has_key(endState):
        dico_transitions[endState].append([startState,adpated_LoA,shorter_way_value])
      else:
        dico_transitions[endState]=[[startState,adpated_LoA,shorter_way_value]]

## FUNCTION generateMessageSendCommandforTTCN:
## --------------------------------

def adaptTransitions(actionsList, traceFile):
  """
  Clear the list of action to keep only action actions needed in TTCN.
  
  @param actionsList: list of actions in a transition line.
  @type actionsList: list of string
  
  @return: list of action needed in TTCN
  @rtype: list of string
  """

  adaptedList=[]
  for action in actionsList:
    action_detail = action.split()
    process_name = action_detail[0][action_detail[0].find('{')+1:action_detail[0].rfind('}')]
    process_instance = action_detail[0][action_detail[0].find('}')+1:]
    actionCode = action_detail[1][0]
    action = action_detail[1][1:]
    ## If Timer, nothing to do 
    ##if process_name == 'time':
      ##adaptedList.append(['timer',['t.start('+action[1:]+')']])
      ##adaptedList.append(['timer',['t.timeout']])
    
    ## Call method to adapt command for TTCN.
    if actionCode in _actionCode2MethodforTTCN:
      portName, signalName, templateNumber = _actionCode2MethodforTTCN[actionCode](action,traceFile)
      if actionCode == '?' and portName != '':
        adaptedList.append(['output',[portName,signalName,templateNumber]])
      if actionCode == '!' and portName != '':
        adaptedList.append(['input',[portName,signalName,templateNumber]])
       
  return adaptedList
  
  
## FUNCTION generateMessageSendCommandforTTCN:
## --------------------------------

def decodeReceiveCommandforTTCN(action,traceFile):
  """
  Get information for a message reception in TTCN.
  
  @param actionDetail: Detail for the transition action in the transition line.
  @type actionDetail: string
  
  @return: list [portName, signalName, templateNumber]
  @rtype: L[string,string,string]
  """
  ## Find signal name in command line
  signalName = action[:action.find('{')]
  if signalName in TTCN_signal_dico:
    ## If action ends with }, means no receiver declared => receiver is env
    if action.endswith('}'):
      ## Extract list of parameters if any
      parameters = action[action.find('{')+1:action.rfind('}')]
      newParamAssignments = ()
      parametersList = parameters.split(',p')[1:]
      for i,param in enumerate(parametersList):
        if TTCN_signal_dico[signalName][0][i] == 'charstring':
          paramCharstring = ''
          for ASCII in param[param.find('{')+1:param.find(',}')].split(','):
            paramCharstring += chr(int(ASCII))
          newParamAssignments = newParamAssignments + (signalName+'_param%s=\"%s\"' % (i+1,paramCharstring),)
        elif TTCN_signal_dico[signalName][0][i] == 'integer':
          newParamAssignments = newParamAssignments + (signalName+'_param%s=%s' % (i+1,param[param.find('=')+1:]),)
        elif TTCN_signal_dico[signalName][0][i] == 'boolean':
          if param[param.find('=')+1:] == 't':
            newParamAssignments = newParamAssignments + (signalName+'_param%s=true' %(i+1),)
          else:
            newParamAssignments = newParamAssignments + (signalName+'_param%s=false' %(i+1),)
        elif TTCN_signal_dico[signalName][0][i].startswith('record '):
          newParamAssignments = newParamAssignments + (signalName+'_param%s=%s' % (i+1,decodeRecord(param[param.find('=')+2:-1],TTCN_signal_dico[signalName][0][i],3,traceFile)),)
        elif TTCN_signal_dico[signalName][0][i].startswith('array'):
          newParamAssignments = newParamAssignments + (signalName+'_param%s={}' %str(i+1),)
        else:
          newParamAssignments = newParamAssignments + (signalName+'_param%s=%s' % (i+1,param[param.find('=')+1:]),)
      if not dico_template.has_key((signalName,newParamAssignments)):
        signalIndex = 1
        for template in dico_template:
          if template[0] == signalName:
            signalIndex += 1
        dico_template[(signalName,newParamAssignments)] = signalIndex
      if not ([signalName,str(dico_template[(signalName,newParamAssignments)]),newParamAssignments]) in templatesList:
        templatesList.append([signalName,str(dico_template[(signalName,newParamAssignments)]),newParamAssignments])
  ## If signal is sent or received by env
  if signalName in dico_process_channel:
    return [dico_process_channel[signalName],signalName,str(dico_template[(signalName,newParamAssignments)])]
  else:
    return ['','','']
  
  
## FUNCTION generateMessageReceiveCommandforTTCN:
## --------------------------------

def decodeSendCommandforTTCN(action,traceFile):
  """
  Get information for a message sending in TTCN.
  
  @param action: action description.
  @type action: string
  
  @return: list [portName, signalName, templateNumber]
  @rtype: L[string,string,string]
  """
  ## Remove receiver process from action
  action = action[:action.rfind('{')]
  signalName = action[:action.find('{')]
  if signalName in TTCN_signal_dico:
    ## First parameter is the sender pid
    sender = action[action.find('p1={')+4:action.find('}')]
    ##if sender is nil (aka env), action is interesting for TTCN
    if sender =='nil':
      parameters = action[action.find('{')+1:action.rfind('}')]
      newParamAssignments = ()
      parametersList = parameters.split(',p')[1:]
      ##for each param, find the type and the value
      for i,param in enumerate(parametersList):
        if TTCN_signal_dico[signalName][0][i] == 'charstring':
          paramCharstring = ''
          for ASCII in param[param.find('{')+1:param.find(',}')].split(','):
            paramCharstring += chr(int(ASCII))
          newParamAssignments = newParamAssignments + (signalName+'_param%s=\"%s\"' % (i+1,paramCharstring),)
        elif TTCN_signal_dico[signalName][0][i] == 'integer':
          newParamAssignments = newParamAssignments + (signalName+'_param%s=%s' % (i+1,param[param.find('=')+1:]),)
        elif TTCN_signal_dico[signalName][0][i] == 'boolean':
          if param[param.find('=')+1:] == 't':
            newParamAssignments = newParamAssignments + (signalName+'_param%s=true' %(i+1),)
          else:
            newParamAssignments = newParamAssignments + (signalName+'_param%s=false' %(i+1),)
        elif TTCN_signal_dico[signalName][0][i].startswith('record '):
          newParamAssignments = newParamAssignments + (signalName+'_param%s=%s' % (i+1,decodeRecord(param[param.find('=')+2:-1],TTCN_signal_dico[signalName][0][i],3,traceFile)),)
        elif TTCN_signal_dico[signalName][0][i].startswith('array'):
          newParamAssignments = newParamAssignments + (signalName+'_param%s={}' %i+1)
        else:
          newParamAssignments = newParamAssignments + (signalName+'_param%s=%s' % (i+1,param[param.find('=')+1:]),)
      if not dico_template.has_key((signalName,newParamAssignments)):
        signalIndex = 1
        for template in dico_template:
          if template[0] == signalName:
            signalIndex += 1
        dico_template[(signalName,newParamAssignments)] = signalIndex
      if not ([signalName,str(dico_template[(signalName,newParamAssignments)]),newParamAssignments]) in templatesList:
        templatesList.append([signalName,str(dico_template[(signalName,newParamAssignments)]),newParamAssignments])
  ## If signal is sent or received by env
  if signalName in dico_process_channel:
    return [dico_process_channel[signalName],signalName,str(dico_template[(signalName,newParamAssignments)])]
  else:
    return ['','','']

_actionCode2MethodforTTCN = {
  '!' : decodeReceiveCommandforTTCN,
  '?' : decodeSendCommandforTTCN
}
  
## FUNCTION decodeRecord
  
def decodeRecord(paramInfo,signalName,index,traceFile):
  """
  Decode informations in structure case.
  
  @param action: parameter information.
  @type action: string
  
  @param action: signal name.
  @type action: string
  
  @param index: for page setup
  @param index: int
  
  @return: decoded data
  @rtype: string
  """
  decodedRecord = ''
  decodedRecord+=('{\n')
  for i,paramtype in enumerate(IF2TTCNBaseTypeMapping[signalName.split()[1]][1:]):
    if IF2TTCNBaseTypeMapping[paramtype.split()[0]][0].startswith('integer'):
      if paramInfo.find(',') != -1:
        decodedRecord+=('  '*index+paramInfo[:paramInfo.find(',')]+',\n')
        paramInfo = paramInfo[paramInfo.find(',')+1:]
      else:
        decodedRecord+=('  '*index+'%s\n' %paramInfo)
        paramInfo = ''
    elif IF2TTCNBaseTypeMapping[paramtype.split()[0]][0].startswith('array'):
      if paramInfo.find('},') != -1:
        decodedRecord+=('  '*index+'%s{}' %paramInfo[:paramInfo.find('=')+1]+',\n')
        paramInfo = paramInfo[paramInfo.find(',}')+3:]
      else:
        decodedRecord+=('  '*index+'%s{}\n' %(paramInfo[:paramInfo.find('=')+1]))
    elif IF2TTCNBaseTypeMapping[paramtype.split()[0]][0].startswith('real'):
      if paramInfo.find(',') != -1:
        decodedRecord+=('  '*index+paramInfo[:paramInfo.find(',')]+',\n')
        paramInfo = paramInfo[paramInfo.find(',')+1:]
      else:
        decodedRecord+=('  '*index+'%s\n' %paramInfo)
        paramInfo = ''
    elif IF2TTCNBaseTypeMapping[paramtype.split()[0]][0].startswith('boolean'):
      if paramInfo.find(',') != -1:
        if paramInfo[paramInfo.find('=')+1:paramInfo.find('=')+2] == 't':
          decodedRecord+=('  '*index+paramInfo[:paramInfo.find(',')]+'rue,\n')
        else:
          decodedRecord+=('  '*index+paramInfo[:paramInfo.find(',')]+'alse,\n')
        paramInfo = paramInfo[paramInfo.find(',')+1:]
      else:
        if paramInfo[paramInfo.find('=')+1:paramInfo.find('=')+2] == 't':
          decodedRecord+=('  '*index+'%srue\n' %paramInfo)
        else:
          decodedRecord+=('  '*index+'%salse\n' %paramInfo)
    elif IF2TTCNBaseTypeMapping[paramtype.split()[0]][0].startswith('charstring') or IF2TTCNBaseTypeMapping[paramtype.split()[0]][0].startswith('charstring'):
      paramCharstring = ''
      if paramInfo.find('},') != -1:
        for ASCII in paramInfo[paramInfo.find('=')+2:paramInfo.find(',}')].split(','):
          paramCharstring += chr(int(ASCII))
        decodedRecord+=('  '*index+'%s"%s",\n' %(paramInfo[:paramInfo.find('=')+1],paramCharstring))
        paramInfo = paramInfo[paramInfo.find(',}')+3:]
      else:
        for ASCII in paramInfo[paramInfo.find('=')+2:paramInfo.find(',}')].split(','):
          paramCharstring += chr(int(ASCII))
        decodedRecord+=('  '*index+'%s"%s"\n' %(paramInfo[:paramInfo.find('=')+1],paramCharstring))
    elif IF2TTCNBaseTypeMapping[paramtype.split()[0]][0].startswith('record '):
      decodedRecord+=('  '*index+paramInfo[:paramInfo.find('=')+1])
      decodedRecord+=decodeRecord(paramInfo[paramInfo.find('{')+1:paramInfo.find('}')],IF2TTCNBaseTypeMapping[paramtype.split()[0]][0],index+1,traceFile)+'\n'
      paramInfo = paramInfo[paramInfo.find('}')+1:]
  decodedRecord+=('  '*index+'}')
  return decodedRecord


## FUNCTION GenerateTestCaseByShorterWay

def GenerateTestCaseByShorterWay(state, traceFile):
  """
  Generates a TTCN testcase for the given final state, explore only one way, the shorter.
  
  @param state: final state chosen by user.
  @type state: string
  
  @return: TTCN testcase
  @rtype: list of string
  
  @return: template used in that case
  @rtype: list of string
  """
  IFTransistionsList = []
  requiredTestcaseTemplates = []
  ## While we are not in initial state
  while state != '0':
    shorterWay = -1
    for transition in dico_transitions[state]:
      ## Find shortest way for one transition
      if shorterWay < 0 or shorterWay > transition[2]:
        shorterWay = transition[2]
        shorterTransition = transition
    ## Store shortest way
    if shorterTransition[1] != []:
      IFTransistionsList.append(shorterTransition[1])
    ## If action in transition is communication
    for action,transition in shorterTransition[1]:
      if action in ('output','input'):
        ## Store communication info for declare template
        requiredTestcaseTemplates.append("%s_%s" %(transition[1],transition[2]))
    state = shorterTransition[0]
  IFTransistionsList.reverse()
  TTCNActionList = []
  for IFTransition in IFTransistionsList:
    for action in IFTransition:
      TTCNActionList.append(action)
  adaptedTTCNtestcase = adaptForAlternativeTestCase(TTCNActionList)
  return adaptedTTCNtestcase,requiredTestcaseTemplates


## FUNCTION buildAlternativeTestCase
  
def adaptForAlternativeTestCase(TTCNActionList):
  """
  Build a list of TTCN action to easily used it for alternative case.
  
  @param TTCNtestcaseList: list of actions.
  @type TTCNtestcaseList: 
  
  @return: TTCN testcases
  @rtype: list of string
  """
  adaptedActionList = []
  for i, action in enumerate(TTCNActionList):
    ## If action is a send, just add it to the list of actions.
    if action[0] == 'output':
      adaptedActionList.append(['output',action[1]])
    ## If action is a receive, make a new branch for possible alternative.
    if action[0] == 'input':
      newBranch = adaptForAlternativeTestCase(TTCNActionList[i+1:])
      adaptedActionList.append(['input',[[action[1],newBranch]]])
      break
    ## If timer, add to the list of actions.
    if action[0] == 'timer':
      adaptedActionList.append(['timer',action[1]])
  return adaptedActionList 
 

def buildTTCNtestcase(adaptedTTCNtestcase,nestIndex):
  """
  Build a TTCN testcase from a single final state.
  
  @param adaptedTTCNtestcase: list of actions.
  @type adaptedTTCNtestcase: 
  
  @return: TTCNtestcase
  @rtype: list of string
  """
  TTCNtestcase = []
  for statement in adaptedTTCNtestcase:
    ## If input action, make a alternative for each branch. 
    if statement[0] == 'input':
      TTCNtestcase.append('  '*nestIndex+'alt {\n')
      nestIndex += 1
      for altBranch in statement[1]:
        portName = altBranch[0][0]
        signalName = altBranch[0][1]
        templateNumber = altBranch[0][2]
      
        altPrefix = '[]'
        receiveCommand = "%s.receive(%s_%s)" %(portName,signalName,templateNumber)
        TTCNtestcase.append('  '*nestIndex+'%s%s' %(altPrefix,receiveCommand))
        TTCNtestcase.append(' {\n')
        nestIndex += 1
             
      
        TTCNtestcaseBranch = buildTTCNtestcase(altBranch[1],nestIndex)
        for element in TTCNtestcaseBranch:
            TTCNtestcase.append(element)
        TTCNtestcase.append('  '*nestIndex+'}\n')
        nestIndex -= 1
      ## If receive, here is the description of the last branch (only receive with setverdict to fail)
      TTCNtestcase.append('  '*nestIndex+'[]%s.receive {\n' %portName)
      nestIndex += 1
      TTCNtestcase.append('  '*nestIndex+'setverdict(fail);\n')
      TTCNtestcase.append('  '*nestIndex+'stop;\n')
      TTCNtestcase.append('  '*nestIndex+'}\n')
      nestIndex -= 1
      TTCNtestcase.append('  '*nestIndex+'}\n')
    
    
    if statement[0] =='output':
      portName = statement[1][0]
      signalName = statement[1][1]
      templateNumber = statement[1][2]
      TTCNtestcase.append('  '*nestIndex+"%s.send(%s_%s)\n" %(portName,signalName,templateNumber))
  return TTCNtestcase


def testcaseMatch(TTCNTestcase_1,TTCNTestcase_2,areIdenticalTestcase,isAltFeasable):
  """
  Match two testcase to see if alternative is possible.
  
  @param TTCNTestcase_x: TTCN scenario.
  @type TTCNTestcase_x: list of list.
  
  @return: [areIdenticalTestcase,isAltFeasable,newList].
  @rtype : [booleand, boolean, list].
  
  TTCNTestcase_1 is the testcase already in testcases list.
  TTCNTestcase_2 is the new testcase.
  
  ** If two actions at same level are different, alt is not feasable and return [False,False,[]].
  ** If the two actions are a send:
        -> if the sends are the same, the two testcases are identical for the moment and continue matching.
        -> if the sends are not the same, alt is not feasable and return [False,False,[]].
  ** If the two actions are a receive:
        -> if the receives are the same, the two testcases are identical for the moment and continue matching but in the alt branch of the two testcases, and return the result of the match.
        -> if the receives are not same, we add a new branch in the first testcase and return [False,True,newTestcase] 
  ** If all actions of one of the two testcases have been seen, it is than the two testcases are identical or that one is a short version of the other. In that case, return [True, False, longestTestcase]    
  
  """
  for i,statement in enumerate(TTCNTestcase_1):
    ## If action is not of the same type, alternative is not possible with this scenario.
    if not TTCNTestcase_2[i]:
      break
    if statement[0] != TTCNTestcase_2[i][0]:
      return [False,False,[]]
    ## If action of both scenario is a send, the message to send must be the same.
    if statement[0] == 'output' and TTCNTestcase_2[i][0] == 'output':
      ## If the send is the same, continue matching
      if (statement[1][0] == TTCNTestcase_2[i][1][0]) and (statement[1][1] == TTCNTestcase_2[i][1][1]) and (statement[1][2] == TTCNTestcase_2[i][1][2]):
        areIdenticalTestcase = True
        isAltFeasable = True
      ## Else, new scenario can not be mixed with the current scenario.
      else:
        areIdenticalTestcase = False
        isAltFeasable = False
        return [False,False,[]]
    ## If both actions are received.
    if statement[0] == 'input' and TTCNTestcase_2[i][0] == 'input':
      ## If receives are done with the same message, alternative is not necessary and continue matching.
      for altBranch in statement[1]:
        if (altBranch[0][0] == TTCNTestcase_2[i][1][0][0][0]) and (altBranch[0][1] == TTCNTestcase_2[i][1][0][0][1]) and (altBranch[0][2] == TTCNTestcase_2[i][1][0][0][2]):
          areIdenticalTestcase = True
          isAltFeasable = True
          ## Call testcaseMatch with the alt branch of the two testcases.
          areIdenticalTestcase,isAltFeasable,newTTCNTestcase = testcaseMatch(altBranch[1],TTCNTestcase_2[i][1][0][1],areIdenticalTestcase,isAltFeasable)
          return [areIdenticalTestcase,isAltFeasable,newTTCNTestcase]
        ## Else, do a alternative.
        else:
          ##build alt to do
          areIdenticalTestcase = False
          isAltFeasable = True
          currentAltTestcase = copy.deepcopy(TTCNTestcase_1)
          currentAltTestcase[i][1].append(TTCNTestcase_2[i][1][0])
      ## If here, testcases are identical
      return [areIdenticalTestcase,isAltFeasable,currentAltTestcase]
  ## if both testcases are style identical at this level, then the two are identical ore one is a short version of the other. In that case, juste keep one testcase (the longest if any).
  return [areIdenticalTestcase,isAltFeasable,[]]
  
  
  
  
def buildAlternativeTTCNTestcase(finalState,TTCNTestcasesList,adaptedTTCNtestcase):
  """
  Try to build alternative testcases with several testcases if possible.
  
  @param TTCNTestcasesList: list of adapted scenarios.
  @type TTCNTestcasesList: list of list.
  
  @return: altTTCNTestCasesList
  @type TTCNTestcasesList: list of list.
  """
  ## If this is the first scenario, just add it to the list.
  if len(TTCNTestcasesList) == 0:
    TTCNTestcasesList.append([[finalState],adaptedTTCNtestcase])
    return TTCNTestcasesList
  
  ## Else, try to see if the new scenario can be add to an existing one with alternative.
  else:
    ## identicalTestcase is at True while the both scenarios compared are identical.
    areIdenticalTestcase = False
    ## altFeasable notices if the alternative is possible between two scenarios.
    isAltFeasable = False
    for TTCNTestcase in TTCNTestcasesList:
      finalStateList = TTCNTestcase[0]
      areIdenticalTestcase, isAltFeasable, newTestcase = testcaseMatch(TTCNTestcase[1],adaptedTTCNtestcase,areIdenticalTestcase,isAltFeasable)
      ## If new scenario is identical to an existing one, just keep one in the list (the longest).
      if areIdenticalTestcase == True:
        ## In this case, newTestcase is the longest scenario.
        TTCNTestcasesList.remove([finalStateList,TTCNTestcase[1]])
        finalStateList.append(finalState)
        TTCNTestcasesList.append([finalStateList,TTCNTestcase[1]])
        return TTCNTestcasesList
      ## If new scenario can be add to an existing one, just store the old scenario, with an new alternative branch.
      elif isAltFeasable == True:
        ## In this case, newTestcase is the old scenario with the altbranch.
        TTCNTestcasesList.remove([finalStateList,TTCNTestcase[1]])
        finalStateList.append(finalState)
        TTCNTestcasesList.append([finalStateList,newTestcase])
        return TTCNTestcasesList
    ## If the new scenario can not be add to an existing one, just add it to the TTCN-3 testcases list.
    if areIdenticalTestcase == False and isAltFeasable == False:
      TTCNTestcasesList.append([[finalState],adaptedTTCNtestcase])
      return TTCNTestcasesList
      
      

def buildTTCNTestcases(systemName,TTCNTestcasesList):
  """
  Build TTCN testcases from the list of scenario in parameter.
  
  @param TTCNTestcasesList: list of adapted scenarios.
  @type TTCNTestcasesList: list of list.
  
  @return: TTCNtestcase
  @rtype: list of string
  """
  nestIndex = 1
  TTCNtestcases = []
  
  ## For all action suits present in TTCNTestcasesList, build a testcase (with or without alternatives)
  for finalStateList,adaptedTTCNtestcase in TTCNTestcasesList:
    TTCNtestcase = []
    TTCNtransitions = buildTTCNtestcase(adaptedTTCNtestcase,1)
    TTCNtestcase.append('  '*nestIndex+'// For final state(s) ' + ', '.join(finalStateList) + '\n')
    TTCNtestcase.append('  '*nestIndex+'testcase tc_registerUser_%s() runs on %s {\n    timer t;\n' %('_'.join(finalStateList),systemName))
    for TTCNtransition in TTCNtransitions:
      TTCNtestcase.append(TTCNtransition)
    
    TTCNtestcase.append('  '*nestIndex+'setverdict(pass);\n')
    nestIndex = 1
    TTCNtestcase.append('  '*nestIndex+'}\n\n')
    TTCNtestcases.append(TTCNtestcase)
  return TTCNtestcases
  
  
 
## FUNCTION generateTTCN:
## -----------------------

def generateTTCN(autFileName, stateFileName, finalStates, IFFileName,port_number,TTCNFileName):
  """
  Generates the TTCN for the given final states as described in the given transition and state files and send
  it to RTDS through the given socket port.
  
  @param autFileName: Name for the transition file.
  @type autFileName: string
  
  @param stateFileName: Name for the state file.
  @type stateFileName: string
  
  @param finalStates: Final states for the trace to generate.
  @type finalStates: list of strings

  @param IFFileName: Name for the IF file.
  @type IFFileName: string
  
  @param portNumber: Port number for the communication socket with RTDS.
  @type portNumber: int
  
  @param TTCNFileName: Name for the TTCN file.
  @type TTCNFileName: string  
  """
  ## Create TTCN file.
  curDir = os.getcwd()
  try:
    TTCNFileName=os.path.join(curDir, TTCNFileName)
    traceFile = open(TTCNFileName, 'w')
    traceFile.write('module %s {\n\n' %TTCNFileName[TTCNFileName.rfind('/')+1:TTCNFileName.rfind('.ttcn')])
  except (OSError, IOError), exc:
    showerror("TTCN Error", "TTCN file can not be created." )
    return
  IFFile = open(IFFileName)
  line=IFFile.readline()
  while line[:6] != 'system':
    line=IFFile.readline()
  systemName = line[7:line.find(';')]
  IFFile.close()
  ## Save all signals in TTCN_signal_dico 
  getRecordforTTCN(traceFile,IFFileName,systemName)
  ## Make a dictionary with all transitions
  transitions = getAllTransitionsforTTCN(autFileName,traceFile)
  templatesList.sort()
  
  ## Store templates in a list.
  requiredTemplates = []
  TTCNTestcasesList = []
  
  nestIndex = 1
  
  ## For every final state selected, get adapted list of action.
  for finalState in finalStates:
    adaptedTTCNtestcase,requiredTestcaseTemplates = GenerateTestCaseByShorterWay(finalState,traceFile)
    
    
    ## If adapted testcases present in testcase list, check if possible to build alternatives.
    
    TTCNTestcasesList = buildAlternativeTTCNTestcase(finalState,TTCNTestcasesList,adaptedTTCNtestcase)
    
    ## Store all templates needed by the testcase in requiredTemplates.
    for template in requiredTestcaseTemplates:
      requiredTemplates.append(template)
  ## Call function to build TTCN testcases (with alternatives if possible).
  TTCNtestcases = buildTTCNTestcases(systemName,TTCNTestcasesList)
  
  ## Print all templates needed by the testcase(s)
  traceFile.write('  '*nestIndex+'// Templates declaration\n')
  for template in templatesList:
    if (template[0]+'_'+template[1]) in requiredTemplates:
      traceFile.write('  '*nestIndex+'template '+template[0]+' '+template[0]+'_'+template[1]+' := {')
      if template[2]:
        traceFile.write('\n')
        traceFile.write(',\n'.join([('    %s' %(param.replace('=',':='))) for param in template[2]]))
        traceFile.write('\n')
      nestIndex += 1
      traceFile.write('  '*nestIndex+'};\n\n')
      nestIndex -= 1

  ## Print all test cases
  traceFile.write('  '*nestIndex+'// Testcase declaration\n')
  for TTCNtestcase in TTCNtestcases:
    for action in TTCNtestcase:
      traceFile.write(action)
      
  traceFile.write('  '*nestIndex+'control {\n')
  nestIndex += 1
  for finalStateList,_ in TTCNTestcasesList:
    traceFile.write('  '*nestIndex+'execute(tc_registerUser_%s()); \n' %'_'.join(finalStateList))
  nestIndex -= 1
  traceFile.write('  '*nestIndex+'}\n\n}\n')
  traceFile.close()
  s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
  try:
    s.connect(('127.0.0.1', port_number))
  except:
    showerror("Probleme de connexion sur le port donne")
  else:
    s.send('addsrcfile %s\n' % TTCNFileName)
    s.close()
  
## CLASS ManualMainWindow:
## -----------------------

class ManualMainWindow(Tk):
  """
  Class for the main window in manual mode.
  """
  
  ## METHOD __init__:
  ## ----------------
  
  def __init__(self):
    """
    Builds the window.
    """
    ## Super-init
    Tk.__init__(self)
    
    ## INSTANCE ATTRIBUTES:
    ## --------------------
    
    self.__autFileNameVar = StringVar()
    self.__stateFileNameVar = StringVar()
    self.__finalStateVar = StringVar()
    self.__portNumberVar = StringVar()
    self.__IFFileNameVar = StringVar()
    
    ## mapping storing all newtypes with their definition and message with their parameters types.
    self.__signalsMapping = {}
    self.__globalNewTypes = {}
    
    self.__newTypes, self.__signalsMapping = self.__getDeclarations()
    
    ## Build window
    self.title("If2Msc: Mode manuel")
    Label(self, text="Fichier .aut :").grid(row=1, sticky=W, padx=4, pady=4)
    Entry(self, textvariable=self.__autFileNameVar).grid(row=1, column=2, padx=5, pady=4)
    Button(self, text="Parcourir", command=self._browseAutFile).grid(row=1, column=3, padx=5, pady=4)
    Label(self, text="Fichier .state :").grid(row=2, sticky=W, padx=4, pady=4)
    Entry(self, textvariable=self.__stateFileNameVar).grid(row=2, column=2, padx=5, pady=4)
    Button(self, text="Parcourir", command=self._browseStateFile).grid(row=2, column=3, padx=5, pady=4)
    Label(self, text="Fichier .if :").grid(row=3, sticky=W, padx=4, pady=4)
    Entry(self, textvariable=self.__IFFileNameVar).grid(row=3, column=2, padx=5, pady=4)
    Button(self, text="Parcourir", command=self._browseIFFile).grid(row=3, column=3, padx=5, pady=4)
    Label(self, text="Etat final voulu :").grid(row=5, sticky=W, padx=4, pady=4)
    Entry(self, textvariable=self.__finalStateVar).grid(row=5, column=2, padx=5, pady=4)
    Label(self, text="Numero de port :").grid(row=6, sticky=W, padx=4, pady=4)
    Entry(self, textvariable=self.__portNumberVar).grid(row=6, column=2, padx=5, pady=4)
    Button(self, text="Generer MSC", command=self._generateTrace).grid(row=8, column=0, padx=5, pady=4)
    #Button(self, text="Generer TTCN", command=self._generateTTCN).grid(row=8, column=2, padx=5, pady=4)
    Button(self, text="Quitter", command=self.quit).grid(row=8, column=3, padx=5, pady=7)
  
  ## METHOD __getDeclarations(self):
  ## -------------------------------
  
  def __getDeclarations(self):
    """ 
    Used to get newtypes and parameters of messsages in IF file.
    """
    
    newtypes, signalsMapping = {},{}
    
    try:
      IFFile = open(self.__IFFileName)
      line=IFFile.readline()
      ## newtype declaration
      while not line.startswith('signal'):
        if line.startswith('type'):
          newTypeName = line.split()[1]
          newTypeType = line.split()[3]
          if newTypeType in ['RTDS_character','RTDS_charstring']:
            continue
          elif newTypeType.startswith('range'):
            newtypes[newTypeName] = ['range','integer']
          ##if newtype is a struct, build a record to replace it
          elif (newTypeType.startswith('record')):
            recordParam = []
            line = IFFile.readline()
            while not line.startswith('endrecord'):
              paramName = line.split()[0]
              paramType = line.split()[1]
              recordParam.append([paramName,paramType])
              line = IFFile.readline()
            newtypes[newTypeName] = ['record',recordParam]
          ##if newtype is an array,replace by an array in TTCN
          if (newTypeType.startswith('array[')):
            elementType = line.split()[5][:-1]
            size = newTypeType[newTypeType.find('[')+1:newTypeType.rfind(']')]
            newtypes[newTypeName] = ['array',[elementType,size ]]
        line = IFFile.readline()
      ## Store signal name and parameters
      while not line.startswith('signalroute'):
        if line.startswith('signal'):
          signalInfo = line[7:]
          ## Get signal Name
          signalName = signalInfo[:signalInfo.find('(')]
          ## Because first parameter is only for internal used (sender pid) do not store it.
          parameter = signalInfo[signalInfo.find('(')+1:signalInfo.rfind(')')]
          signalParameters=parameter.split(', ')[1:]
          signalsMapping[signalName] = signalParameters
        line = IFFile.readline()
      
      while not line.startswith('endsystem;'):
        if line.startswith('signalroute'):
          signalroute_name = line[12:line.find('(')]
          line = IFFile.readline()
          sender = line.split()[1]
          line = IFFile.readline()
          receiver = line.split()[1]
          signalRoute2Processes[signalroute_name] = (sender, receiver)
          
          
          line = IFFile.readline()
        line = IFFile.readline()
      IFFile.close()
      return newtypes, signalsMapping
    except (OSError, IOError), exc:
      showerror("Error", "Cannot read IF file:\n%s" % exc)
      self.quit()
  
  
  ## METHOD _browseAutFile:
  ## ----------------------
  
  def _browseAutFile(self):
    """
    Clicked when the "Browse" button for the .aut file is clicked.
    """
    newAutFile = tkFileDialog.askopenfilename(parent=self,title='Fichier .aut')
    if newAutFile:
      self.__autFileNameVar.set(newAutFile)
      
  ## METHOD _browseIFFile:
  ## ----------------------
  
  def _browseIFFile(self):
    """
    Clicked when the "Browse" button for the .aut file is clicked.
    """
    newIFFile = tkFileDialog.askopenfilename(parent=self,title='Fichier .if')
    if newIFFile:
      self.__IFFileNameVar.set(newIFFile)
  
  ## METHOD _generateTTCN:
  ## ----------------------
  
  def _generateTTCN(self):
    """
    Generates the TTCN file from the information contained in the window.
    """
    try:
      portNumber = int(self.__portNumberVar.get().strip())
    except (ValueError, TypeError):
      showerror("Numero de port errone", "%r n'est pas un numero de port valide" % self.__portNumberVar.get())
      return
    ttcn_file_name = tkFileDialog.asksaveasfilename(title='TTCN file', filetypes=[('TTCN files', '*.ttcn *.ttcn3'), ('All files', '*')], defaultextension='.ttcn')
    if ttcn_file_name:
      generateTTCN(self.__autFileNameVar.get(), self.__stateFileNameVar.get(), self.__IFFileNameVar.get(), self.__finalStateVar.get(), self.__IFFileNameVar.get(), portNumber, ttcn_file_name)
    
  
  ## METHOD _browseStateFile:
  ## ------------------------
  
  def _browseStateFile(self):
    """
    Clicked when the "Browse" button for the .state file is clicked.
    """
    newStateFile = tkFileDialog.askopenfilename(parent=self,title='Fichier .state')
    if newStateFile:
      self.__stateFileNameVar.set(newStateFile)
  
  
  ## METHOD _generateTrace:
  ## ----------------------
  
  def _generateTrace(self):
    """
    Generates the trace from the information contained in the window.
    """
    try:
      portNumber = int(self.__portNumberVar.get().strip())
    except (ValueError, TypeError):
      showerror("Numero de port errone", "%r n'est pas un numero de port valide" % self.__portNumberVar.get())
      return
    generateTrace(self.__autFileNameVar.get(), self.__stateFileNameVar.get(), self.__finalStateVar.get(), portNumber, self.__newTypes, self.__signalsMapping)
    


## CLASS AutomaticMainWindow:
## --------------------------

class AutomaticMainWindow(Tk):
  """
  Class for the main window in automatic mode.
  """
  
  ## METHOD __init__:
  ## ----------------
  
  def __init__(self, errorFileName, autFileName, stateFileName, IFFileName, portNumber):
    """
    Builds the window.
    
    @param errorFileName: Name of the file containing the error states. It is the output of the executable generated by if2gen.
    @type errorFileName: string
    
    @param autFileName: Name of the transition file generated by the executable, usually with a C{.aut} extension.
    @type autFileName: string
    
    @param stateFileName: Name of the state file generated by the executable, usually with a C{.state} extension.
    @type stateFileName: string
    
    @param portNumber: Port number to communicate with RTDS.
    @type portNumber: int
    """
    ## Super-init
    Tk.__init__(self)
    
    ## INSTANCE ATTRIBUTES:
    ## --------------------
    
    self.__errorFileName = errorFileName
    self.__autFileName = autFileName
    self.__stateFileName = stateFileName
    self.__IFFileName = IFFileName
    self.__portNumber = portNumber
    self.__listBox = None
    
    ## mapping storing all newtypes with their definition and message with their parameters types.
    self.__signalsMapping = {}
    self.__newTypes = {}
    
    self.__newTypes, self.__signalsMapping = self.__getDeclarations()
    
    ## Get error states from error file
    errorStates = []
    errorInfos = []
    errorInfosforlistBox = []
    
    try:
      stateMapping, pidMapping = _getStateMappings(stateFileName)
    except (OSError, IOError), exc:
      showerror('Erreur states', 'Probleme lors de la lecture du fichier .state:\n%s' % exc)
      return
    try:
      errorFile = open(errorFileName)
      for line in errorFile:
        try:
          stateStart = line.index('[')
          stateEnd = line.index(']', stateStart)
          errorStates.append(line[stateStart + 1:stateEnd])
        except ValueError:
          pass
      errorFile.close()
    except (OSError, IOError), exc:
      showerror("Liste d'erreur illisible", "Fichier de liste d'erreurs illisible:\n%s" % exc)
      self.quit()
    ## Build window
    errorInfos = _getFinalTransitions(autFileName,errorStates)
    for Info in errorInfos:
      state = int(Info[Info.find(':')+1:])
      obs_name = Info[:Info.find(':')]
      for element in stateMapping[state].keys():
        if element[0] == obs_name:
          obs_State = stateMapping[state][element]
          errorInfosforlistBox.append(obs_name + '(' + obs_State + '): '+ str(state))
    self.title("If2Msc: Choice of the scenario")
    main_frame = Frame(self)
    main_frame.pack(fill=BOTH, expand=True)
    main_frame.grid_rowconfigure(1, weight=1)
    main_frame.grid_columnconfigure(0, weight=1)
    Label(main_frame, text="Choose the final state:").grid(row=0, column=0, sticky='w', columnspan=2, padx=2, pady=2)
    scrollBar = Scrollbar(main_frame, orient=VERTICAL)
    self.__listBox = Listbox(main_frame, yscrollcommand=scrollBar.set, selectmode='extended')
    scrollBar.config(command=self.__listBox.yview)
    self.__listBox.grid(row=1, column=0, sticky='nswe')
    scrollBar.grid(row=1, column=1, sticky='ns')
    for info in errorInfosforlistBox:
      self.__listBox.insert(END, info)
    button_frame = Frame(main_frame)
    button_frame.grid(row=3, column=0, columnspan=2, sticky='we')
    Button(button_frame, text="Generate MSC", command=self._generateTrace).pack(side=LEFT, padx=2, pady=2)
    Button(button_frame, text="Generate TTCN", command=self._generateTTCN).pack(side=LEFT, padx=2, pady=2)
    Label(button_frame, text=' ').pack(side=LEFT, padx=2, pady=2)
    Button(button_frame, text="Quit", command=self.quit).pack(side=RIGHT, padx=2, pady=2)
  
  ## METHOD __getDeclarations(self):
  ## -------------------------------
  
  def __getDeclarations(self):
    """ 
    Used to get newtypes and parameters of messsages in IF file.
    """
    
    newtypes, signalsMapping = {},{}
    
    try:
      IFFile = open(self.__IFFileName)
      line=IFFile.readline()
      ## newtype declaration
      while not line.startswith('signal'):
        if line.startswith('type'):
          newTypeName = line.split()[1]
          newTypeType = line.split()[3]
          if newTypeType in ['RTDS_character','RTDS_charstring']:
            continue
          elif newTypeType.startswith('range'):
            newtypes[newTypeName] = ['range','integer']
          ##if newtype is a struct, build a record to replace it
          elif (newTypeType.startswith('record')):
            recordParam = []
            line = IFFile.readline()
            while not line.startswith('endrecord'):
              paramName = line.split()[0]
              paramType = line.split()[1][:-1]
              recordParam.append([paramName,paramType])
              line = IFFile.readline()
            newtypes[newTypeName] = ['record',recordParam]
          ##if newtype is an array,replace by an array in TTCN
          if (newTypeType.startswith('array[')):
            elementType = line.split()[5][:-1]
            size = newTypeType[newTypeType.find('[')+1:newTypeType.rfind(']')]
            newtypes[newTypeName] = ['array',[elementType,size ]]
        line = IFFile.readline()
      ## Store signal name and parameters
      while not line.startswith('signalroute'):
        if line.startswith('signal'):
          signalInfo = line[7:]
          ## Get signal Name
          signalName = signalInfo[:signalInfo.find('(')]
          ## Because first parameter is only for internal used (sender pid) do not store it.
          parameter = signalInfo[signalInfo.find('(')+1:signalInfo.rfind(')')]
          signalParameters=parameter.split(', ')[1:]
          signalsMapping[signalName] = signalParameters
        line = IFFile.readline()
      while not line.startswith('endsystem;'):
        if line.startswith('signalroute'):
          signalroute_name = line[12:line.find('(')]
          line = IFFile.readline()
          sender = line.split()[1]
          line = IFFile.readline()
          receiver = line.split()[1]
          signalRoute2Processes[signalroute_name] = (sender, receiver)
          
          
          line = IFFile.readline()
        line = IFFile.readline()
      
      
      IFFile.close()
      return newtypes, signalsMapping
    except (OSError, IOError), exc:
      showerror("Error", "Cannot read IF file:\n%s" % exc)
      self.quit()
    
  
  ## METHOD _generateTrace:
  ## ----------------------
  
  def _generateTrace(self):
    """
    Called when the generation_MSC button is clicked.
    """
    states = [self.__listBox.get(i) for i in self.__listBox.curselection()]
    ##if len(states) != 1:
    ##  showerror("Wrong selection", "Please select exactly one error state from the list")
    ##  return
    for state in states:
      generateTrace(self.__autFileName, self.__stateFileName, self.__IFFileName, state[state.rfind(':')+1:], self.__portNumber, self.__newTypes, self.__signalsMapping)
    
    
  ## METHOD _generateTTCN:
  ## ---------------------
  
  def _generateTTCN(self):
    """
    Called when the generation_TTCN button is clicked.
    """
    states = [self.__listBox.get(i) for i in self.__listBox.curselection()]
    if not states:
      showerror("Wrong selection", "Please select one or several error states from the list")
      return
    ttcn_file_name = tkFileDialog.asksaveasfilename(title='TTCN file', filetypes=[('TTCN files', '*.ttcn *.ttcn3'), ('All files', '*')], defaultextension='.ttcn')
    finalStates = []
    for state in states:
      finalStates.append(state.split()[1])
    if ttcn_file_name:
      
        generateTTCN(self.__autFileName, self.__stateFileName, finalStates, self.__IFFileName, self.__portNumber, ttcn_file_name)

## FUNCTION main:
## --------------

def main():
  """
  Main function, called when the script is called.
  """
  ## Decode options
  if len(sys.argv) < 2:
    usage()
  ## Manual mode
  if sys.argv[1] == '-MA':
    if len(sys.argv) != 2:
      usage()
    root = ManualMainWindow()
  ## Automatic mode
  elif sys.argv[1] == '-AU':
    if len(sys.argv) != 7:
      usage()
    errorFileName, autFileName, stateFileName, IFFileName, portNumberString = sys.argv[2:]
    try:
      portNumber = int(portNumberString)
    except (TypeError, ValueError):
      usage()
    root = AutomaticMainWindow(errorFileName, autFileName, stateFileName, IFFileName, portNumber)
  else:
    usage()
  ## Run main window
  root.mainloop()


if __name__ == '__main__':
  main()
