/* Include unistd when using a unix based system or cygwin */
#ifdef __CYGWIN__
#include <unistd.h>
#else
#include <stdlib.h>
#include <string.h>
#endif

#include "RTDS_MACRO.h"

#if defined(RTDS_FORMAT_TRACE)
#include "RTDS_FormatTrace.h"
#endif

#include "RTDS_Env.h"
#include "RTDS_messages.h"
#include "RTDS_gen.h"

#define RTDS_PROCESS_NUMBER RTDS_process_RTDS_Env
#define RTDS_PROCESS_NAME RTDS_Env

#include "RTDS_ADDL_MACRO.h"

#include "RTDS_Env_decl.h"

#include "RTDS_InternalConstants.h"

#undef SENDER
#define SENDER RTDS_instanceDescriptor->RTDS_senderId

/*
** INSTANCE CREATION/INITIALIZATION:
** ---------------------------------
*/

static short RTDS_RTDS_Env_continuousSignals(RTDS_Proc * RTDS_instanceDescriptor, int * lowestPriority);
static short RTDS_RTDS_Env_executeTransition(RTDS_Proc * RTDS_instanceDescriptor, RTDS_MessageHeader * currentMessage);

void RTDS_Proc_RTDS_Env_createInstance(
RTDS_Proc * RTDS_instanceDescriptor,
RTDS_Scheduler * parentScheduler,
RTDS_GlobalProcessInfo * instanceContext,
RTDS_GlobalProcessInfo * parentContext
)
  {
  RTDS_instanceDescriptor->RTDS_isProcedure = 0;
  RTDS_instanceDescriptor->RTDS_continuousSignals = (RTDS_continuousSignals_type)&RTDS_RTDS_Env_continuousSignals;
  RTDS_instanceDescriptor->RTDS_executeTransition = (RTDS_executeTransition_type)&RTDS_RTDS_Env_executeTransition;
  RTDS_Proc_createInstance(RTDS_instanceDescriptor, parentScheduler, instanceContext, parentContext);
  RTDS_instanceDescriptor->RTDS_currentContext->sdlProcessNumber = RTDS_PROCESS_NUMBER;
  (RTDS_instanceDescriptor->myLocals.RTDS_Env.RTDS_myLocals) = NULL;
  (RTDS_instanceDescriptor->myLocals.RTDS_Env.RTDS_localsStack)[0] = (RTDS_instanceDescriptor->myLocals.RTDS_Env.RTDS_myLocals);

  }


/*
** INITIAL TRANSITION:
** -------------------
*/

static short RTDS_RTDS_Env_start_transition(RTDS_Proc * RTDS_instanceDescriptor)
  {
  RTDS_Proc_setSdlState(RTDS_instanceDescriptor, RTDS_state_RTDS_Idle);
  return 0;
  }


/*
** FUNCTION RTDS_RTDS_Env_continuousSignals:
** -----------------------------------------
** Executes a transition for a continuous signal in process or procedure
*/

static short RTDS_RTDS_Env_continuousSignals(RTDS_Proc * RTDS_instanceDescriptor, int * lowestPriority)
  {
  return 0;
  }

/*
** FUNCTION RTDS_RTDS_Env_executeTransition:
** -----------------------------------------
** Entry point for all transitions in process or procedure
*/

static short RTDS_RTDS_Env_executeTransition(RTDS_Proc * RTDS_instanceDescriptor, RTDS_MessageHeader * currentMessage)
  {
  RTDS_GlobalProcessInfo * RTDS_currentContext = RTDS_instanceDescriptor->RTDS_currentContext;
  /* If process has called a procedure */
  if ( RTDS_instanceDescriptor->RTDS_calledProcedure != NULL )
    {
    /* Forward call to procedure; if it doesn't return, over */
    if ( ! RTDS_instanceDescriptor->RTDS_calledProcedure->RTDS_executeTransition(RTDS_instanceDescriptor->RTDS_calledProcedure, currentMessage) ) return 0;
    /* If procedure has returned, restore state & message for calling transition */
    RTDS_currentContext->sdlState = RTDS_instanceDescriptor->RTDS_sdlStatePrev;
    RTDS_instanceDescriptor->RTDS_forceReadSaveQueue = 1;
    currentMessage = RTDS_instanceDescriptor->RTDS_initialMessage;
    RTDS_instanceDescriptor->RTDS_initialMessage = NULL;
    }
  /* Remember previous state */
  RTDS_instanceDescriptor->RTDS_sdlStatePrev = RTDS_currentContext->sdlState;
  /* Remember message as current one */
  RTDS_currentContext->currentMessage = currentMessage;
  if ( RTDS_instanceDescriptor->RTDS_initialMessage != NULL )
    {
    if ( RTDS_instanceDescriptor->RTDS_initialMessage->pData != NULL ) { RTDS_FREE(RTDS_instanceDescriptor->RTDS_initialMessage->pData); }
    RTDS_FREE(RTDS_instanceDescriptor->RTDS_initialMessage);
    }
  RTDS_instanceDescriptor->RTDS_initialMessage = currentMessage;
  /* No message means start transition */
  if ( currentMessage == NULL )
    {
    return RTDS_RTDS_Env_start_transition(RTDS_instanceDescriptor);
    }
  return 0;
  }


/*
** PROCESS RTDS_Env TASK ENTRY POINT:
** ----------------------------------
*/

RTDS_TASK_ENTRY_POINT(RTDS_Env)
  {
  RTDS_SETUP_CURRENT_CONTEXT
  RTDS_Scheduler localScheduler;
  RTDS_Proc runningInstance;
  RTDS_Scheduler_init(&localScheduler, &(RTDS_currentContext->mySdlInstanceId->queueId));
  RTDS_Proc_RTDS_Env_createInstance(&runningInstance, &localScheduler, RTDS_currentContext, NULL);
  RTDS_Proc_msgQueueSendToId(&runningInstance, -1, 0, NULL, runningInstance.RTDS_currentContext->mySdlInstanceId);
  RTDS_START_SYNCHRO_WAIT
  RTDS_Scheduler_run(&localScheduler);
  }

