/* PragmaDev RTDS OSE Delta integration */
#ifndef _RTDS_MACRO_H_
#define _RTDS_MACRO_H_

#ifdef __cplusplus
extern "C" {
#endif

/* OSE includes */
#include "ose.h"

/* RTDS include */
#include "RTDS_OS.h"
#include "RTDS_Error.h"
#ifdef RTDS_BACK_TRACE_MAX_EVENT_NUM
#include "RTDS_BackTrace.h"
#endif


/* ************************************************************************************ *
 *									TASK ENTRY POINT DEFINITION AND PROTOTYPE
 * ************************************************************************************ */
#define RTDS_TASK_ENTRY_POINT(TASK_NAME) OS_PROCESS(TASK_NAME)
#define RTDS_TASK_ENTRY_POINT_PROTO(TASK_NAME) extern OSENTRYPOINT TASK_NAME



/* ************************************************************************************ *
 *									SDL KEYWORD DEFINITION
 *		Defines the SDL PARENT keyword. parentQueueId is given when taskSpawn is done.
 * ************************************************************************************ */
#define PARENT		RTDS_currentContext->parentQueueId
#define SELF			RTDS_currentContext->myQueueId
#define OFFSPRING RTDS_currentContext->offspringQueueId
#define SENDER		RTDS_senderQueueId



/* ************************************************************************************ *
 *									TRACE MACRO
 * ************************************************************************************ */
/*	dbgprintf("Event: %d, param1: %x, param2: %x\n",EVENT, PARAM1, PARAM2); \ */
#if defined(RTDS_SIMULATOR) || defined(RTDS_BACK_TRACE_MAX_EVENT_NUM) || defined(RTDS_MSC_TRACE) || defined(RTDS_FORMAT_TRACE)
	#ifdef RTDS_BACK_TRACE_MAX_EVENT_NUM
		#define RTDS_SIMULATOR_TRACE(EVENT, PARAM1, PARAM2, PARAM3) \
			RTDS_globalSystemTime = get_ticks() ; \
			RTDS_SimulatorTrace(EVENT, (void *) PARAM1, (long) PARAM2, (RTDS_GlobalProcessInfo *) PARAM3, RTDS_DTRACE_ACK_WAIT); \
			RTDS_TraceAdd();
	#else
		#define RTDS_SIMULATOR_TRACE(EVENT, PARAM1, PARAM2, PARAM3) \
			RTDS_globalSystemTime = get_ticks() ; \
			RTDS_SimulatorTrace(EVENT, (void *) PARAM1, (long) PARAM2, (RTDS_GlobalProcessInfo *) PARAM3, RTDS_DTRACE_ACK_WAIT);
	#endif
#else
	#define RTDS_SIMULATOR_TRACE(EVENT, PARAM1, PARAM2, PARAM3)
#endif

/*
 * MACRO RTDS_SYSTEM_ERROR:
 * ------------------------
 * Macro called when a system error is detected in RTDS 'kernel'
 * Needs to be defined by user.
 */
#ifndef RTDS_SYSTEM_ERROR
    #define RTDS_SYSTEM_ERROR(errorNumber) \
    	{ \
    	RTDS_SIMULATOR_TRACE(RTDS_systemError, errorNumber, NULL, NULL); \
    	dbgprintf("RTDS error 0x%X\nCheck RTDS_Error.h file for explanations.\n",errorNumber); \
    	error2(errorNumber, (OSERRCODE)"Check error code in $(RTDS_HOME)/share/ccg/ose/RTDS_Error.h"); \
    	}
#endif

/* ************************************************************************************ *
 *									MEMORY MACROS
 * ************************************************************************************ */
/*
 * MACRO RTDS_MALLOC:
 * ---------------------
 * Memory allocation
 */
#define RTDS_MALLOC(SIZE)  heap_alloc_shared(SIZE,NULL,0)

/*
 * MACRO RTDS_FREE:
 * -------------------
 * Memory liberation
 */
#define RTDS_FREE(PTR)	heap_free_shared(PTR)

/*
 * MACRO RTDS_MEMCPY:
 * ---------------------
 * Memory copy
 */
#define RTDS_MEMCPY(DEST,SRC,SIZE)	memcpy(DEST,SRC,SIZE)


/* ************************************************************************************ *
 *									TIMER MACROS
 * ************************************************************************************ */

/*
 * MACRO RTDS_RESET_TIMER:
 * --------------------------
 * Cancels a timer
 */
#define RTDS_RESET_TIMER(TIMER_NUMBER) \
	RTDS_StopTimer(TIMER_NUMBER, &(RTDS_currentContext->timerList), RTDS_currentContext);

/*
 * MACRO RTDS_SET_TIMER:
 * ------------------------
 * Initializes and starts a timer
 */
#define RTDS_SET_TIMER(TIMER_NUMBER, DELAY) \
	RTDS_RESET_TIMER(TIMER_NUMBER); \
	RTDS_StartTimer(RTDS_currentContext->myQueueId, TIMER_NUMBER, RTDS_GetTimerUniqueId(RTDS_currentContext->timerList),DELAY, &(RTDS_currentContext->timerList), RTDS_currentContext);



/* ************************************************************************************ *
 *									MESSAGE MACROS
 * ************************************************************************************ */
/*
 * MACRO RTDS_MSG_QUEUE_READ:
 * -----------------------------
 * Reads the next message in the process's message queue
 * Memory does not need to be allocated before calling the macro
 */
#define RTDS_MSG_QUEUE_READ(CURRENT_MESSAGE) \
	CURRENT_MESSAGE = (RTDS_MessageHeader *)receive((SIGSELECT *) any_sig);

/*
 * MACRO RTDS_MSG_QUEUE_SEND_TO_ID:
 * ----------------------------------
 * Sends a message to a process's message queue using its queue id.
 */
#define RTDS_MSG_QUEUE_SEND_TO_ID(MESSAGE_NUMBER, LENGTH_DATA, P_DATA, RECEIVER) \
	RTDS_MsgQueueSend(MESSAGE_NUMBER, LENGTH_DATA, (unsigned char *) P_DATA, (RTDS_QueueId) RECEIVER, RTDS_currentContext->myQueueId, RTDS_currentContext);

/*
 * MACRO RTDS_MSG_QUEUE_SEND_TO_ENV:
 * ------------------------------------
 * Sends a message to the environment.
 */
#define RTDS_MSG_QUEUE_SEND_TO_ENV(MESSAGE_NUMBER, LENGTH_DATA, P_DATA) \
	RTDS_MsgQueueSend(MESSAGE_NUMBER, LENGTH_DATA, (unsigned char *) P_DATA, RTDS_GetProcessQueueId(RTDS_process_RTDS_Env), SELF, RTDS_currentContext);

/*
 * MACRO RTDS_MSG_QUEUE_SEND_TO_NAME:
 * ------------------------------------
 * Sends a message to a process's message queue using its name.
 */
#define RTDS_MSG_QUEUE_SEND_TO_NAME(MESSAGE_NUMBER, LENGTH_DATA, P_DATA, RECEIVER_STRING, RECEIVER_NUMBER) \
	RTDS_MsgQueueSend(MESSAGE_NUMBER, LENGTH_DATA, (unsigned char *) P_DATA, RTDS_GetProcessQueueId(RECEIVER_NUMBER), SELF, RTDS_currentContext);

/*
 * MACRO RTDS_MSG_SAVE:
 * -----------------------
 * Saves a message to the save queue chained list
 */
#define RTDS_MSG_SAVE(CURRENT_MESSAGE) \
	RTDS_SIMULATOR_TRACE(RTDS_messageSaved, CURRENT_MESSAGE, SELF, RTDS_currentContext); \
	CURRENT_MESSAGE->next=NULL; \
	if ( RTDS_currentContext->writeSaveQueue == NULL ) \
		RTDS_currentContext->writeSaveQueue = CURRENT_MESSAGE; \
	else \
		{ \
		RTDS_MessageHeader	*RTDS_MSG_SAVE_message; \
		for (RTDS_MSG_SAVE_message=RTDS_currentContext->writeSaveQueue ; RTDS_MSG_SAVE_message->next != NULL ; RTDS_MSG_SAVE_message = RTDS_MSG_SAVE_message->next); \
		RTDS_MSG_SAVE_message->next = CURRENT_MESSAGE; \
		} \
	CURRENT_MESSAGE = NULL;

/*
 * MACRO RTDS_MSG_INPUT_ERROR:
 * --------------------------
 * Macro called in the generated code if the pointer on the received parameters is NULL.
 */
#define RTDS_MSG_INPUT_ERROR \
	RTDS_SYSTEM_ERROR(RTDS_ERROR_MSG_INPUT);



/* ************************************************************************************ *
 *								SEMAPHORE MACROS
 * ************************************************************************************ */
/*
 * MACRO RTDS_BINARY_SEMAPHORE_CREATE:
 * -------------------------------------
 * Creates a binary semaphore
 */
#define RTDS_BINARY_SEMAPHORE_CREATE(SEMAPHORE_NAME, SEMAPHORE_NUMBER, OPTIONS, INITIAL_STATE) \
	RTDS_Sem_Info_Insert( SEMAPHORE_NUMBER, create_sem( INITIAL_STATE ), RTDS_currentContext );

/*
 * MACRO RTDS_MUTEX_SEMAPHORE_CREATE:
 * -------------------------------------
 * Creates a mutex semaphore
 */
#define RTDS_MUTEX_SEMAPHORE_CREATE(SEMAPHORE_NAME, SEMAPHORE_NUMBER, OPTIONS) \
	RTDS_Sem_Info_Insert( SEMAPHORE_NUMBER, create_sem( 1 ), RTDS_currentContext );

/*
 * MACRO RTDS_COUNTING_SEMAPHORE_CREATE:
 * ---------------------------------------
 * Creates a counting semaphore
 * Posix like
 */
#define RTDS_COUNTING_SEMAPHORE_CREATE(SEMAPHORE_NAME, SEMAPHORE_NUMBER, OPTIONS, INITIAL_COUNT) \
	RTDS_Sem_Info_Insert( SEMAPHORE_NUMBER, create_sem( INITIAL_COUNT ), RTDS_currentContext );

/*
 * MACRO RTDS_SEMAPHORE_DELETE:
 * -----------------------------
 * Deleting a semaphore
 */
#define RTDS_SEMAPHORE_DELETE( SEMAPHORE_ID ) \
	RTDS_Sem_Delete( SEMAPHORE_ID, RTDS_currentContext );

#define RTDS_SEMAPHORE_NAME_DELETE( SEMAPHORE_NAME, SEMAPHORE_NUMBER ) \
	RTDS_Sem_Delete( RTDS_GetSemaphoreId(SEMAPHORE_NUMBER), RTDS_currentContext );

/*
 * MACRO RTDS_SEMAPHORE_TAKE:
 * -----------------------------
 * Takes a semaphore
 */
#define RTDS_SEMAPHORE_ID_TAKE( SEMAPHORE_ID, TIME_OUT) \
	RTDS_SemaphoreIdTake( SEMAPHORE_ID, TIME_OUT, RTDS_currentContext ) ;

#define RTDS_SEMAPHORE_NAME_TAKE( SEMAPHORE_NAME, SEMAPHORE_NUMBER, TIME_OUT ) \
	RTDS_SemaphoreIdTake( RTDS_GetSemaphoreId(SEMAPHORE_NUMBER), TIME_OUT, RTDS_currentContext ) ;

/*
 * MACRO RTDS_SEMAPHORE_GIVE:
 * -----------------------------
 * Gives a semaphore
 */
#define RTDS_SEMAPHORE_ID_GIVE(SEMAPHORE_ID) \
	RTDS_SIMULATOR_TRACE(RTDS_semGive, SEMAPHORE_ID, NULL, RTDS_currentContext); \
	signal_sem(SEMAPHORE_ID);

#define RTDS_SEMAPHORE_NAME_GIVE(SEMAPHORE_NAME, SEMAPHORE_NUMBER) \
	RTDS_SIMULATOR_TRACE(RTDS_semGive, RTDS_GetSemaphoreId(SEMAPHORE_NUMBER), NULL, RTDS_currentContext); \
	signal_sem( RTDS_GetSemaphoreId(SEMAPHORE_NUMBER) );



/* ************************************************************************************ *
 *									PROCESS MACROS
 * ************************************************************************************ */
/*
 * MACRO RTDS_PROCESS_CREATE:
 * -----------------------------
 * Creates a new task representing an SDL process
 * Watch out the ';' is removed from the end to support ADS armcc compiler
 */
#define RTDS_PROCESS_CREATE(PROCESS_NAME, PROCESS_NUMBER, FUNCTION_ADDRESS, PRIORITY) \
	RTDS_ProcessCreate(PROCESS_NAME, PROCESS_NUMBER, (void *)FUNCTION_ADDRESS, PRIORITY, &OFFSPRING, SELF, RTDS_NO_HOLD, RTDS_currentContext)

/*
 * MACRO RTDS_STARTUP_PROCESS_CREATE:
 * -----------------------------
 * Used by Startup task to create a new task representing an SDL process
 * Watch out the ';' is removed from the end to support ADS armcc compiler
 */
#define RTDS_STARTUP_PROCESS_CREATE(PROCESS_NAME, PROCESS_NUMBER, FUNCTION_ADDRESS, PRIORITY) \
	RTDS_ProcessCreate(PROCESS_NAME, PROCESS_NUMBER, (void *)FUNCTION_ADDRESS, PRIORITY, &OFFSPRING, SELF, RTDS_HOLD, RTDS_currentContext)

/*
 * MACRO RTDS_PROCESS_KILL:
 * --------------------------
 * Kills a task representing an SDL process. An SDL task can only kill itself.
 */
#define RTDS_PROCESS_KILL \
	RTDS_ProcessKill( RTDS_currentContext );


/* ************************************************************************************ *
 *									FINITE STATE MACHINE
 * ************************************************************************************ */
/*
 * MACRO RTDS_PROCEDURE_CLEAN_UP:
 * ------------------------------
 * Macro called at the end of a procedure to free last message and re-organize
 * save queue if procedure contained states.
 */
#define RTDS_PROCEDURE_CLEAN_UP \
	RTDS_TransitionCleanUp( RTDS_currentContext, 0 );

/*
 * MACRO RTDS_SDL_STATE_SET:
 * -----------------------------
 * Sets the SDL state of the current process
 */

#define RTDS_SDL_STATE_SET(NEW_SDL_STATE) \
	RTDS_currentContext->sdlState = NEW_SDL_STATE; \
	RTDS_SIMULATOR_TRACE(RTDS_sdlStateSet, RTDS_currentContext->processId, NEW_SDL_STATE, RTDS_currentContext);

/*
 * MACRO RTDS_INFORMATION:
 * -----------------------
 * To display informal message in trace
 */
#define RTDS_INFORMATION(MESSAGE) \
    RTDS_SIMULATOR_TRACE(RTDS_information, MESSAGE, 0, RTDS_currentContext)


#ifdef __cplusplus
}
#endif

#endif /* _RTDS_MACRO_H_ */

