/* PragmaDev RTDS posix integration */
#ifndef _RTDS_OS_H_
#define _RTDS_OS_H_

/*
 * GLOBAL VARIABLES:
 * -------------------
 * Pointers to global list of information on processes and semaphores
 */
#ifdef __cplusplus
extern "C" {
#endif


/* POSIX and standard includes */
#include <sched.h>
#include <pthread.h>
#include <semaphore.h>
#include <signal.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>

/* Define MACRO for creating thread */
#include <unistd.h>

/* Time function*/
#include <sys/time.h>

/* Includes to use socket */
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>


/* Include for RTDS error messages */
#include "RTDS_Error.h"

/* Include for RTDS types */
#include "RTDS_Common.h"

/*
 * FUNCTION PROTOTYPES:
 * -------------------
 * Function defined in RTDS_OS.c used below
 */


/******************************************************************
 *            THREAD BASED TIMER FUNCTIONS
 * ----------------------------------------------------------------
 *    Functions that handle Thread based timers
 *
 *    Rem:    Regrarding the problem due to the use if Unix message
 *        (Posix timer function) other function are
 *        available that use thread bases timer
 *******************************************************************/
extern int RTDS_TimerDelete( RTDS_TimerState * watchDogId );
extern void RTDS_TimerFunction( RTDS_TimerState *timerInfo );


/******************************************************************
 *        MESSAGE FUNCTIONS
 * ----------------------------------------------------------------
 *    Function that define Message Queue operations
 *
 *******************************************************************/
extern RTDS_QCB * RTDS_MsgQueueCreate( void );
extern int RTDS_MsgQSend( RTDS_QCB *receiver , RTDS_MessageHeader * RTDS_messageToSend );
extern int RTDS_MsgQRead( RTDS_QCB *queueId , char *message );
extern void RTDS_MsgQDelete( RTDS_QCB *queueId );

/******************************************************************
 *        TTCN MESSAGE FUNCTIONS
 * ----------------------------------------------------------------
 *    Function that define Message Queue operations for TTCN
 *
 *******************************************************************/
extern void RTDS_TTCNMsgQueueSend(long , long, unsigned char *, RTDS_RtosQueueId, RTDS_SdlInstanceId* , RTDS_SdlInstanceId*, RTDS_GlobalProcessInfo *RTDS_currentContext );
extern void RTDS_TTCNMsgQueueReceive(RTDS_RtosQueueId, RTDS_SdlInstanceId *, char *, int, int);
/******************************************************************
 *        SEMAPHORE FUNCTIONS DECLARATIONS
 * ----------------------------------------------------------------
 *    Function that define Semaphore operations
 *******************************************************************/
extern RTDS_SemId RTDS_SemMCreate();
extern RTDS_SemId RTDS_SemCCreate( int initialState );
extern RTDS_SemId RTDS_SemBCreate( int initial_state );
extern void RTDS_SemDelete( RTDS_SemId semId_To_Delete );
extern int RTDS_SemGive( RTDS_SemId semId_To_Give );
extern int RTDS_SemTake( RTDS_SemId SemId_To_Give , long time_to_Wait );

/******************************************************************
 *            PROCESS FUNCTIONS
 * ----------------------------------------------------------------
 *    Function that define Process Operations
 *******************************************************************/
extern RTDS_RtosTaskId RTDS_TaskCreate(int priority, void *( *functionAddress )( void* ), void * newProcessInfo);
extern RTDS_RtosTaskId RTDS_ProcessForget( RTDS_GlobalProcessInfo *RTDS_currentContext, short deleteQueue );
extern RTDS_RtosTaskId RTDS_GetCurrentThread();

/******************************************************************
 *            SYSTEM TIME FUNCTION
 * ----------------------------------------------------------------
 *******************************************************************/
extern unsigned long RTDS_TickGet();
extern void  RTDS_TickSet( unsigned long timeValue );

#if defined( RTDS_SIMULATOR ) || defined( RTDS_MSC_TRACER )
    long           RTDS_IsSemaphoreAvailable( RTDS_SemaphoreId );
    extern void    RTDS_SimulatorTrace( enum RTDS_EventType event , void *eventParameter1 , long eventParameter2 , RTDS_GlobalProcessInfo *currentContext , int waitAck );
#endif

#if defined( RTDS_SIMULATOR ) && defined( RTDS_SOCKET_PORT )
    /* For using the command interpreter */
    extern void RTDS_ForceTimer( RTDS_SdlInstanceId *sdlInstanceId , int timerNumber );
    extern void RTDS_SetSystemTime( long timeValue );
    extern void RTDS_SimulatorMsgQueueSend( long , long, unsigned char * , RTDS_SdlInstanceId* , RTDS_SdlInstanceId* , RTDS_GlobalProcessInfo *RTDS_currentContext );
#endif /* RTDS_SIMULATOR and RTDS_SOCKET_PORT */

/* For using the dynamic trace and fill out information for RTDS_SYSTEM_ERROR */
#if defined( RTDS_SIMULATOR )
    extern RTDS_GlobalProcessInfo * RTDS_GetProcessInfoFromProcessId( RTDS_SdlInstanceId *sdlInstanceId );
    extern RTDS_GlobalProcessInfo * RTDS_GetProcessInfoFromProcessNum( int processNumber );
    extern RTDS_GlobalProcessInfo * RTDS_GetProcessInfoFromRtosTaskId( RTDS_RtosTaskId rtosTaskId );
    extern RTDS_RtosTaskId          RTDS_GetCurrentProcessId( void );
    extern unsigned long            RTDS_GetMessageUniqueId( void );
    extern void                     RTDS_ReleaseMessageUniqueId( unsigned long );
    extern void                     RTDS_DummyTraceFunction( void );
    extern void                     RTDS_DummyRunUntilQueueEmptyFunction ( void );
#endif

extern long                 RTDS_GetTimerUniqueId( RTDS_TimerState * );
extern void                 RTDS_WatchDogFunction( RTDS_TimerState * );
extern void                 RTDS_StartTimer( RTDS_SdlInstanceId* , long , long , int , RTDS_TimerState ** , RTDS_GlobalProcessInfo *RTDS_currentContext);
extern void                 RTDS_StopTimer( long , RTDS_TimerState **, RTDS_GlobalProcessInfo *RTDS_currentContext );
extern void                 RTDS_MsgQueueSend ( long , long, unsigned char *, RTDS_SdlInstanceId* , RTDS_SdlInstanceId*, RTDS_GlobalProcessInfo *RTDS_currentContext );
extern void                 RTDS_MsgQueueReceive ( RTDS_SdlInstanceId*, char * , int , int );
extern RTDS_SdlInstanceId * RTDS_GetProcessQueueId ( int processNumber );
extern void                 RTDS_ProcessCreate( int processNumber, void * , int , RTDS_SdlInstanceId**, RTDS_SdlInstanceId*, short, RTDS_GlobalProcessInfo*);
extern void                 RTDS_ProcessKill ( RTDS_GlobalProcessInfo *RTDS_currentContext );
extern void                 RTDS_SemaphoreIdDelete ( RTDS_SemaphoreId, RTDS_GlobalProcessInfo *RTDS_currentContext );
extern RTDS_SemaphoreStatus RTDS_SemaphoreIdTake ( RTDS_SemaphoreId , RTDS_SemaphoreTimeout, RTDS_GlobalProcessInfo *RTDS_currentContext);
extern void                 RTDS_SemaphoreIdGive( RTDS_SemaphoreId , RTDS_GlobalProcessInfo *RTDS_currentContext );
extern RTDS_SemaphoreId     RTDS_GetSemaphoreId ( int semaphoreNumber );
extern RTDS_SemaphoreId     RTDS_Sem_Info_Insert ( int semaphoreNumber, RTDS_SemaphoreId, RTDS_GlobalProcessInfo *RTDS_currentContext );
extern int                  RTDS_CheckQueueId( RTDS_SdlInstanceId * instanceId );
extern void                 RTDS_TransitionCleanUp( RTDS_GlobalProcessInfo *RTDS_currentContext, int RTDS_sdlStatePrev );
extern void                 RTDS_TimerCleanUp(RTDS_GlobalProcessInfo * currentContext);
extern long                 RTDS_GetSystemTime( void );

#if defined( RTDS_SIMULATOR ) || defined( RTDS_CMD_INTERPRETER ) || defined( RTDS_BACK_TRACE_MAX_EVENT_NUM ) || defined( RTDS_MSC_TRACER )
    extern void RTDS_messageDataToString( char ** buffer , long sigNum , long dataLength , void* pData , int level );
    extern char *RTDS_stringToMessageData( long messageNumber , long *dataLength , void **dataPointer , char *dataString );
#endif

/*
 * EXTERNAL VARIABLE:
 * -------------------
 * Variable declared as global to the all the program
 */
extern RTDS_GlobalProcessInfo *RTDS_globalProcessInfo;
extern RTDS_GlobalSemaphoreInfo *RTDS_globalSemaphoreInfo;

#ifdef RTDS_SOCKET_PORT
    extern int globalClientSocketId;
#endif

#if defined( RTDS_SIMULATOR ) || defined( RTDS_MSC_TRACER ) || defined( RTDS_FORMAT_TRACE )
    extern RTDS_GlobalTraceInfo RTDS_globalTraceEntry;
    /* Global variable pointing to decoded parmaters */
    extern char *RTDS_globalPrintableParameters;
#endif

#if defined( RTDS_SIMULATOR )
    extern void *RTDS_globalMessageUniqueIdPool;
#endif

#ifdef RTDS_SOCKET_PORT
    #ifndef RTDS_SOCKET_IP_ADDRESS
        #define RTDS_SOCKET_IP_ADDRESS "127.0.0.1"
    #endif

    #define TO_STRING( X ) #X
    #define GET_HOSTNAME_STRING( X ) TO_STRING( X )

    #define RTDS_SOCKET_ID_TYPE int
    extern RTDS_SOCKET_ID_TYPE RTDS_InitSocket( char *hostNameString , int portNum );
    extern void RTDS_CloseSocket( RTDS_SOCKET_ID_TYPE socketDescriptor );

    int RTDS_ReadSocket( RTDS_SOCKET_ID_TYPE socketDescriptor , char **data , int *dataSize , char delimiterChar , char escapeChar );
    void RTDS_SendSocket( RTDS_SOCKET_ID_TYPE socketId , char *commandString , int size );

#endif

#ifdef __cplusplus
}
#endif

#endif /* End of    _RTDS_OS_H_ */


