/* PragmaDev RTDS ThreadX integration */

/* List of errors returned by RTDS 'kernel' */

#define RTDS_ERROR_NO_MORE_TIMER_UNIQUE_ID						0x0001
#define RTDS_ERROR_MSG_Q_SEND_IN_WATCHDOG 						0x0002
#define RTDS_ERROR_WATCHDOG_CREATION									0x0003

#define RTDS_ERROR_WATCHDOG_START 										0x0005
#define RTDS_ERROR_MSG_QUEUE_SEND 										0x0006
#define RTDS_ERROR_MSG_INPUT													0x0007

#define RTDS_ERROR_MALLOC_TIMER_STATE_IN_START_TIMER	0x0008
#define RTDS_ERROR_TIMER_TO_STOP_NOT_FOUND						0x0009

#define RTDS_ERROR_TASK_DELETE												0x0010
#define RTDS_ERROR_MSG_QUEUE_DELETE 									0x0011

#define RTDS_ERROR_PROCESS_CREATE_MALLOC							0x0012
#define RTDS_ERROR_PROCESS_CREATE_MSG_Q_CREATE				0x0013
#define RTDS_ERROR_PROCESS_CREATE_TASK_SPAWN					0x0014

#define RTDS_ERROR_SEM_INFO_INSERT_MALLOC 						0x0015
#define RTDS_ERROR_SEM_INFO_INSERT										0x0016

#define RTDS_ERROR_GET_SEMAPHORE_ID 									0x0017 /* semaphore name not found */

#define RTDS_ERROR_TIMER_INCONSISTANT 								0x0022 /* parameters in the header are not consistant with a timer message */

#define RTDS_ERROR_GET_PROCESS_QUEUE_ID 							0x0023 /* process name not found */

#define RTDS_ERROR_STARTUP_CONTEXT_MALLOC 						0x0024 /* startup task could not allocate memory for current context */

#define RTDS_ERROR_TASK_TO_DELETE_NOT_FOUND 					0x0025 /* The task to delete was not found in the globalProcessInfoList */
#define RTDS_ERROR_GET_SEMAPHORE_INFO 								0x0026 /* The semaphore was not found in the global semaphore list */
#define RTDS_ERROR_BINARY_SEMAPHORE_CREATE						0x0027 /* Error when creating binary semaphore */
#define RTDS_ERROR_COUNTING_SEMAPHORE_CREATE					0x0028 /* Error when creating counting semaphore */
#define RTDS_ERROR_MUTEX_SEMAPHORE_CREATE 						0x0029 /* Error when creating mutex semaphore */
#define RTDS_ERROR_MSG_QUEUE_RECEIVE									0x0030 /* Error while trying to read a message queue */
#define RTDS_ERROR_MEMALLOC_ERROR 										0x0031 /* Error while trying to allocate memory in RTDS_MemAlloc */
#define RTDS_ERROR_MEMFREE_ERROR											0x0032 /* Error while trying to free memory in RTDS_MemFree */
#define RTDS_ERROR_DELETING_TIMER 										0x0033 /* Error while trying to delete ThreadX application timer */
#define RTDS_ERROR_DEACTIVATING_TIMER 								0x0034 /* Error while trying to de-activate ThreadX application timer */
#define RTDS_ERROR_PROCESS_CREATE_RESUME							0x0035 /* Error when trying to resume the newly created task */
#define RTDS_ERROR_PROCESS_CREATE_THREAD_DELETE 			0x0036 /* Error when trying to delete a thread that has been terminated to create a new one */

#define RTDS_ERROR_NO_MORE_MSG_UNIQUE_ID							0x1001 /* No more message unique id available. Increase RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE */
#define RTDS_ERROR_BACK_TRACE_NOT_ENOUGH_MEMORY 			0x1002 /* There is not enough memory to store all the events in RAM. Reduce RTDS_BACK_TRACE_MAX_EVENT_NUM or RTDS_BACK_TRACE_MESSAGE_DATA_SIZE */

