/* ***************************************************************** */
/* $(RTDS_HOME)/share/ccg/vxworks/bricks/RTDS_Startup_begin.c begins */
/* PragmaDev RTDS VxWorks integration                                */

/* Pointers to global list of information on processes and semaphores */
RTDS_GlobalProcessInfo * RTDS_globalProcessInfo = NULL;
RTDS_GlobalSemaphoreInfo * RTDS_globalSemaphoreInfo = NULL;

RTDS_COVERAGE_DECL;
RTDS_START_SYNCHRO_DECL;
RTDS_CRITICAL_SECTION_DECL;

/* **************************************************************** *
 * RTDS_Start
 * **************************************************************** *
 * That is RTDS generated code entry point.
 * This task or function will create all the static processes and
 * semaphores and when everyone is ready will let them go.
 * **************************************************************** *
 * Parameters:
 *      none
 * Returns:
 *      nothing
 * **************************************************************** */
void RTDS_Start( void )
    {
    RTDS_GlobalProcessInfo * RTDS_currentContext;
    
    RTDS_COVERAGE_INIT;
    
    #ifdef RTDS_SIMULATOR
        /* Set up the message unique id pool */
        RTDS_globalMessageUniqueIdPool = ( unsigned char * )RTDS_MALLOC( RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE );
            {
            int RTDS_i;
            unsigned char * index;
            
            index = RTDS_globalMessageUniqueIdPool;
            for( RTDS_i = 0; RTDS_i < RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE; RTDS_i++ )
                {
                *index = 0x00;
                index++;
                }
            }
    #endif
    
    #if defined( RTDS_BACK_TRACE_MAX_EVENT_NUM ) && defined( RTDS_SIMULATOR )
        /* Initialize circular buffer to trace in RAM */
        RTDS_TraceInit();
    #endif
    
    /* Set up the process context needed to create tasks */
    RTDS_currentContext = ( RTDS_GlobalProcessInfo * )RTDS_MALLOC( sizeof( RTDS_GlobalProcessInfo ) );
    
    if ( RTDS_currentContext == NULL )
        {
        RTDS_SYSTEM_ERROR( RTDS_ERROR_STARTUP_CONTEXT_MALLOC );
        }
    
    RTDS_currentContext->mySdlInstanceId = NULL;
    RTDS_currentContext->myRtosTaskId = 0;
    RTDS_currentContext->sdlProcessNumber = 0;
    RTDS_currentContext->sdlState = 0;
    RTDS_currentContext->next = NULL;
    RTDS_currentContext->parentSdlInstanceId = NULL;
    RTDS_currentContext->offspringSdlInstanceId = NULL;
    RTDS_currentContext->currentMessage = NULL;
    RTDS_currentContext->timerList = NULL;
    RTDS_currentContext->readSaveQueue = NULL;
    RTDS_currentContext->writeSaveQueue = NULL;
    
    RTDS_CRITICAL_SECTION_INIT;
    RTDS_START_SYNCHRO_INIT;
    
    /* $(RTDS_HOME)/share/ccg/vxworks/bricks/RTDS_Startup_begin.c ends */
    /* *************************************************************** */
