source_folder_name=`dirname $0`
install_script=`basename $0`
osascript - <<.
tell application "Finder"
  activate
  set close_dialog to false
  set license_accepted to false
  repeat until close_dialog
  	set close_dialog to true
	  set dialog_answer to (display dialog "To install PragmaDev applications, you must agree to the End User License Agreement (EULA)." buttons {"Cancel installation", "Open EULA", "I have read and I agree to the EULA"})
  	if button returned of dialog_answer is "Open EULA" then
	  	tell application "TextEdit"
	  		activate
	  		open POSIX file "$source_folder_name/doc/LICENSE.txt"
	  	end tell
	  	set close_dialog to false
	  else if button returned of dialog_answer is "I have read and I agree to the EULA" then
	  	set license_accepted to true
	  end if
	end repeat
	if license_accepted then
	  activate
	  set applications_to_install to (choose from list {"PragmaDev Studio", "PragmaDev Specifier", "PragmaDev Developer", "PragmaDev Tester"} with prompt "Choose application(s) you wish to install" with multiple selections allowed)
	  if applications_to_install is not false then
	    if (length of applications_to_install) is 1 then
	      set application_label to (item 1 of applications_to_install) as text
	    else
	      set application_label to "PragmaDev applications"
	    end if
      set installation_folder to (choose folder with prompt "Select installation folder for " & application_label & ":" default location "/Applications")
      set answer to (display dialog "This will install " & application_label & " from $source_folder_name to " & (POSIX path of installation_folder) & ". OK to continue?" buttons {"Cancel", "OK"} default button "OK")
      if button returned of answer is "OK" then
        set installation_folder to (duplicate POSIX file "$source_folder_name" to folder installation_folder)
        set executable_folder to (folder "macosx" of folder "bin" of installation_folder)
        move item "PragmaDevStudio.app" of executable_folder to installation_folder
        if applications_to_install contains "PragmaDev Specifier" then
          move item "PragmaDevSpecifier.app" of executable_folder to installation_folder
        end if
        if applications_to_install contains "PragmaDev Developer" then
          move item "PragmaDevDeveloper.app" of executable_folder to installation_folder
        end if
        if applications_to_install contains "PragmaDev Tester" then
          move item "PragmaDevTester.app" of executable_folder to installation_folder
        end if
        delete folder "bin" of installation_folder
        delete file "$install_script" of installation_folder
        set font_answer to (display dialog "Application installed. It is recommended to install the fonts provided with " & application_label & " for better display and printing results. To do so, click the 'Install fonts locally' button below, or the 'Install fonts system-wide' button if you have administrator access." buttons {"Skip fonts installation", "Install fonts locally", "Install fonts system-wide"} default button "Install fonts locally")
        set font_path to (file "DejaVuSansMono-Roman.ttf" of folder "fonts" of folder "print" of folder "share" of installation_folder)
        if button returned of font_answer is "Install fonts locally" then
          duplicate font_path to (folder "Fonts" of folder "Library" of home) replacing yes
        else if button returned of font_answer is "Install fonts system-wide" then
          duplicate font_path to (folder "Fonts" of folder "Library" of startup disk) replacing yes
        end if
        set name of installation_folder to "PragmaDevStudio"
        display dialog "Installation complete! If the installation tool opened a Terminal window, you can now close it safely.\nWelcome to PragmaDev Studio!"
      end if
    end if
	end if
end tell
.
