/* ********************************** PRAGMADEV TRACER MACROS ********************************** */

/* ********************************** DECLARATIONS AND INIT MACROS ********************************** */
#define PRAGMADEV_TRACER_INCLUDE                                                #include <stdio.h>
#define PRAGMADEV_TRACER_PROTO                                                  extern FILE *pragmadevTracerFile;
#define PRAGMADEV_TRACER_DECL                                                   FILE *pragmadevTracerFile=NULL;
#define PRAGMADEV_TRACER_INIT                                                   pragmadevTracerFile=fopen("pragmadevTracer.txt","w");
#define PRAGMADEV_TRACER_CLEANUP                                                fclose(pragmadevTracerFile);

/* ********************************** INSTANCE MACROS ********************************** */
#define PRAGMADEV_TRACER_INSTANCE_CREATION(TIME, INSTANCE_NAME, INSTANCE_ID)    fprintf(pragmadevTracerFile,"taskCreated| -t%d| -n%s| %s|\n",TIME, INSTANCE_NAME, INSTANCE_ID);
#define PRAGMADEV_TRACER_INSTANCE_DELETION(TIME, INSTANCE_ID)                   fprintf(pragmadevTracerFile,"taskDeleted| -t%d| %s|\n", TIME, INSTANCE_ID);

/* ********************************** MESSAGE MACROS ********************************** */
#define PRAGMADEV_TRACER_MESSAGE_SENT(TIME, INSTANCE_NAME, INSTANCE_ID, MESSAGE_NAME, MESSAGE_ID, MESSAGE_DATA) \
    fprintf(pragmadevTracerFile,"messageSent| -t%d| -n%s| -d%s| %s| %s| %s|\n",TIME, INSTANCE_NAME, MESSAGE_DATA, INSTANCE_ID, MESSAGE_ID, MESSAGE_NAME);
#define PRAGMADEV_TRACER_MESSAGE_RECEIVED(TIME, INSTANCE_NAME, INSTANCE_ID, MESSAGE_NAME, MESSAGE_ID, MESSAGE_DATA) \
    fprintf(pragmadevTracerFile,"messageReceived| -t%d| -n%s| -d%s| %s| %s| %s|\n",TIME, INSTANCE_NAME, MESSAGE_DATA, INSTANCE_ID, MESSAGE_ID, MESSAGE_NAME);
#define PRAGMADEV_TRACER_MESSAGE_SAVED(TIME, INSTANCE_NAME, INSTANCE_ID, MESSAGE_NAME, MESSAGE_ID) \
    fprintf(pragmadevTracerFile,"messageSaved| -t%d| -n%s| %s| %s| %s|\n",TIME, INSTANCE_NAME, INSTANCE_ID, MESSAGE_ID, MESSAGE_NAME);

/* ********************************** STATE MACROS ********************************** */
#define PRAGMADEV_TRACER_STATE_CHANGE(TIME, INSTANCE_NAME, INSTANCE_ID, STATE_NAME) \
    fprintf(pragmadevTracerFile,"taskChangedState| -t%d| -n%s| %s| %s|\n", TIME, INSTANCE_NAME, INSTANCE_ID, STATE_NAME);

/* ********************************** SEMAPHORE MACROS ********************************** */
/* A -1 value for timeout means wait forever on the semaphore */
#define PRAGMADEV_TRACER_SEMAPHORE_CREATION(TIME, SEMAPHORE_NAME, SEMAPHORE_ID) fprintf(pragmadevTracerFile,"semaphoreCreated| -t%d| -S%s| %s|\n",TIME, SEMAPHORE_NAME, SEMAPHORE_ID);
#define PRAGMADEV_TRACER_SEMAPHORE_DELETION(TIME, SEMAPHORE_NAME, SEMAPHORE_ID) fprintf(pragmadevTracerFile,"semaphoreDeleted| -t%d| -S%s| %s|\n",TIME, SEMAPHORE_NAME, SEMAPHORE_ID);
#define PRAGMADEV_TRACER_SEMAPHORE_TAKE_ATTEMPT(TIME, SEMAPHORE_NAME, SEMAPHORE_ID, SEMAPHORE_TIMEOUT, INSTANCE_NAME, INSTANCE_ID) \
    fprintf(pragmadevTracerFile,"takeAttempt| -t%d| -n%s| -s%s| -T%s| %s| %s|\n",TIME, INSTANCE_NAME, SEMAPHORE_NAME, SEMAPHORE_TIMEOUT, INSTANCE_ID, SEMAPHORE_ID);
/* If semaphore state after successfull take is empty (value 0) or full (value 1) */
#define PRAGMADEV_TRACER_SEMAPHORE_TAKE_SUCCEEDED(TIME, SEMAPHORE_NAME, SEMAPHORE_ID, SEMAPHORE_AVAILABLE, INSTANCE_NAME, INSTANCE_ID) \
    fprintf(pragmadevTracerFile,"takeSucceeded| -t%d| -n%s| -s%s| -a%s| %s| %s|\n",TIME, INSTANCE_NAME, SEMAPHORE_NAME, SEMAPHORE_AVAILABLE, INSTANCE_ID, SEMAPHORE_ID);
#define PRAGMADEV_TRACER_SEMAPHORE_TAKE_TIMED_OUT(TIME, SEMAPHORE_NAME, SEMAPHORE_ID, INSTANCE_NAME, INSTANCE_ID) \
    fprintf(pragmadevTracerFile,"takeTimedOut| -t%d| -n%s| -s%s| %s| %s|\n",TIME, INSTANCE_NAME, SEMAPHORE_NAME, INSTANCE_ID, SEMAPHORE_ID);
#define PRAGMADEV_TRACER_SEMAPHORE_GIVE(TIME, SEMAPHORE_NAME, SEMAPHORE_ID, INSTANCE_NAME, INSTANCE_ID) \
    fprintf(pragmadevTracerFile,"giveSem| -t%d| -n%s| -s%s| %s| %s|\n",TIME, INSTANCE_NAME, SEMAPHORE_NAME, INSTANCE_ID, SEMAPHORE_ID);

/* ********************************** INFORMATION MACROS ********************************** */
#define PRAGMADEV_TRACER_INFORMATION(TIME, INSTANCE_NAME, INSTANCE_ID, INFORMATION) \
    fprintf(pragmadevTracerFile,"information| -t%d| -n%s| %s| %s|\n",TIME, INSTANCE_NAME, INSTANCE_ID, INFORMATION);

/* ********************************** TIMER MACROS ********************************** */
#define PRAGMADEV_TRACER_TIMER_STARTED(TIME, INSTANCE_NAME, INSTANCE_ID, TIMER_NAME, TIMER_ID, TIMEOUT_VALUE) \
    fprintf(pragmadevTracerFile,"timerStarted| -t%d| -n%s| -T%s| %s|\n",TIME, INSTANCE_NAME, TIMER_NAME, INSTANCE_ID, TIMER_ID, TIMEOUT_VALUE);
#define PRAGMADEV_TRACER_TIMER_CANCELED(TIME, INSTANCE_NAME, INSTANCE_ID, TIMER_NAME, TIMER_ID) \
    fprintf(pragmadevTracerFile,"timerCancelled| -t%d| -n%s| -T%s| %s|\n",TIME, INSTANCE_NAME, TIMER_NAME, INSTANCE_ID, TIMER_ID);
#define PRAGMADEV_TRACER_TIMER_TIMED_OUT(TIME, INSTANCE_NAME, INSTANCE_ID, TIMER_NAME, TIMER_ID) \
    fprintf(pragmadevTracerFile,"timerTimedOut|| -t%d| -n%s| -T%s| %s|\n",TIME, INSTANCE_NAME, TIMER_NAME, INSTANCE_ID, TIMER_ID);



