#include <stdio.h>
#include "PragmaDevTracer.h"

PRAGMADEV_TRACER_DECL;

int main(void)
    {
    int i;
    char buffer[50];
    
    PRAGMADEV_TRACER_INIT;
    PRAGMADEV_TRACER_INSTANCE_CREATION(100, "MainInstance", "0x01");
    PRAGMADEV_TRACER_INSTANCE_CREATION(200, "SecondaryInstance", "0x02");
    PRAGMADEV_TRACER_STATE_CHANGE(405+10*1, "MainInstance", "0x01", "idle");
    PRAGMADEV_TRACER_STATE_CHANGE(405+10*1, "SecondaryInstance", "0x02", "idle");
    PRAGMADEV_TRACER_SEMAPHORE_CREATION(250, "MySemaphore", "0x03")
    printf("Hello world\n");
    PRAGMADEV_TRACER_INFORMATION(300, "MainInstance", "0x01", "Hello world");
    for (i=0; i<10; i++)
        {
        sprintf(buffer,"%d",i);
        PRAGMADEV_TRACER_MESSAGE_SENT(400+10*i, "MainInstance", "0x01", "ping", buffer, "Non sensitive parameters...");
        PRAGMADEV_TRACER_MESSAGE_RECEIVED(401+10*i, "SecondaryInstance", "0x02", "ping", buffer, "Non sensitive parameters...");
        PRAGMADEV_TRACER_SEMAPHORE_TAKE_ATTEMPT(402+10*1, "MySemaphore", "0x03", "-1", "SecondaryInstance", "0x02");
        PRAGMADEV_TRACER_SEMAPHORE_TAKE_SUCCEEDED(403+10*1, "MySemaphore", "0x03", "0", "SecondaryInstance", "0x02");
        PRAGMADEV_TRACER_TIMER_STARTED(404+10*1, "SecondaryInstance", "0x02", "MyTimer", "0x04", "1");
        PRAGMADEV_TRACER_STATE_CHANGE(405+10*1, "SecondaryInstance", "0x02", "Wait4Timer");
        PRAGMADEV_TRACER_TIMER_TIMED_OUT(406+10*1, "SecondaryInstance", "0x02", "MyTimer", "0x04");
        PRAGMADEV_TRACER_SEMAPHORE_GIVE(407+10*1, "MySemaphore", "0x03", "SecondaryInstance", "0x02");
        PRAGMADEV_TRACER_MESSAGE_SENT(408+10*i, "SecondaryInstance", "0x02", "pong", buffer, "Very sensitive parameters...");
        PRAGMADEV_TRACER_STATE_CHANGE(405+10*1, "SecondaryInstance", "0x02", "idle");
        PRAGMADEV_TRACER_MESSAGE_RECEIVED(409+10*i, "MainInstance", "0x01", "pong", buffer, "Very sensitive parameters...");
        }
    PRAGMADEV_TRACER_INSTANCE_DELETION(900, "0x01");
    PRAGMADEV_TRACER_SEMAPHORE_DELETION(1000, "MySemaphore", "0x03");
    PRAGMADEV_TRACER_CLEANUP;
    }
