#!/bin/sh

# ========================================
# INSTALLATION SCRIPT FOR PRAGMADEV STUDIO
# ========================================
# Copyright (c) PragmaDev 2002
#
# History:
# ------------------------------------------------------------
# Version | Comment
# ------------------------------------------------------------
# 1.0     | Creation
# 1.1     | Exclude share/3rdparty/MinGW when installing on
#         | and for Unix
# 1.2     | Clean-up target directory before installing
# 2.0     | Adaptation for PragmaDev Studio
# ------------------------------------------------------------

## Function reading a line from the terminal
getAnswer()
{
  ## Read from terminal
  read answer
  ## Quit if needed
  if [ "$answer" = "q" ]
  then
    exit 0
  fi
  ## Output answer
  echo $answer
}

## Welcome screen
cat <<.
=============================
PRAGMADEV STUDIO INSTALLATION
=============================
This is the installation script for PragmaDev Studio, PragmaDev Specifier,
PragmaDev Developer and PragmaDev Tester.

Please select the application(s) you wish to install:

  (1) PragmaDev Studio
  (2) PragmaDev Specifier
  (3) PragmaDev Developer
  (4) PragmaDev Tester
  (q) Abort installation and quit

Please enter one or several digits separated with a space (e.g '4' or '1 3')
or 'q' to quit.
.
application_numbers=`getAnswer`
install_studio="no"
install_specifier="no"
install_developer="no"
install_tester="no"
application_label=""
for i in $application_numbers
do
  case $i in
    1)
      install_studio="yes"
      if [ "$application_label" = "" ]
      then
        application_label="PragmaDev Studio"
      else
        application_label="PragmaDev applications"
      fi
      ;;
    2)
      install_specifier="yes"
      if [ "$application_label" = "" ]
      then
        application_label="PragmaDev Specifier"
      else
        application_label="PragmaDev applications"
      fi
      ;;
    3)
      install_developer="yes"
      if [ "$application_label" = "" ]
      then
        application_label="PragmaDev Developer"
      else
        application_label="PragmaDev applications"
      fi
      ;;
    4)
      install_tester="yes"
      if [ "$application_label" = "" ]
      then
        application_label="PragmaDev Tester"
      else
        application_label="PragmaDev applications"
      fi
      ;;
    *)
      echo "Unknown application number $i - ignored"
      ;;
  esac
done
if [ "$install_studio" = "no" -a "$install_specifier" = "no" -a "$install_developer" = "no" -a "$install_tester" = "no" ]
then
  echo "Nothing to install; aborting installation."
  exit 1
fi

## Architecture may be passed as an argument
arch=$1

## If it wasn't, try to figure it out
if [ "$arch" = "" ]
then
  case `uname -s` in
    Linux)
      arch='linux'
      ;;
    SunOS)
      case `uname -r` in
        5.10)
          arch='solaris10intel'
          ;;
        *)
          arch='solaris8sparc'
          ;;
        esac
      ;;
  esac
fi

## If architecture still not found or invalid, can't proceed
if [ "$arch" != "linux" -a "$arch" != "solaris8sparc" -a "$arch" != "solaris10intel" ]
then
  echo '!!! ERROR !!!'
  echo 'Unable to determine architecture.'
  echo 'You may try to re-run this installation script passing the architecture'
  echo 'as an argument. Valid architectures are "linux", "solaris8sparc" and'
  echo 'solaris10intel.'
  exit 1
fi

## Directory for install script is the mount point of the CD-ROM
rootDir=`dirname $0`

## Display license agreement
more $rootDir/doc/LICENSE.txt
echo ""
echo "Answer 'yes' to accept this license agreement. Any other answer will quit the installation."
license_answer=`getAnswer`
if [ "$license_answer" != "yes" ]
then
  echo "Licence refused. Quitting..."
  exit 0
fi

## Ask for installation directory
installDir=""
while [ "$installDir" = "" ]
do
  echo ""
  echo "Please enter the installation directory for $application_label"
  echo "(default: /opt/pragmadev/pragmastudio; 'q' to quit)"
  installDir=`getAnswer`
  if [ "$installDir" = "" ]
  then
    installDir='/opt/pragmadev/pragmastudio'
  fi

  ## If installation directory already exists
  if [ -r "$installDir" ]
  then
    ## If it's not a directory, error...
    if [ ! -d "$installDir" ]
    then
      echo '!!! ERROR !!!'
      echo "File $installDir exists, but is not a directory. Please choose another"
      echo "location."
      echo ""
      echo "Press return to continue or 'q' to quit"
      getAnswer > /dev/null
      installDir=""
    else
      ## If directory is not writable, error
      if [ ! -w "$installDir" ]
      then
        echo '!!! ERROR !!!'
        echo "Directory $installDir exists, but is not writable. Please choose another"
        echo "location, or quit the installation and re-log as a user with sufficient"
        echo "rights to write in this directory"
        echo ""
        echo "Press return to continue or 'q' to quit"
        getAnswer > /dev/null
        installDir=""
      ## If directory is writable
      else
        ## Directory will be emptied; ask confirmation
        echo "--- WARNING! ---"
        echo "Existing directory $installDir will be emptied before installation!"
        echo "Do you really want to install in $installDir ([y]/n/q)?"
        answer=`getAnswer`
        if [ "$answer" = "n" ]
        then
          installDir=""
        fi
      fi
    fi
  ## If installation directory does not exist, ask if we should create it
  else
    echo "Directory $installDir does not exist. Do you want to create it ([y]/n/q)?"
    answer=`getAnswer`
    if [ "$answer" != "n" ]
    then
      mkdir -p $installDir
      ## If creation failed
      if [ $? -ne 0 ]
      then
        echo '!!! ERROR !!!'
        echo "Could not create installation directory $installDir"
        echo "Make sure you have the appropriate rights or choose another directory"
        echo ""
        echo "Press return to continue or enter 'q' to quit"
        getAnswer > /dev/null
        installDir=""
      fi
    else
      installDir=""
    fi
  fi
done

## Confirmation screen
cat <<.

$application_label will now be installed with the following parameters:

 - Architecture: $arch
 
 - Installation directory: $installDir

PLEASE CHECK THE INFORMATIONS ABOVE. If you press return now, $application_label
will be installed. If any of the informations above is not correct, enter 'q'
and re-run the installation script from the beginning.
.
getAnswer > /dev/null

## Clean-up destination directory
echo '--- Cleaning up installation directory'
( cd $installDir ; rm -rf `ls -A` )

## Install binaries
echo '--- Installing $application_label binaries'
cd $rootDir
if [ ! -r $installDir/bin ]
then
  mkdir $installDir/bin
fi
cp -r bin/$arch/* $installDir/bin/
## Clean up unneeded wrapper scripts
if [ "$install_studio" = "no" ]
then
  rm $installDir/bin/pragmastudio
fi
if [ "$install_specifier" = "no" ]
then
  rm $installDir/bin/pragmaspecifier
fi
if [ "$install_developer" = "no" ]
then
  rm $installDir/bin/pragmadeveloper
fi
if [ "$install_tester" = "no" ]
then
  rm $installDir/bin/pragmatester
fi

## Install documentation
echo '--- Installing $application_label documentation'
tar cf - doc | (cd $installDir ; tar xf -)

## Install common files
## NB: the --exclude tar option is a GNU tar extension; don't try to use it on platforms
## that do not have GNU tar installed by default (namely Solaris)
echo '--- Installing $application_label common files'
if [ "$arch" = "windows" -o "`uname -s`" = "SunOS" ]
then
  tarOptions=''
else
  tarOptions='--exclude=share/3rdparty/MinGW'
fi
tar cf - $tarOptions share | (cd $installDir ; tar xf -)
## Change permissions on share/ccg to make sure files won't be deleted by mistake
chmod -R a-w $installDir/share/ccg

## Install contributed files
if [ -d contrib ]
then
  echo '--- Installing contributed files'
  tar cf - contrib | (cd $installDir ; tar xf -)
fi

## Install examples
echo '--- Installing $application_label example files'
tar cf - examples | (cd $installDir ; tar xf -)

## Creating configuration scripts
echo '--- Creating configuration scripts'
echo "RTDS_HOME=$installDir" > $installDir/pragmastudio-config.sh
echo "MSCT_HOME=$installDir" >> $installDir/pragmastudio-config.sh
echo 'PATH="$PATH":$RTDS_HOME/bin' >> $installDir/pragmastudio-config.sh
echo 'LD_LIBRARY_PATH="$LD_LIBRARY_PATH":$RTDS_HOME/bin' >> $installDir/pragmastudio-config.sh
echo 'export RTDS_HOME MSCT_HOME PATH LD_LIBRARY_PATH' >> $installDir/pragmastudio-config.sh

echo "setenv RTDS_HOME $installDir" > $installDir/pragmastudio-config.csh
echo "setenv MSCT_HOME $installDir" >> $installDir/pragmastudio-config.csh
echo 'setenv PATH "$PATH":$RTDS_HOME/bin' >> $installDir/pragmastudio-config.csh
echo 'setenv LD_LIBRARY_PATH "$LD_LIBRARY_PATH":$RTDS_HOME/bin' >> $installDir/pragmastudio-config.csh


## Done; display post-installation readme file
cat - $rootDir/doc/INSTALL.txt <<. | more
--- Installation complete.

.
echo 'Press return'
read dummy

## Over
echo ''
echo 'Installation completed successfully!'
echo ''
echo "WARNING: to be able to run $application_label, each account must have defined the"
echo "environment variable RTDS_HOME to $installDir, and included the path to"
echo "$application_label binaries in its PATH and LD_LIBRARY_PATH environment variables"
echo ""
echo "To do this:"
echo ""
echo " - on sh compatible shells (sh, ksh, bash), source in your .profile the script"
echo "   $installDir/pragmastudio-config.sh"
echo ""
echo " - on csh compatible shells (csh, tcsh), source in your .cshrc the script"
echo "   $installDir/pragmastudio-config.csh"
echo ''
echo 'Once your environment is correct, you can the following command(s):'
if [ "$install_studio" = "yes" ]
then
  echo " - 'pragmastudio' for PragmaDev Studio"
fi
if [ "$install_specifier" = "yes" ]
then
  echo " - 'pragmaspecifier' for PragmaDev Specifier"
fi
if [ "$install_developer" = "yes" ]
then
  echo " - 'pragmadeveloper' for PragmaDev Developer"
fi
if [ "$install_tester" = "yes" ]
then
  echo " - 'pragmatester' for PragmaDev Tester"
fi
echo ''
echo 'Welcome to $application_label!'

exit 0
