/* PragmaDev RTDS posix integration */
#ifndef _RTDS_OS_H_
#define _RTDS_OS_H_

#include "RTDS_Proc.h"
#include "RTDS_Scheduler.h"


/*
 * GLOBAL VARIABLES:
 * -------------------
 * Pointers to global list of information on processes and semaphores
 */
#ifdef __cplusplus
extern "C" {
#endif

/* Include for RTDS error messages */
#include "RTDS_Error.h"

/* Include for RTDS types */
#include "RTDS_Common.h"


/*
** MESSAGE FUNCTIONS:
** ------------------
** Handle messages and message queues
*/
extern RTDS_QCB * RTDS_MsgQCreate( void );
extern int RTDS_Wait4ExternalMessage( RTDS_MessageHeader *);

/*
** The function RTDS_incomingSdlEvent should be defined by the user to retrieve
** external messages. The 'timeLeft' parameter is the time left before the next
** timer times-out. If a message is actually received, it should be entered into
** the pre-allocated 'message' parameter and the function should return 1. If no
** message is received within the requested delay, the function should return 0.
*/
extern short RTDS_incomingSdlEvent(RTDS_MessageHeader * message, long timeLeft);


/*
** TIMER FUNCTIONS:
** ----------------
** Handle timers
*/
extern long RTDS_GetTimerUniqueId(void);
extern void RTDS_StartTimer(RTDS_GlobalProcessInfo * context, long timerNumber, long timerUniqueId, int delay);
extern void RTDS_StopTimer(RTDS_GlobalProcessInfo * context, long timerNumber);

/*
** PROCESS FUNCTIONS:
** ------------------
** Handle process creation and deletion
*/
extern void RTDS_ProcessForget( RTDS_GlobalProcessInfo * RTDS_currentContext );


extern void RTDS_TimerCleanUp(RTDS_GlobalProcessInfo * currentContext);


/*
** SEMAPHORE FUNCTIONS:
** --------------------
** Handle semaphore creation, registration and manipulation
*/
extern void RTDS_SemaphoreRegister(RTDS_Scheduler * parentScheduler, int semaphoreNumber, RTDS_SemaphoreId semaphoreId, RTDS_GlobalProcessInfo * creatorContext);
extern RTDS_SemaphoreId RTDS_BinarySemaphoreCreate(RTDS_Scheduler * parentScheduler, int initialState);
extern RTDS_SemaphoreId RTDS_CountingSemaphoreCreate(RTDS_Scheduler * parentScheduler, int initialCount);
extern RTDS_SemaphoreId RTDS_MutexSemaphoreCreate(RTDS_Scheduler * parentScheduler);
extern RTDS_SdlInstanceId * RTDS_GetSemaphoreId(int semaphoreNumber);


/*
** MESSAGE HANDLING FUNCTIONS:
** ---------------------------
*/
#ifdef RTDS_SIMULATOR
extern unsigned long    RTDS_GetMessageUniqueId( void );
extern void             RTDS_ReleaseMessageUniqueId( unsigned long );
extern char           * RTDS_stringToMessageData(long messageNumber, long * dataLength, void ** dataPointer, char * dataString);
extern void             RTDS_messageDataToString(char ** buffer, long messageNumber, long dataLength, void * dataPointer, int level);
#endif


/*
** TRACE FUNCTION:
** ---------------
** Only needed when simulating or tracing
*/
#if defined(RTDS_SOCKET_PORT)
extern int globalClientSocketId;
#endif
#if defined( RTDS_SIMULATOR ) || defined( RTDS_MSC_TRACER )
extern void RTDS_SimulatorTrace( enum RTDS_EventType event , void *eventParameter1 , long eventParameter2 , RTDS_GlobalProcessInfo *currentContext , int waitAck );
#endif


/*
** EXTERNAL VARIABLES:
** -------------------
** Variables declared as global to the all the program
*/
extern RTDS_Scheduler           * RTDS_SystemScheduler;
extern RTDS_GlobalProcessInfo   * RTDS_globalProcessInfo;
extern RTDS_GlobalSemaphoreInfo * RTDS_globalSemaphoreInfo;

#if defined( RTDS_SIMULATOR ) || defined( RTDS_MSC_TRACER ) || defined( RTDS_FORMAT_TRACE )
    extern RTDS_GlobalTraceInfo RTDS_globalTraceEntry;
    /* Global variable pointing to decoded parmaters */
    extern char *RTDS_globalPrintableParameters;
#endif

#if defined( RTDS_SIMULATOR )
    extern void *RTDS_globalMessageUniqueIdPool;
#endif


#ifdef __cplusplus
}
#endif

#endif /* End of    _RTDS_OS_H_ */
