

/* ***************************************************************** */
/* $(RTDS_HOME)/share/ccg/crtosless/bricks/RTDS_Startup_begin.c begins */
/* PragmaDev RTDS RTOS-less for C integration */

#if defined( RTDS_CMD_INTERPRETER )
    #include "RTDS_CmdInterpreter.h"
#endif

#ifdef RTDS_SOCKET_PORT
    int globalClientSocketId = 0;
#endif

#ifdef __cplusplus
    extern "C" 
        {
        void RTDS_StopProgram( void );
        }
#endif

/* Pointers to global list of information on processes and semaphores */
RTDS_GlobalProcessInfo    * RTDS_globalProcessInfo = NULL;
RTDS_GlobalSemaphoreInfo  * RTDS_globalSemaphoreInfo = NULL;

/* Declarations for code coverage and dynamic trace if needed */
RTDS_COVERAGE_DECL
RTDS_DTRACE_ACKNOWLEDGE_DECL


/*
** FUNCTION RTDS_Start:
** --------------------
** Starts the whole system.
*/

void RTDS_Start( void )
    {
    RTDS_GlobalProcessInfo  * RTDS_currentContext;
    RTDS_Scheduler * RTDS_parentScheduler;

    #ifdef RTDS_COVERAGE_INIT
    RTDS_COVERAGE_INIT;
    #endif

#ifdef RTDS_SIMULATOR
    RTDS_globalTraceEntry.event = RTDS_systemError;
    RTDS_globalTraceEntry.currentContext = NULL;
#endif
 
#if defined( RTDS_BACK_TRACE_MAX_EVENT_NUM ) && defined( RTDS_SIMULATOR )
    RTDS_TraceInit();
#endif

#if defined( RTDS_SIMULATOR )
    /* Set up the message unique id pool */
    RTDS_globalMessageUniqueIdPool = RTDS_MALLOC( RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE );
        {
        int RTDS_i;
        unsigned char *RTDS_index;

        RTDS_index = ( unsigned char * )RTDS_globalMessageUniqueIdPool;
        for( RTDS_i = 0 ; RTDS_i < RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE ; RTDS_i++ )
            {
            *RTDS_index = 0x00;
            RTDS_index++;
            }
        }
#endif

    /* Create scheduler for the whole system */
    RTDS_SystemScheduler = (RTDS_Scheduler*)RTDS_MALLOC(sizeof(RTDS_Scheduler));
    RTDS_Scheduler_init(RTDS_SystemScheduler, NULL);
    
    /* Set it as parent scheduler for pseudo-task */
    RTDS_parentScheduler = RTDS_SystemScheduler;
    
    /* Set up the process context needed to create tasks */
    RTDS_currentContext = ( RTDS_GlobalProcessInfo * )RTDS_MALLOC( sizeof( RTDS_GlobalProcessInfo ) );
    if ( RTDS_currentContext == NULL )
        {
        RTDS_SYSTEM_ERROR( RTDS_ERROR_STARTUP_CONTEXT_MALLOC );
        }
    RTDS_currentContext->myRtosTaskId = (RTDS_RtosTaskId)0;
    RTDS_currentContext->sdlProcessNumber = 0;
    RTDS_currentContext->mySdlInstanceId = NULL;
    RTDS_currentContext->parentSdlInstanceId = NULL;
    RTDS_currentContext->offspringSdlInstanceId = NULL;
    RTDS_currentContext->sdlState = 0;
    RTDS_currentContext->currentMessage = NULL;
    RTDS_currentContext->timerList = NULL;
    RTDS_currentContext->readSaveQueue = NULL;
    RTDS_currentContext->writeSaveQueue = NULL;
    RTDS_currentContext->next = NULL;

/* $(RTDS_HOME)/share/ccg/crtosless/bricks/RTDS_Startup_begin.c ends */
/* *************************************************************** */
