/* ****************************************************************** */
/* $(RTDS_HOME)/share/ccg/FreeRTOS/bricks/RTDS_Startup_begin.c begins */
/* PragmaDev RTDS FreeRTOS integration                                */
#ifdef RTDS_FREERTOS_WINDOWS_SIMULATOR
    #ifdef RTDS_SOCKET_PORT
        #include "RTDS_TCP_Client.h"
    #endif

    #ifdef RTDS_CMD_INTERPRETER
        #include "RTDS_CmdInterpreter.h"
    #endif

    #ifdef RTDS_FORMAT_TRACE
        #include "RTDS_FormatTrace.h"
    #endif

    #ifdef RTDS_SOCKET_PORT
     int globalClientSocketId = 0;
    #endif
#endif

/* Pointers to global list of information on processes and semaphores */
RTDS_GlobalProcessInfo		*RTDS_globalProcessInfo=NULL;
RTDS_GlobalSemaphoreInfo	*RTDS_globalSemaphoreInfo=NULL;

RTDS_COVERAGE_DECL
RTDS_START_SYNCHRO_DECL
RTDS_CRITICAL_SECTION_DECL

#ifdef RTDS_FREERTOS_WINDOWS_SIMULATOR
    /* Macros for traces through socket */
    RTDS_CRITICAL_TRACE_SECTION_DECL;
    RTDS_SOCKET_ACCESS_DECL
    RTDS_DTRACE_ACKNOWLEDGE_DECL;
#endif


/* **************************************************************** *
 *	RTDS_Start
 * **************************************************************** */
void vApplicationMallocFailedHook( void )
{
	/* Can be implemented if required. */
}


/* **************************************************************** *
 *	RTDS_Start
 * **************************************************************** *
 * That is RTDS generated code entry point.
 * This task or function will create all the static processes and
 * semaphores and when everyone is ready will let them go.
 * **************************************************************** *
 * Parameters:
 *	 none
 * Returns:
 *	 nothing
 * **************************************************************** *
 * Context:
 *	 Called by main
 * **************************************************************** */

int RTDS_Start(void)
{
RTDS_GlobalProcessInfo *RTDS_currentContext=NULL;
int RTDS_i;

RTDS_COVERAGE_INIT;

#ifdef RTDS_SIMULATOR
/* Set up the message unique id pool */
RTDS_globalMessageUniqueIdPool = (unsigned char *)RTDS_MALLOC(RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE);
	{
	unsigned char *RTDS_index;

	RTDS_index = RTDS_globalMessageUniqueIdPool;
	for(RTDS_i=0;RTDS_i<RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE;RTDS_i++)
		{
		*RTDS_index=0x00;
		RTDS_index++;
		}
	}
#endif

#if defined(RTDS_SIMULATOR) && defined(RTDS_BACK_TRACE_MAX_EVENT_NUM)
/* Initialize circular buffer to trace in RAM */
RTDS_TraceInit();
#endif

/* Set up the process context needed to create tasks */
RTDS_currentContext = (RTDS_GlobalProcessInfo *)RTDS_MALLOC(sizeof(RTDS_GlobalProcessInfo));
if ( RTDS_currentContext == NULL )
	RTDS_SYSTEM_ERROR(RTDS_ERROR_STARTUP_CONTEXT_MALLOC);
RTDS_currentContext->sdlProcessNumber = 0;
RTDS_currentContext->myRtosTaskId = ( RTDS_RtosTaskId )0;
RTDS_currentContext->sdlState = 0;
RTDS_currentContext->next = NULL;
RTDS_currentContext->parentSdlInstanceId = NULL;
RTDS_currentContext->offspringSdlInstanceId = NULL;
RTDS_currentContext->currentMessage = NULL;
RTDS_currentContext->timerList = NULL;
RTDS_currentContext->mySdlInstanceId = NULL;

RTDS_SOCKET_ACCESS_INIT;
RTDS_CRITICAL_SECTION_INIT;
RTDS_START_SYNCHRO_INIT;
RTDS_CRITICAL_TRACE_SECTION_INIT;

/* $(RTDS_HOME)/share/ccg/FreeRTOS/bricks/RTDS_Startup_begin.c ends */
/* **************************************************************** */
