#ifndef _RTDS_COMMON_H_
#define _RTDS_COMMON_H_

#include <stdlib.h>
#include <string.h>

class RTDS_SdlInstanceId
{
  public:
    int                 processNumber;
    unsigned int        instanceNumber;
    unsigned int        componentNumber;
    
    // Contructor
    RTDS_SdlInstanceId();
    RTDS_SdlInstanceId(int processNumber);
    RTDS_SdlInstanceId(int processNumber, unsigned int instanceNumber, unsigned int componentNumber);
    
    // Copy constructor (reference)
    RTDS_SdlInstanceId(const RTDS_SdlInstanceId &instance);

    // Copy constructor (pointer)
    RTDS_SdlInstanceId(const RTDS_SdlInstanceId *instance);
      
    // Assign operator (reference)
    RTDS_SdlInstanceId &operator=(const RTDS_SdlInstanceId &instance);
    
    // Assign operator (pointer)
    RTDS_SdlInstanceId &operator=(const RTDS_SdlInstanceId *instance);
    
    // Equality operator (reference)
    bool operator==(const RTDS_SdlInstanceId &instance);
    
    // Equality operator (pointer)
    bool operator==(const RTDS_SdlInstanceId *instance);
};

typedef RTDS_SdlInstanceId RTDS_PID;

typedef struct RTDS_MessageHeader
{
  int                   messageNumber;
  int                   messageUniqueId;
  int                   timerUniqueId;
  RTDS_SdlInstanceId    sender;
  RTDS_SdlInstanceId    receiver;
  long                  dataLength;
  unsigned char       * pData;
  RTDS_MessageHeader  * next;
} RTDS_MessageHeader;

typedef struct RTDS_GlobalProcessInfo
{
  RTDS_SdlInstanceId    mySdlInstanceId;
  RTDS_SdlInstanceId    parentSdlInstanceId;
  RTDS_SdlInstanceId    offspringSdlInstanceId;
  RTDS_MessageHeader  * currentMessage;
  RTDS_MessageHeader  * readSaveQueue;
  RTDS_MessageHeader  * writeSaveQueue;
  int                   sdlState;
} RTDS_GlobalProcessInfo;

#endif
