#include <string.h>

#include "RTDS_Deployment.h"
#include "RTDS_Scheduler.h"


RTDS_DeplNodeList * RTDS_DeplNode::nodeList                   = NULL;
unsigned int    RTDS_DeplNode::nextNodeUniqueId           = 0;
unsigned int    RTDS_DeplComponent::nextComponentUniqueId = 0;

RTDS_DeplNode::RTDS_DeplNode(const char *nodeId)
  {
  this->nodeId = (char *) malloc(strlen(nodeId) + 1);
  strcpy(this->nodeId, nodeId);
  this->nodeUniqueId = RTDS_DeplNode::nextNodeUniqueId++;
  this->componentList = NULL;
  this->sdlState = 0;
  RTDS_DeplNodeList *nodeElement = (RTDS_DeplNodeList *) malloc(sizeof(RTDS_DeplNodeList));
  nodeElement->node = this;
  nodeElement->next = RTDS_DeplNode::nodeList;
  RTDS_DeplNode::nodeList = nodeElement;
  }

RTDS_DeplNode::~RTDS_DeplNode()
  {
  // Clean id
  free(this->nodeId);
  // Remove node from list
  RTDS_DeplNodeList *currNode, *prevNode = NULL;
  for (currNode = RTDS_DeplNode::nodeList; currNode != NULL; prevNode = currNode, currNode = currNode->next)
    {
    if (currNode->node == this)
      {
        if (prevNode == NULL)
          {
          RTDS_DeplNode::nodeList = currNode->next;
          }
        else
          {
          prevNode->next = currNode->next;
          }
        free(currNode);
        break;
      }
    }
  }

void RTDS_DeplNode::registerComponent(RTDS_DeplComponent *component)
  {
  RTDS_DeplComponentList *componentElement = (RTDS_DeplComponentList *) malloc(sizeof(RTDS_DeplComponentList));
  componentElement->component = component;
  componentElement->next = componentList;
  componentList = componentElement;
  }

RTDS_DeplComponent *RTDS_DeplNode::getComponent(unsigned int componentUniqueId)
  {
  RTDS_DeplNodeList *nodeElement;
  RTDS_DeplComponentList *componentElement;
  for (nodeElement = RTDS_DeplNode::nodeList; nodeElement != NULL; nodeElement = nodeElement->next)
    {
    for (componentElement = nodeElement->node->componentList; componentElement != NULL; componentElement = componentElement->next)
      {
      if (componentElement->component->componentUniqueId == componentUniqueId)
        {
        return componentElement->component;
        }
      }
    }
  return NULL;
  }

RTDS_DeplComponent *RTDS_DeplNode::getComponent(int processNumber, RTDS_DeplComponent *ignoredComponent)
  {
  RTDS_DeplNodeList *nodeElement;
  RTDS_DeplComponentList *componentElement;
  RTDS_ProcList *processElement;
  // Lookup this node
  for (componentElement = this->componentList; componentElement != NULL; componentElement = componentElement->next)
    {
    if (componentElement->component == ignoredComponent)
      {
      continue;
      }
    for (processElement = componentElement->component->processList; processElement != NULL; processElement = processElement->next)
      {
      if (processElement->processNumber == processNumber)
        {
        return componentElement->component;
        }
      }
    }
  // Lookup other nodes
  for (nodeElement = RTDS_DeplNode::nodeList; nodeElement != NULL; nodeElement = nodeElement->next)
    {
    if (nodeElement->node == this)
      {
      continue;
      }
    for (componentElement = nodeElement->node->componentList; componentElement != NULL; componentElement = componentElement->next)
      {
      if (componentElement->component == ignoredComponent)
        {
        continue;
        }
      for (processElement = componentElement->component->processList; processElement != NULL; processElement = processElement->next)
        {
        if (processElement->processNumber == processNumber)
          {
          return componentElement->component;
          }
        }
      }
    }
  return NULL;
  }

RTDS_DeplNode *RTDS_DeplNode::getNode(unsigned int nodeUniqueId, const char *nodeId)
  {
  RTDS_DeplNodeList *nodeElement;
  for (nodeElement = RTDS_DeplNode::nodeList; nodeElement != NULL; nodeElement = nodeElement->next)
    {
    if (nodeId != NULL)
      {
      if (strcmp((const char *) nodeElement->node->nodeId, nodeId) == 0)
        {
        return nodeElement->node;
        }
      }
    else
      {
      if (nodeElement->node->nodeUniqueId == nodeUniqueId)
        {
        return nodeElement->node;
        }
      }
    }
  return NULL;
  }

RTDS_DeplComponent::RTDS_DeplComponent(int componentNumber, const char *nodeId, const char *componentId)
  {
  this->componentNumber = componentNumber;
  this->componentId = (char *) malloc(strlen(componentId) + 1);
  strcpy(this->componentId, componentId);
  this->componentUniqueId = ++RTDS_DeplComponent::nextComponentUniqueId;
  this->scheduler = new RTDS_Scheduler();
  this->scheduler->component = this;
  this->processList = NULL;
  this->node = RTDS_DeplNode::getNode(0, nodeId);
  if (this->node == NULL)
    {
    this->node = new RTDS_DeplNode(nodeId);
    }
  this->node->registerComponent(this);
  }

RTDS_DeplComponent::~RTDS_DeplComponent()
  {
  // Clean id
  free(this->componentId);
  // Clean scheduler if any
  if (this->scheduler != NULL)
    {
    delete this->scheduler;
    }
  // Clean processes
  while (this->processList != NULL)
    {
    RTDS_ProcList *processElement = this->processList;
    this->processList = processElement->next;
    free(processElement);
    }
  // Remove from list
  RTDS_DeplComponentList *currComponent, *prevComponent = NULL;
  for (currComponent = this->node->componentList; currComponent != NULL; prevComponent = currComponent, currComponent = currComponent->next)
    {
    if (currComponent->component == this)
      {
        if (prevComponent == NULL)
          {
          this->node->componentList = currComponent->next;
          }
        else
          {
          prevComponent->next = currComponent->next;
          }
        free(currComponent);
        break;
      }
    }
  // Clean node if it has no components left
  if (this->node->componentList == NULL)
    {
    delete this->node;
    }
  }

void RTDS_DeplComponent::createProcess(int processNumber, int instanceCount)
  {
  RTDS_ProcList *processElement = (RTDS_ProcList *) malloc(sizeof(RTDS_ProcList));
  processElement->processNumber = processNumber;
  processElement->next = processList;
  processList = processElement;
  while (instanceCount > 0)
    {
    scheduler->createInstance(processNumber);
    --instanceCount;
    }
  }
