#ifndef _RTDS_DEPLOYMENT_
#define _RTDS_DEPLOYMENT_

#include <stdlib.h>

class RTDS_Scheduler;
class RTDS_DeplNode;
class RTDS_DeplComponent;

struct RTDS_ProcList
{
  int                           processNumber;
  RTDS_ProcList               * next;
};

struct RTDS_DeplComponentList
{
  RTDS_DeplComponent          * component;
  RTDS_DeplComponentList      * next;
};

struct RTDS_DeplNodeList
{
  RTDS_DeplNode               * node;
  RTDS_DeplNodeList           * next;
};

class RTDS_DeplNode
{
  public:
    static RTDS_DeplNodeList  * nodeList;
    static unsigned int         nextNodeUniqueId;
    char                      * nodeId;
    unsigned int                nodeUniqueId;
    RTDS_DeplComponentList    * componentList;
    int                         sdlState;
  
  public:
    RTDS_DeplNode(const char *nodeId);
    ~RTDS_DeplNode();
    void registerComponent(RTDS_DeplComponent *component);
    RTDS_DeplComponent *getComponent(unsigned int componentUniqueId);
    RTDS_DeplComponent *getComponent(int processNumber, RTDS_DeplComponent *ignoredComponent = NULL);
    static RTDS_DeplNode *getNode(unsigned int nodeUniqueId, const char *nodeId = NULL);     
};

class RTDS_DeplComponent
{
  public:    
    static unsigned int         nextComponentUniqueId;
    int                         componentNumber;
    char                      * componentId;
    unsigned int                componentUniqueId;
    RTDS_ProcList             * processList;
    RTDS_Scheduler            * scheduler;
    RTDS_DeplNode             * node;

  public:
    RTDS_DeplComponent(int componentNumber, const char *nodeId, const char *componentId);
    ~RTDS_DeplComponent();
    void createProcess(int processNumber, int instanceCount);
};

#endif
