#include <stdlib.h>
#include <string.h>

#include "RTDS_MutexSemaphoreProcess.h"
#include "RTDS_Common.h"
#include "RTDS_InternalConstants.h"


RTDS_MutexSemaphoreProcess::RTDS_MutexSemaphoreProcess(RTDS_Scheduler* parentScheduler):	RTDS_SemaphoreProcess(parentScheduler)
  {
  memset(&takerInstanceId, 0, sizeof(RTDS_SdlInstanceId));
  takeCount = 0;
  }

short RTDS_MutexSemaphoreProcess::isAvailable()
  {
  return takeCount == 0;
  }

short RTDS_MutexSemaphoreProcess::RTDS_continuousSignals(int *lowestPriority) 
  {
  return 0;
  }

short RTDS_MutexSemaphoreProcess::RTDS_executeTransition(RTDS_MessageHeader *currentMessage) 
  {
  static RTDS_SdlInstanceId waiterId;
  memset(&waiterId, 0, sizeof(RTDS_SdlInstanceId));
  // Remember previous state
  RTDS_sdlStatePrev = RTDS_currentContext->sdlState;
  // Remember message as current one
  RTDS_currentContext->currentMessage = currentMessage;
  // Standard double-switch for all other messages
  if (RTDS_currentContext->currentMessage != NULL)
    {
    RTDS_senderId = RTDS_currentContext->currentMessage->sender;
    switch (RTDS_currentContext->currentMessage->messageNumber)
      {
      // Take attempt
      case RTDS_message_RTDS_takeSemaphore:
        // If semaphore is available or already taken by same instance
        if (takerInstanceId.instanceNumber == 0 || takerInstanceId.instanceNumber == RTDS_senderId.instanceNumber)
          {
          // Set taker and increase take count
          takerInstanceId = RTDS_senderId;
          ++takeCount;
          // Take succeeded
          RTDS_msgQueueSendToId(RTDS_message_RTDS_takeSucceeded, 0, NULL, RTDS_senderId);
          }
        // If semaphore is not available or taken by another instance
        else
          {
          // Add message sender to list of waiting processes
          pushWaitingInstance(RTDS_senderId);
          }
        break;

      // Give
      case RTDS_message_RTDS_giveSemaphore:
        // Check that the giver instance is actually the taker
        if (takerInstanceId.instanceNumber == RTDS_senderId.instanceNumber)
          {
          // Decrease take count
          --takeCount;
          // If it reaches 0, semaphore is free
          if (takeCount == 0)
            {
            memset(&takerInstanceId, 0, sizeof(RTDS_SdlInstanceId));
            // If there are waiting instances, pop first one from the list
            waiterId = popWaitingInstance();
            if (waiterId.instanceNumber > 0)
              {
              RTDS_msgQueueSendToId(RTDS_message_RTDS_takeSucceeded, 0, NULL, waiterId);
              // Remember it as the taker
              takerInstanceId = waiterId;
              takeCount = 1;
              }
            }
          }
        break;

      // Take cancel
      case RTDS_message_RTDS_cancelTake:
        // Remove message sender from list of instances waiting for semaphore
        removeWaitingInstance(RTDS_senderId);
        break;
      }
    free(RTDS_currentContext->currentMessage);
    RTDS_currentContext->currentMessage = NULL;
    }
  return 0;
  }
