
/* Begin of RTDS_Startup_begin_cpp.c */
  
  /* Nodes */
  ns3::NodeContainer nodes;
  nodes.Create(RTDS_DeplNode::nextNodeUniqueId);
  /* Topology (grid with cell size 100m) */
  ns3::MobilityHelper mobility;
  
#ifdef RTDS_DEPL_RANDOM_TOPO
   mobility.SetPositionAllocator("ns3::RandomBoxPositionAllocator");
   mobility.SetMobilityModel("ns3::ConstantPositionMobilityModel");
#else
  mobility.SetPositionAllocator("ns3::GridPositionAllocator",
    "MinX", ns3::DoubleValue(0.0),
    "MinY", ns3::DoubleValue(0.0),
    "DeltaX", ns3::DoubleValue(100.0),
    "DeltaY", ns3::DoubleValue(100.0),
    "GridWidth", ns3::UintegerValue(ceil(sqrt(RTDS_DeplNode::nextNodeUniqueId))),
    "LayoutType", ns3::StringValue("RowFirst"));
  mobility.SetMobilityModel("ns3::ConstantPositionMobilityModel");
#endif

  mobility.Install(nodes);
  
  /* Trace states, signals, processes, and semaphores */ 
  RTDS_DEPL_SIMULATOR_TRACE_START
  /* Trace nodes */
  fprintf(RTDS_traceFile, "  <nodes>\n");
  for (RTDS_DeplNodeList *nodeElement = RTDS_DeplNode::nodeList; nodeElement != NULL; nodeElement = nodeElement->next)
    {
    unsigned int id = nodeElement->node->nodeUniqueId;
    ns3::Vector position = nodes.Get(id)->GetObject<ns3::MobilityModel>()->GetPosition(); 
    fprintf(RTDS_traceFile, "    <node id=\"n%u\" name=\"%s\" x=\"%lf\" y=\"%lf\" z=\"%lf\" />\n", id, nodeElement->node->nodeId, position.x, position.y, 0.0);
    }
  fprintf(RTDS_traceFile, "  </nodes>\n");
  /* Trace components */
  fprintf(RTDS_traceFile, "  <components>\n");
  for (RTDS_DeplNodeList *nodeElement = RTDS_DeplNode::nodeList; nodeElement != NULL; nodeElement = nodeElement->next)
    {
    for (RTDS_DeplComponentList *componentElement = nodeElement->node->componentList; componentElement != NULL; componentElement = componentElement->next)
      {
      fprintf(RTDS_traceFile, "    <component id=\"c%u\" node=\"n%u\" name=\"%s\" />\n", componentElement->component->componentUniqueId, nodeElement->node->nodeUniqueId, componentElement->component->componentId);
      }
    }
  fprintf(RTDS_traceFile, "  </components>\n");
  fprintf(RTDS_traceFile, "  <events>\n");

#ifdef RTDS_DEPL_WIFI
  
  /* Network devices and channel */
  ns3::WifiHelper wifi;
  ns3::YansWifiPhyHelper wifiPhy =  ns3::YansWifiPhyHelper::Default();
  wifiPhy.Set("RxGain", ns3::DoubleValue(0));
  ns3::YansWifiChannelHelper wifiChannel ;
  wifiChannel.SetPropagationDelay("ns3::ConstantSpeedPropagationDelayModel");
  wifiChannel.AddPropagationLoss("ns3::RangePropagationLossModel", "MaxRange", ns3::DoubleValue(300.0));
  wifiPhy.SetChannel(wifiChannel.Create());
  ns3::NqosWifiMacHelper wifiMac = ns3::NqosWifiMacHelper::Default();
  wifi.SetStandard(ns3::WIFI_PHY_STANDARD_80211b);
  wifi.SetRemoteStationManager("ns3::IdealWifiManager");
  wifiMac.SetType("ns3::AdhocWifiMac");
  ns3::NetDeviceContainer devices = wifi.Install(wifiPhy, wifiMac, nodes);
  /* Routing */
  ns3::OlsrHelper olsr;
  ns3::Ipv4StaticRoutingHelper staticRouting;
  ns3::Ipv4ListRoutingHelper list;
  list.Add(staticRouting, 0);
  list.Add(olsr, 10);
  /* Internet stack */
  ns3::InternetStackHelper internet;
  internet.SetRoutingHelper(list);
  internet.Install(nodes);

#else
  
  /* Network devices and channel */
  ns3::CsmaHelper csma;
  ns3::NetDeviceContainer devices = csma.Install(nodes);
  /* Routing */
  ns3::Ipv4GlobalRoutingHelper::PopulateRoutingTables();
  /* Internet stack */
  ns3::InternetStackHelper internet;
  internet.Install(nodes);

#endif

  /* IP addresses */
  for (RTDS_DeplNodeList *nodeElement = RTDS_DeplNode::nodeList; nodeElement != NULL; nodeElement = nodeElement->next)
    {
    ns3::Ptr<ns3::NetDevice> device = devices.Get(nodeElement->node->nodeUniqueId);
    ns3::Ptr<ns3::Node> node = device->GetNode();
    ns3::Ptr<ns3::Ipv4> ipv4 = node->GetObject<ns3::Ipv4> ();
    int32_t interface = ipv4->GetInterfaceForDevice(device);
    if (interface == -1)
      {
      interface = ipv4->AddInterface(device);
      }
    ipv4->AddAddress(interface, ns3::Ipv4InterfaceAddress(ns3::Ipv4Address(nodeElement->node->nodeId), ns3::Ipv4Mask("255.0.0.0")));
    ipv4->SetMetric(interface, 1);
    ipv4->SetUp(interface);
    }
  
/* End of RTDS_Startup_begin_cpp.c */
