/* ***************************************************************/
/* $(RTDS_HOME)/share/ccg/ose52/bricks/RTDS_Startup_begin.c begins */
/* PragmaDev RTDS OSE 52 integration                          */
#ifdef RTDS_BACK_TRACE_MAX_EVENT_NUM
#include "RTDS_BackTrace.h"
#endif
#if defined( RTDS_SIMULATOR ) || defined( RTDS_MSC_TRACE ) || defined( RTDS_FORMAT_TRACE ) || defined( RTDS_SOCKET_IP_ADDRESS )
#include "RTDS_Trace.h"
#endif

/* Pointers to global list of information on processes and semaphores */
RTDS_GlobalProcessInfo * RTDS_globalProcessInfo = NULL;
RTDS_GlobalSemaphoreInfo * RTDS_globalSemaphoreInfo = NULL;

RTDS_COVERAGE_DECL;
RTDS_CRITICAL_SECTION_DECL;

void RTDS_Start( void )
    {
    RTDS_GlobalProcessInfo * RTDS_processInfo = NULL;
    RTDS_GlobalProcessInfo * RTDS_currentContext = NULL;
    
    RTDS_COVERAGE_INIT;
    
    dbgprintf( "RTDS_Start: INIT\n");
    
#if defined( RTDS_SIMULATOR ) || defined( RTDS_MSC_TRACE ) || defined( RTDS_FORMAT_TRACE )
    /* Set up the message unique id pool */
    RTDS_globalMessageUniqueIdPool = ( unsigned char * )RTDS_MALLOC( RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE );
        {
        int RTDS_i;
        unsigned char * RTDS_index;
        
        RTDS_index = RTDS_globalMessageUniqueIdPool;
        for( RTDS_i = 0; RTDS_i < RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE; RTDS_i++ )
            {
            *RTDS_index = 0x00;
            RTDS_index++;
            }
        }
#endif
    
#if defined( RTDS_BACK_TRACE_MAX_EVENT_NUM ) && defined( RTDS_SIMULATOR )
/* Initialize circular buffer to trace in RAM */
    RTDS_TraceInit();
#endif
    
/* Set up the process context needed to create tasks */
    RTDS_currentContext = ( RTDS_GlobalProcessInfo * )RTDS_MALLOC( sizeof( RTDS_GlobalProcessInfo ) );
    if ( RTDS_currentContext == NULL )
        {
        RTDS_SYSTEM_ERROR( RTDS_ERROR_STARTUP_CONTEXT_MALLOC );
        }
    RTDS_currentContext->sdlProcessNumber = 0;
    RTDS_currentContext->sdlState = 0;
    RTDS_currentContext->currentMessage = NULL;
    RTDS_currentContext->timerList = NULL;
    RTDS_currentContext->myRtosTaskId = 0;
    RTDS_currentContext->mySdlInstanceId = NULL;
    RTDS_currentContext->parentSdlInstanceId = NULL;
    RTDS_currentContext->offspringSdlInstanceId = NULL;
#ifdef RTDS_SIMULATOR
    RTDS_currentContext->priority = 0;
#endif
    RTDS_currentContext->readSaveQueue = NULL;
    RTDS_currentContext->writeSaveQueue = NULL;
    RTDS_currentContext->next = NULL;
    
    dbgprintf( "RTDS_Start: Initialize...\n");
    
#ifdef RTDS_SIMULATOR
    RTDS_SIMULATOR_TRACE( RTDS_initDone, NULL, NULL, RTDS_currentContext );
#endif
    
    RTDS_CRITICAL_SECTION_INIT;
/* $(RTDS_HOME)/share/ccg/ose52/bricks/RTDS_Startup_begin.c ends */
/* *************************************************************** */
