#ifndef _RTDS_TTCN_MACRO_H_
#define _RTDS_TTCN_MACRO_H_

#include "RTDS_OS.h"
#include "RTDS_TTCN.h"
#include "RTDS_MACRO.h"

#ifdef __cplusplus
extern "C" {
#endif

/****************************************************************************************
 *                                                            RTDS_TTCN_MACRO
 * ------------------------------------------------------------------------------------ *
 * Macro called by TTCN-3 generated code.
 *
 * ************************************************************************************ *
 *                                                    TTCN KEYWORD DEFINITION:
 * ************************************************************************************ *
 * TTCN_SELF
 * ************************************************************************************ *
 *                                                    TTCN MESSAGE MACROS
 * ************************************************************************************ *
 * MACRO RTDS_NEW_MESSAGE_QUEUE
 * MACRO RTDS_DELETE_QUEUE
 * MACRO RTDS_MSG_QUEUE_SEND_TO_QUEUE_ID
 * MACRO RTDS_MSG_QUEUE_SEND_TO_QUEUE_ID_FROM_SUT
 * MACRO RTDS_MSG_QUEUE_SEND_TO_NAME_W_SENDER
 * MACRO RTDS_MSG_QUEUE_ID_READ
 * MACRO RTDS_MSG_QUEUE_ID_CHECK
 * MACRO RTDS_TTCN_UPDATE_FIRST_MESSAGE
 * ************************************************************************************ *
 *                                                    TTCN MEMORY MACROS
 * ************************************************************************************ *
 * MACRO RTDS_CHECKED_PTR_MALLOC
 * MACRO RTDS_REALLOC
 * MACRO RTDS_CHECKED_PTR_REALLOC
 * ************************************************************************************ *
 *                                                    TTCN TIMER MACROS
 * ************************************************************************************ *
 * MACRO RTDS_SLEEP
 * ************************************************************************************ *
 *                                                    TTCN COMPONENT MACROS
 * ************************************************************************************ *
 * MACRO RTDS_TTCN_COMPONENT_CREATE
 * ************************************************************************************ *
 *                                                    TTCN TEMPLATE MACROS
 * ************************************************************************************ *
 * MACRO RTDS_REG_TEMPLATE
 * ************************************************************************************ */

 

 
/************************************************************************************* *
 *                                    TTCN KEYWORD MACROS
 ************************************************************************************* */
 
/*
 * TTCN KEYWORD DEFINITION:
 * -------------------
 * Defines the SDL PARENT keyword. parentQueueId is given when taskSpawn is done.
 */

#define TTCN_SELF      RTDS_TTCN_currentComponent->ComponentID


/************************************************************************************* *
 *                                    TTCN MESSAGE MACROS
 ************************************************************************************* */
 
/*
 * MACRO RTDS_NEW_MESSAGE_QUEUE:
 * --------------------------
 * Create a message queue and store it
 */

#define RTDS_NEW_MESSAGE_QUEUE \
    RTDS_MsgQueueCreate()   

/*
 * MACRO RTDS_DELETE_QUEUE:
 * --------------------------
 * Delete a message queue
 */

#define RTDS_DELETE_QUEUE( QUEUEID ) \
    RTDS_MsgQDelete( QUEUEID )
    
/*
 * MACRO RTDS_MSG_QUEUE_SEND_TO_QUEUE_ID:
 * --------------------------
 * Sends a message to a message queue using its ID.
 */
 
#ifndef RTDS_MSG_QUEUE_SEND_TO_QUEUE_ID 
#define RTDS_MSG_QUEUE_SEND_TO_QUEUE_ID(MESSAGE_NUMBER, LENGTH_DATA, P_DATA, RECEIVER, PORTID) \
    RTDS_TTCNMsgQueueSend(MESSAGE_NUMBER, LENGTH_DATA, (unsigned char *) P_DATA, PORTID , RECEIVER, SELF, RTDS_currentContext);
#endif

/*
 * MACRO RTDS_MSG_QUEUE_SEND_TO_QUEUE_ID_FROM_SUT:
 * -----------------------------------------------
 * Sends a message to a message queue as if it came from the SUT, i.e using as sender
 * the component for the Test System Interface.
 */
 
#ifndef RTDS_MSG_QUEUE_SEND_TO_QUEUE_ID_FROM_SUT 
#define RTDS_MSG_QUEUE_SEND_TO_QUEUE_ID_FROM_SUT(MESSAGE_NUMBER, LENGTH_DATA, P_DATA, RECEIVER, PORTID) \
    { \
    RTDS_TTCN_GlobalComponentInfo * RTDS_tsi_comp; \
    for ( RTDS_tsi_comp = RTDS_TTCN_globalComponentInfo; RTDS_tsi_comp != NULL; RTDS_tsi_comp = RTDS_tsi_comp->next ) \
      { \
      if ( RTDS_tsi_comp->componentKindType == TCI_SYS_COMP ) break; \
      } \
    RTDS_TTCNMsgQueueSend(MESSAGE_NUMBER, LENGTH_DATA, (unsigned char *) P_DATA, PORTID , RECEIVER, \
                          (RTDS_tsi_comp == NULL) ? NULL : RTDS_tsi_comp->RTDS_currentContext->mySdlInstanceId, \
                          (RTDS_tsi_comp == NULL) ? NULL : RTDS_tsi_comp->RTDS_currentContext); \
    }
#endif


/*
** MACRO RTDS_MSG_QUEUE_SEND_TO_NAME_W_SENDER:
** -------------------------------------------
** Sends a message to a named process with an explicit sender.
*/

#ifndef RTDS_MSG_QUEUE_SEND_TO_NAME_W_SENDER 
#define RTDS_MSG_QUEUE_SEND_TO_NAME_W_SENDER(MESSAGE_NUMBER, LENGTH_DATA, P_DATA, RECEIVER_STRING, RECEIVER_NUMBER, SENDER_ID) \
  RTDS_MsgQueueSend(MESSAGE_NUMBER, LENGTH_DATA, (unsigned char *) P_DATA, RTDS_GetProcessQueueId(RECEIVER_NUMBER), SENDER_ID, RTDS_currentContext);
#endif


/*
 * MACRO RTDS_MSG_QUEUE_ID_READ:
 * --------------------------
 * Reads a message of a message queue using its ID.
 */
 
#ifndef RTDS_MSG_QUEUE_ID_READ 
#define RTDS_MSG_QUEUE_ID_READ(QUEUEID,CURRENT_MESSAGE) \
    RTDS_TTCNMsgQueueReceive(QUEUEID,RTDS_currentContext->mySdlInstanceId, (char *)CURRENT_MESSAGE, sizeof(RTDS_MessageHeader), RTDS_SEMAPHORE_TIME_OUT_FOREVER)
#endif

/*
 * MACRO RTDS_MSG_QUEUE_ID_CHECK:
 * --------------------------
 * Check if a message is present in a message queue using its ID.
 */
 
#ifndef RTDS_MSG_QUEUE_ID_CHECK 
#define RTDS_MSG_QUEUE_ID_CHECK(QUEUEID,CURRENT_MESSAGE) \
    RTDS_TTCN_MsgQueueCheck(QUEUEID,RTDS_currentContext->mySdlInstanceId, CURRENT_MESSAGE, sizeof(RTDS_MessageHeader), RTDS_SEMAPHORE_TIME_OUT_FOREVER)
#endif

/*
 * MACRO RTDS_TTCN_UPDATE_FIRST_MESSAGE
 * -------------------------------
 * Update first message of all component port
 */
    
#define RTDS_TTCN_UPDATE_FIRST_MESSAGE  \
    RTDS_TTCN_UpdateFirstMessage( RTDS_TTCN_currentComponent ); \
    RTDS_TTCN_UpdateTimerLists ( RTDS_TTCN_currentComponent ); \
    for (RTDS_TTCN_PortMappingInfo * RTDS_TmpUpPortMapping = RTDS_TTCN_currentComponent->portMappingInfo;RTDS_TmpUpPortMapping!=NULL;RTDS_TmpUpPortMapping = RTDS_TmpUpPortMapping->next) \
    { \
    if (strcmp(RTDS_TmpUpPortMapping->portId->portName,"systemQueue") == 0) \
    { \
    if (RTDS_TmpUpPortMapping->currentMessage == NULL) \
    { \
    } \
    if (RTDS_TmpUpPortMapping->currentMessage != NULL) \
    { \
    if (RTDS_TmpUpPortMapping->currentMessage->messageNumber == RTDS_message_RTDS_INTERNAL_TTCN_COMPONENT_STOP) \
    { \
    RTDS_SIMULATOR_TRACE(RTDS_messageReceived, RTDS_TmpUpPortMapping->currentMessage, SELF, RTDS_currentContext); \
    if (RTDS_TTCN_currentComponent->componentKindType == TCI_MTC_COMP)\
	{ \
	for (RTDS_TTCN_GlobalComponentInfo * tmpGlobalComponentInfo = RTDS_TTCN_globalComponentInfo; tmpGlobalComponentInfo != NULL; tmpGlobalComponentInfo = tmpGlobalComponentInfo->next) \
    { \
    if (tmpGlobalComponentInfo->componentKindType == TCI_PTC_COMP) \
    { \
    for (RTDS_TTCN_PortMappingInfo * tmpPortInfo = tmpGlobalComponentInfo->portMappingInfo; tmpPortInfo != NULL; tmpPortInfo = tmpPortInfo->next) \
    { \
    if (strcmp(tmpPortInfo->portId->portName , "systemQueue") == 0) \
    { \
    RTDS_MSG_QUEUE_SEND_TO_QUEUE_ID(RTDS_message_RTDS_INTERNAL_TTCN_COMPONENT_STOP, 0, NULL, tmpGlobalComponentInfo->RTDS_currentContext->mySdlInstanceId,tmpPortInfo->queueControlBlock); \
    while ( 1 ) \
    { \
    RTDS_SLEEP( 100 ); \
    RTDS_MSG_QUEUE_READ( RTDS_currentContext->currentMessage ); \
    RTDS_SIMULATOR_TRACE(RTDS_messageReceived, RTDS_currentContext->currentMessage, SELF, RTDS_currentContext); \
    if (RTDS_currentContext->currentMessage->messageNumber == RTDS_message_RTDS_INTERNAL_TTCN_COMPONENT_TERMINATED) \
    break; \
    } \
    } \
    } \
    } \
    } \
    } \
    RTDS_FREE(RTDS_TmpUpPortMapping->currentMessage); \
    RTDS_TmpUpPortMapping->currentMessage = NULL; \
    RTDS_TTCN_currentComponent->componentStatus = stoppedC; \
    return; \
    } \
    else \
    { \
    RTDS_FREE(RTDS_TmpUpPortMapping->currentMessage); \
    RTDS_TmpUpPortMapping->currentMessage = NULL; \
    } \
    } \
    } \
    }
    
/************************************************************************************* *
 *                                    TTCN MEMORY MACROS
 ************************************************************************************* */
    
/*
 * DEFINE FOR RTDS_CHECKED_PTR_MALLOC
 * ------------------------------
 * allocate memory and check OK
 */

#define RTDS_CHECKED_PTR_MALLOC(PTR, NB_EL, TYPE) \
    (PTR) = (TYPE*)RTDS_MALLOC((NB_EL) * sizeof(TYPE)); \
    if ((PTR) == NULL) { RTDS_SYSTEM_ERROR(RTDS_ERROR_MALLOC); }

/*
 * DEFINE FOR REALLOC
 * ------------------------------
 */

#define RTDS_REALLOC(OLD, SIZE ) \
    realloc(OLD, SIZE)

/*
 * DEFINE FOR RTDS_CHECKED_PTR_REALLOC
 * ------------------------------
 * re-allocate memory and check OK
 */

#define RTDS_CHECKED_PTR_REALLOC(PTR, NB_EL, TYPE) \
    PTR = (TYPE*)RTDS_REALLOC(PTR,NB_EL*sizeof(TYPE)); \
    if (PTR == NULL){RTDS_SYSTEM_ERROR(RTDS_ERROR_MALLOC);}

/************************************************************************************* *
 *                                    TTCN TIMER MACROS
 ************************************************************************************* */
    
/*
 * DEFINE FOR TIME MANIPULATION
 * ------------------------------
 */

#define RTDS_SLEEP( Time ) \
    usleep( Time )

/************************************************************************************* *
 *                                    TTCN COMPONENT MACROS
 ************************************************************************************* */    
    
/*
 * MACRO RTDS_TTCN_COMPONENT_CREATE:
 * -------------------
 * Create a thread for a TTCN component and wait for it to be ready.
 */

#define RTDS_TTCN_COMPONENT_CREATE(PROCESS_NAME, PROCESS_NUMBER, FUNCTION_ADDRESS, PRIORITY) \
    RTDS_PROCESS_CREATE(PROCESS_NAME, PROCESS_NUMBER, FUNCTION_ADDRESS, PRIORITY); \
    for ( ; ; )\
      { \
      RTDS_MessageHeader RTDS_testcaseReadyMessage; \
      RTDS_MSG_QUEUE_READ(&RTDS_testcaseReadyMessage); \
      RTDS_SIMULATOR_TRACE(RTDS_messageReceived, &RTDS_testcaseReadyMessage, SELF, RTDS_currentContext); \
      if (RTDS_testcaseReadyMessage.messageNumber == RTDS_message_RTDS_INTERNAL_TTCN_COMPONENT_READY) \
      { \
        RTDS_TTCN_GlobalComponentInfo * RTDS_NewComponentInfo2 = NULL; \
        RTDS_NewComponentInfo2 = (RTDS_TTCN_GlobalComponentInfo *)(RTDS_testcaseReadyMessage.pData); \
        RTDS_NewComponentInfo2->next  = RTDS_TTCN_globalComponentInfo; \
        RTDS_TTCN_globalComponentInfo = RTDS_NewComponentInfo2; \
        break; \
        } \
      }

    
/************************************************************************************* *
 *                                    TTCN TEMPLATE MACROS
 ************************************************************************************* */     
    
/*
 * MACRO RTDS_REG_TEMPLATE
 * -------------------------------
 * Call to register template in pool
 */

#define RTDS_REG_TEMPLATE(RTDS_TEMPLATETYPE) \
    RTDS_TTCN_RegisterTemplatePool( RTDS_TTCN_currentComponent, new RTDS_TEMPLATETYPE())

#ifdef __cplusplus
}
#endif

#endif


