#ifndef _RTDS_TRACE_H_
#define _RTDS_TRACE_H_
/*
 * The following macros indicates back trace configuration
 * They are defined in the generation profile
 * #define RTDS_BACK_TRACE_MAX_EVENT_NUM : maximum number of events to store
 * #define RTDS_BACK_TRACE_MESSAGE_DATA_SIZE : size of parameters to store
 */

/* Will only run with SDL-RT debugger */
#ifdef RTDS_SIMULATOR

#ifdef RTDS_BACK_TRACE_MAX_EVENT_NUM

typedef struct RTDS_TraceMessage
	{
	long							messageNumber;
	long							timerUniqueId;		/* If 0, normal message; otherwise unique id. for timer if message is a timer */
#ifdef RTDS_SIMULATOR
	unsigned long 		messageUniqueId;	/* Used by SDL-RT debugger to trace messages */
#endif
	RTDS_QueueId			sender; 					/* The message queue of the sender */
	long							dataLength; 			/* Length of data */
#if RTDS_BACK_TRACE_MESSAGE_DATA_SIZE != 0
	unsigned char 		pData[RTDS_BACK_TRACE_MESSAGE_DATA_SIZE]; 		/* Message data */
#endif
	} RTDS_TraceMessage;

typedef struct RTDS_TraceTimer
	{
	long							timerNumber;
	long							timerUniqueId;		/* If 0, normal message; otherwise unique id. for timer if message is a timer */
	unsigned long 		timeoutValue;
	} RTDS_TraceTimer;

typedef struct RTDS_TraceList
	{
	unsigned long 				systemTime;
	enum RTDS_EventType 	event;
	void									*eventParameter1;
	long									eventParameter2;
	RTDS_SdlInstanceId    *activeTask;
	union
		{
		RTDS_TraceMessage 	message;
		RTDS_TraceTimer 		timer;
		RTDS_SdlInstanceId  *pid;
		} eventSpecific;
	struct RTDS_TraceList 	*next;			/* Next message if used as a message queue */
	} RTDS_TraceList;

extern RTDS_TraceList
	*RTDS_globalTraceBufferAddress, 		 /* Address of the beginning trace buffer */
	*RTDS_globalTraceNextBufferAddress,  /* Address of the next trace to come */
	*RTDS_globalTraceBufferStartAddress; /* Address of the latest trace available. Start from here when analyzing. */

extern void RTDS_TraceInit(void);
extern void RTDS_TraceAdd(void);

#endif /* #ifdef RTDS_BACK_TRACE_MAX_EVENT_NUM */

#endif /* RTDS_SIMULATOR */

#endif /* _RTDS_TRACE_H_ */

